/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystems.fcs.CarouselClamp;
import org.lsst.ccs.subsystems.fcs.CarouselSensor;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCanOpenInterface;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCarouselClampController;
import org.lsst.ccs.subsystems.fcs.simulation.SimuTTC580;

public class CarouselClampTest {
    private static Subsystem subs = null;
    private static CarouselClamp clampXminus1;
    private static CarouselClamp clampXplus1;
    private static SimuCarouselClampController clampXminusController;
    private static SimuCarouselClampController clampXplusController;
    private static ComponentLookup lookup;
    private static CarouselSensor filterPresenceXminusSensor1;
    private static CarouselSensor lockSensorXminus1;
    private static SimuCanOpenInterface canInterface;
    private static CanOpenProxy tcpProxy;
    private static SimuTTC580 ttc580;
    private static short socketID;
    private static int LOCKA;
    private static int LOCKB;
    private static int LOCKC;
    private static int FILTERPRESENCEA;
    private static int FILTERPRESENCEB;
    private static int FILTERPRESENCEC;

    @BeforeClass
    public static void before() throws Exception {
        System.out.println("********************************************************************************");
        System.out.println("                   TESTS OF CAROUSEL CLAMP");
        System.out.println("********************************************************************************");
        subs = BootUtils.getSubsystemFromFile((String)"testCarouselClamp", (String)"");
        subs.startAgent();
        subs.waitFor(state -> state.isInState((Enum)PhaseState.OPERATIONAL), 60L, TimeUnit.SECONDS);
        lookup = subs.getComponentLookup();
        clampXminus1 = (CarouselClamp)lookup.getComponentByName("clampXminus1");
        clampXminusController = (SimuCarouselClampController)lookup.getComponentByName("clampXminusController");
        clampXminusController.initializeAndCheckHardware();
        Assert.assertTrue((String)"carouselController is initialized", (boolean)clampXminusController.isInitialized());
        clampXplus1 = (CarouselClamp)lookup.getComponentByName("clampXplus1");
        clampXplusController = (SimuCarouselClampController)lookup.getComponentByName("clampXplusController");
        clampXplusController.initializeAndCheckHardware();
        Assert.assertTrue((String)"carouselController is initialized", (boolean)clampXplusController.isInitialized());
        filterPresenceXminusSensor1 = (CarouselSensor)lookup.getComponentByName("filterPresenceXminus1");
        lockSensorXminus1 = (CarouselSensor)lookup.getComponentByName("lockSensorXminus1");
        canInterface = (SimuCanOpenInterface)lookup.getComponentByName("canInterface");
        tcpProxy = (CanOpenProxy)lookup.getComponentByName("tcpProxy");
        ttc580 = (SimuTTC580)lookup.getComponentByName("hyttc580");
        System.out.println("***  initialization ***");
        clampXminus1.setController((EPOSController)clampXminusController);
        System.out.println("getLockStatus");
        FcsEnumerations.LockStatus expResult = FcsEnumerations.LockStatus.UNKNOWN;
        FcsEnumerations.LockStatus result = clampXminus1.getLockStatus();
        Assert.assertEquals((String)"At beginning LockStatus is UNKNOWN", (Object)expResult, (Object)result);
        System.out.println("=> ttc580 = " + ttc580.toString());
        ttc580.initializeAndCheckHardware();
        System.out.println("=> canInterface pdoData=" + canInterface.sync().toString());
        System.out.println("=> tcpProxy pdoData=" + tcpProxy.sync().toString());
        clampXminus1.setLockSensorValueA(Integer.valueOf(LOCKA));
        clampXminus1.setLockSensorValueB(Integer.valueOf(LOCKB));
        clampXminus1.setLockSensorValueC(Integer.valueOf(LOCKC));
        clampXplus1.setLockSensorValueA(Integer.valueOf(LOCKA));
        clampXplus1.setLockSensorValueB(Integer.valueOf(LOCKB));
        clampXplus1.setLockSensorValueC(Integer.valueOf(LOCKC));
        clampXminus1.setFilterPresenceValueA(Integer.valueOf(FILTERPRESENCEA));
        clampXminus1.setFilterPresenceValueB(Integer.valueOf(FILTERPRESENCEB));
        clampXminus1.setFilterPresenceValueC(Integer.valueOf(FILTERPRESENCEC));
        clampXplus1.setFilterPresenceValueA(Integer.valueOf(FILTERPRESENCEA));
        clampXplus1.setFilterPresenceValueB(Integer.valueOf(FILTERPRESENCEB));
        clampXplus1.setFilterPresenceValueC(Integer.valueOf(FILTERPRESENCEC));
    }

    @AfterClass
    public static void after() throws Exception {
        System.out.println("*******************************************************************");
        System.out.println("********* end of TESTS OF CAROUSEL CLAMP              *************");
        System.out.println("*******************************************************************");
        subs.shutdown();
        subs.waitFor(state -> state.isInState((Enum)PhaseState.OFF_LINE), 30L, TimeUnit.SECONDS);
    }

    @Before
    public void setUp() throws DriverException {
        long pdoVal = (long)Math.pow(2.0, 61.0);
        ttc580.setPdo1(pdoVal);
        int expResult = 1;
        short result = ttc580.getSocketId(pdoVal);
        Assert.assertEquals((String)("pdoVal = " + pdoVal + " => socketID should be = " + result), (long)expResult, (long)result);
        ttc580.simulateSocketNotAtStandby((short)2);
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testGetCurrentToUnlock() {
        System.out.println("getCurrentToUnlock");
        int expResult = 1500;
        short result = clampXminus1.getCurrentToUnlock();
        Assert.assertEquals((String)"currentToUnlock=1500", (long)expResult, (long)result);
    }

    @Test
    public void testGetLockSensorValueA() {
        System.out.println("getLockSensorValueA");
        int expResult = LOCKA;
        int result = clampXminus1.getLockSensorValueA();
        Assert.assertEquals((String)"lockSensorValueA", (long)expResult, (long)result);
    }

    @Test
    public void testGetLockSensorValueB() {
        System.out.println("getLockSensorValueB");
        int expResult = LOCKB;
        int result = clampXminus1.getLockSensorValueB();
        Assert.assertEquals((String)"lockSensorValueB", (long)expResult, (long)result);
    }

    @Test
    public void testGetLockSensorValueC() {
        System.out.println("getLockSensorValueC");
        int expResult = LOCKC;
        int result = clampXminus1.getLockSensorValueC();
        Assert.assertEquals((String)"lockSensorValueB", (long)expResult, (long)result);
    }

    @Test
    public void testGetFilterPresenceValueA() {
        System.out.println("getFilterPresenceValueA");
        int expResult = FILTERPRESENCEA;
        int result = clampXminus1.getFilterPresenceValueA();
        Assert.assertEquals((String)"filterPresenceValueA", (long)expResult, (long)result);
    }

    @Test
    public void testGetFilterPresenceValueB() {
        System.out.println("getFilterPresenceValueB");
        int expResult = FILTERPRESENCEB;
        int result = clampXminus1.getFilterPresenceValueB();
        Assert.assertEquals((String)"filterPresenceValueB", (long)expResult, (long)result);
    }

    @Test
    public void testGetFilterPresenceValueC() {
        System.out.println("getFilterPresenceValueC");
        int expResult = FILTERPRESENCEC;
        int result = clampXminus1.getFilterPresenceValueC();
        Assert.assertEquals((String)"filterPresenceValueC", (long)expResult, (long)result);
    }

    @Test
    public void testGetFilterPresenceSensor() {
        System.out.println("getFilterPresenceSensor");
        Assert.assertEquals((String)"filterPresenceSensor", (Object)filterPresenceXminusSensor1, (Object)clampXminus1.getFilterPresenceSensor());
    }

    @Test
    public void testGetLockSensor() {
        System.out.println("getLockSensor");
        Assert.assertEquals((String)"lockSensor", (Object)lockSensorXminus1, (Object)clampXminus1.getLockSensor());
    }

    @Test
    public void testMyDevicesReady() {
        System.out.println("myDevicesReady");
        Assert.assertTrue((String)"clamp simulated hardware is ready", (boolean)clampXminus1.myDevicesReady());
    }

    @Test
    public void testSimulateClampXminusIsLocked() {
        System.out.println("###simulateClampXIsLocked of class SimuTTC580");
        ttc580.simulateClampIsLocked(clampXminus1);
        int lockValue = ttc580.getLockXm(ttc580.getPdo1());
        int exprResult = (LOCKB + LOCKC) / 2;
        Assert.assertEquals((String)"lockValue", (long)exprResult, (long)lockValue);
    }

    @Test
    public void testSimulateClampXminusIsUnlocked() {
        System.out.println("###simulateClampXminusIsUnlocked of class SimuTTC580");
        ttc580.simulateClampIsUnlocked(clampXminus1);
        int lockValue = ttc580.getLockXm(ttc580.getPdo1());
        int exprResult = LOCKA - 10;
        Assert.assertEquals((String)"lockValue", (long)exprResult, (long)lockValue);
    }

    @Test
    public void testSimulateClampXplusIsLocked() {
        System.out.println("###simulateClampXplusIsLocked of class SimuTTC580");
        ttc580.simulateClampIsLocked(clampXplus1);
        int lockValue = ttc580.getLockXp(ttc580.getPdo1());
        int exprResult = (LOCKB + LOCKC) / 2;
        Assert.assertEquals((String)"lockValue", (long)exprResult, (long)lockValue);
    }

    @Test
    public void testSimulateClampXminusFilterIsLockable() {
        System.out.println("###simulateClampXminusFilterIsLockable of class SimuTTC580");
        ttc580.simulateClampFilterIsLockable(clampXminus1);
        int expResult = (FILTERPRESENCEA + FILTERPRESENCEB) / 2;
        Assert.assertEquals((String)"filterPresenceX-", (long)expResult, (long)ttc580.getFilterPresenceXm(ttc580.getPdo1()));
    }

    @Test
    public void testSimulateClampXplusFilterIsLockable() {
        System.out.println("###simulateClampXplusFilterIsLockable of class SimuTTC580");
        ttc580.simulateClampFilterIsLockable(clampXplus1);
        int expResult = (FILTERPRESENCEA + FILTERPRESENCEB) / 2;
        Assert.assertEquals((String)"filterPresenceX+", (long)expResult, (long)ttc580.getFilterPresenceXp(ttc580.getPdo1()));
    }

    @Test
    public void testSimulateClampXplusIsUnlocked() {
        System.out.println("###simulateClampXplusIsUnlocked of class SimuTTC580");
        ttc580.simulateClampIsUnlocked(clampXplus1);
        int lockValue = ttc580.getLockXp(ttc580.getPdo1());
        int exprResult = LOCKA - 10;
        Assert.assertEquals((String)"lockValue", (long)exprResult, (long)lockValue);
    }

    @Test
    public void testSimulateClampXminusFilterIsNotLockable() {
        System.out.println("###simulateClampXminusFilterIsNotLockable of class SimuTTC580");
        ttc580.simulateClampFilterIsNotLockable(clampXminus1);
        int expResult = (FILTERPRESENCEB + FILTERPRESENCEC) / 2;
        Assert.assertEquals((String)"filterPresenceX-", (long)expResult, (long)ttc580.getFilterPresenceXm(ttc580.getPdo1()));
    }

    @Test
    public void testSimulateClampXplusFilterIsNotLockable() {
        System.out.println("###simulateClampXplusFilterIsNotLockable of class SimuTTC580");
        ttc580.simulateClampFilterIsNotLockable(clampXplus1);
        int expResult = (FILTERPRESENCEB + FILTERPRESENCEC) / 2;
        Assert.assertEquals((String)"filterPresenceX+", (long)expResult, (long)ttc580.getFilterPresenceXp(ttc580.getPdo1()));
    }

    @Test
    public void testSimulateClampXminusNoFilter() {
        System.out.println("###simulateClampXminusNoFilter of class SimuTTC580");
        ttc580.simulateClampNoFilter(clampXminus1);
        int expResult = FILTERPRESENCEC + 1;
        Assert.assertEquals((String)"filterPresenceX-", (long)expResult, (long)ttc580.getFilterPresenceXm(ttc580.getPdo1()));
    }

    @Test
    public void testSimulateClampXplusNoFilter() {
        System.out.println("###simulateClampXplusNoFilter of class SimuTTC580");
        ttc580.simulateClampNoFilter(clampXplus1);
        int expResult = FILTERPRESENCEC + 1;
        Assert.assertEquals((String)"filterPresenceX+", (long)expResult, (long)ttc580.getFilterPresenceXp(ttc580.getPdo1()));
    }

    @Test
    public void testSimulateClampXminusFilterIsInError() {
        System.out.println("###simulateClampXminusFilterIsInError of class SimuTTC580");
        ttc580.simulateClampFilterIsInError(clampXminus1);
        int expResult = FILTERPRESENCEA - 1;
        Assert.assertEquals((String)"filterPresenceX-", (long)expResult, (long)ttc580.getFilterPresenceXm(ttc580.getPdo1()));
    }

    @Test
    public void testSimulateClampXplusFilterIsInError() {
        System.out.println("###simulateClampXplusFilterIsInError");
        ttc580.simulateClampFilterIsInError(clampXplus1);
        int expResult = FILTERPRESENCEA - 1;
        Assert.assertEquals((String)"filterPresenceX+", (long)expResult, (long)ttc580.getFilterPresenceXp(ttc580.getPdo1()));
    }

    @Test
    public void testUpdateSensorsFromPDO() throws Exception {
        long pdo1Value = 268432740L;
        ttc580.setPdo1(pdo1Value);
        System.out.println("updateSensorsFromPDO");
        try {
            ttc580.updateSensorsFromPDO();
        }
        catch (IllegalArgumentException ex) {
            System.out.println("bad initialisation of socketID." + ex);
        }
    }

    @Test
    public void testIsLocked() throws DriverException {
        System.out.println("isLocked");
        ttc580.simulateClampIsLocked(clampXminus1);
        ttc580.updateSensorsFromPDO();
        clampXminus1.updateLockStatus();
        int expResult = ttc580.getLockXm(ttc580.getPdo1());
        Assert.assertEquals((String)"lockValue", (long)expResult, (long)clampXminus1.getLockSensor().getValue());
        System.out.println("lockSensorValue=" + lockSensorXminus1.getValue());
        Assert.assertTrue((String)"lockSensor.getValue() < clamp.getLockSensorValueC()", (lockSensorXminus1.getValue() < clampXminus1.getLockSensorValueC() ? 1 : 0) != 0);
        Assert.assertTrue((String)"lockSensor.getValue() > clamp.getLockSensorValueB()", (lockSensorXminus1.getValue() > clampXminus1.getLockSensorValueB() ? 1 : 0) != 0);
        clampXminus1.updateLockStatus();
        Assert.assertEquals((Object)FcsEnumerations.LockStatus.LOCKED, (Object)clampXminus1.getLockStatus());
        Assert.assertTrue((String)"clamp is LOCKED", (boolean)clampXminus1.isLocked());
        ttc580.simulateClampIsUnlocked(clampXminus1);
        ttc580.updateSensorsFromPDO();
        clampXminus1.updateLockStatus();
        Assert.assertEquals((Object)FcsEnumerations.LockStatus.UNLOCKED, (Object)clampXminus1.getLockStatus());
        Assert.assertFalse((String)"clamp is UNLOCKED", (boolean)clampXminus1.isLocked());
    }

    @Test
    public void testIsFilterEngaged() throws DriverException {
        System.out.println("isFilterEngaged");
        ttc580.simulateClampFilterIsLockable(clampXminus1);
        ttc580.updateSensorsFromPDO();
        clampXminus1.updateFilterPresenceStatus();
        Assert.assertEquals((Object)FcsEnumerations.FilterPresenceStatus.LOCKABLE, (Object)clampXminus1.getFilterPresenceStatus());
        Assert.assertTrue((String)"filter is engaged", (boolean)clampXminus1.isFilterEngaged());
        ttc580.simulateClampNoFilter(clampXminus1);
        ttc580.updateSensorsFromPDO();
        clampXminus1.updateFilterPresenceStatus();
        Assert.assertEquals((Object)FcsEnumerations.FilterPresenceStatus.NOFILTER, (Object)clampXminus1.getFilterPresenceStatus());
        Assert.assertFalse((String)"filter is NOT engaged", (boolean)clampXminus1.isFilterEngaged());
        ttc580.simulateClampFilterIsNotLockable(clampXminus1);
        ttc580.updateSensorsFromPDO();
        clampXminus1.updateFilterPresenceStatus();
        Assert.assertEquals((Object)FcsEnumerations.FilterPresenceStatus.NOT_LOCKABLE, (Object)clampXminus1.getFilterPresenceStatus());
        Assert.assertFalse((String)"filter is NOT engaged", (boolean)clampXminus1.isFilterEngaged());
    }

    @Test
    public void testUpdateState() throws DriverException {
        System.out.println("updateState");
        ttc580.simulateClampNoFilter(clampXminus1);
        ttc580.updateSensorsFromPDO();
        Assert.assertTrue((String)"filterPresenceSensor.getValue() > clamp.getFilterPresenceValueC()", (filterPresenceXminusSensor1.getValue() > clampXminus1.getFilterPresenceValueC() ? 1 : 0) != 0);
        System.out.println("filterPresenceSensor.getValue()=" + filterPresenceXminusSensor1.getValue());
        clampXminus1.updateFilterPresenceStatus();
        System.out.println("filterPresenceSensor.getValue()=" + filterPresenceXminusSensor1.getValue());
        clampXminus1.updateFilterPresenceStatus();
        System.out.println("filterPresenceSensor.getValue()=" + filterPresenceXminusSensor1.getValue());
        System.out.println("=> canInterface pdoData=" + canInterface.sync().toString());
        System.out.println("=> tcpProxy pdoData=" + tcpProxy.sync().toString());
        System.out.println("tcpProxy.updatePDOData()");
        tcpProxy.updatePDOData();
        System.out.println("=> canInterface pdoData=" + canInterface.sync().toString());
        System.out.println("=> tcpProxy pdoData=" + tcpProxy.sync().toString());
        clampXminus1.updateFilterPresenceStatus();
        System.out.println("filterPresenceSensor.getValue() after tcpProxy.updatePDOData()=" + filterPresenceXminusSensor1.getValue());
        clampXminus1.updateState();
        Assert.assertFalse((String)"clamp is no more updating", (boolean)CarouselClampTest.clampXminus1.updatingState);
    }

    public void testRelease() {
        System.out.println("release");
        try {
            clampXminus1.release();
        }
        catch (RejectedCommandException ex) {
            System.out.println("Clamp is not CLAMPEDONFILTER so command release should be rejected");
            System.out.println((Object)ex);
        }
        ttc580.simulateClampNoFilter(clampXminus1);
        ttc580.simulateClampIsUnlocked(clampXminus1);
        clampXminus1.updateState();
        clampXminus1.release();
        Assert.assertEquals((String)"clamp is now READYTOCLAMP", (Object)FcsEnumerations.FilterClampState.READYTOCLAMP, (Object)clampXminus1.getClampState());
    }

    public void testUnlock() {
        System.out.println("unlock");
        clampXminus1.unlock();
        Assert.assertFalse((String)"clamp is now UNLOCKED", (boolean)clampXminus1.isLocked());
    }

    static {
        socketID = 1;
        LOCKA = 1000;
        LOCKB = 2000;
        LOCKC = 3000;
        FILTERPRESENCEA = 500;
        FILTERPRESENCEB = 1500;
        FILTERPRESENCEC = 2500;
    }
}

