
package org.lsst.ccs.subsystems.fcs.testbench;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.common.Thermometer;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.HardwareNotDetectedException;
import org.lsst.ccs.subsystems.fcs.errors.LoaderDisconnectedException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;

/**
 * Thois soft is to test the FCS with 2 CAN BUS : - one for the carousel and the
 * autochanger - one for the loader
 *
 * @author virieux
 */
public class APCTestBench2CanBusMain extends MainModule {

    /**
     * this bridge is to communicate with the canbus1 on the PC104
     */
    protected BridgeToHardware bridgeToLoader;

    /**
     * * The thermometer mesures the temperature inside the clamp.
     */
    private Thermometer thermometer;
    private CanOpenLED led;
    private CanOpenLED fakeLed;
    private Thermometer fakeSensor;

    public double temperature;

    private boolean ledOn = false;

    /**
     * Build a main module for APC testbench with 2 CANbus.
     * @param bridge
     * @param bridgeToLoader 
     */
    public APCTestBench2CanBusMain(BridgeToHardware bridge, BridgeToHardware bridgeToLoader) {
        super(bridge);
        this.bridgeToLoader = bridgeToLoader;
    }
    
    @Command(type = Command.CommandType.QUERY, level = Command.NORMAL,
        description = "Return true if the changer is connected.")    
    public boolean isChangerConnected() {
        return this.bridge.isReady();
    }
    
    @Command(type = Command.CommandType.QUERY, level = Command.NORMAL,
        description = "Return true if the loader is connected.")
    public boolean isLoaderConnected() {
        return this.bridgeToLoader.isReady();
    }

    @Command(type = Command.CommandType.QUERY, level = Command.NORMAL,
        description = "Return true if the hardware of the changer is ready.")     
    public boolean isChangerReady() {
        return this.bridge.allDevicesBooted();
    }

    @Command(type = Command.CommandType.QUERY, level = Command.NORMAL,
        description = "Return true if the hardware of the loader is ready.")    
    public boolean isLoaderReady() {
        return this.bridgeToLoader.allDevicesBooted();
    }

    @Command(type = Command.CommandType.ACTION, level = Command.NORMAL,
        description = "Disconnect the (fake) loader.")    
    public void disconnectLoader() throws InterruptedException {
        this.bridgeToLoader.disconnectHardware();
    }
    
    @Command(type = Command.CommandType.ACTION, level = Command.NORMAL,
            description = "Connect the (fake) loader.")
    public void connectLoader() {
        this.bridgeToLoader.connectHardware();
    }
    

    /**
     * Read temperature.
     * @return
     * @throws FcsHardwareException
     * @throws LoaderDisconnectedException 
     */
    @Command(type = Command.CommandType.QUERY, level = Command.NORMAL,
        description = "Read temperature.")
    public double readTemperature() throws LoaderDisconnectedException {
        try {
            return this.thermometer.readTemperature();
        } catch (FcsHardwareException ex) {
            if (ex instanceof HardwareNotDetectedException) {
                throw new LoaderDisconnectedException(ex.getMessage());
            }
        }
        return 0;
    }


    /**
     * To turn the LED on.
     * @return
     * @throws SDORequestException
     * @throws HardwareNotDetectedException 
     */
    @Command(type = Command.CommandType.ACTION, level = Command.NORMAL,
            description = "Turn ON the Led.")    
    public String turnOnLED()  {
        led.turnON();
        ledOn = true;
        return "LED is turned ON";
    }

    /**
     * Turn OFF the Led.
     * @return
     * @throws FcsHardwareException 
     */
    @Command(type = Command.CommandType.ACTION, level = Command.NORMAL,
            description = "Turn OFF the Led.")    
    public String turnOffLED()  {
        led.turnOFF();
        ledOn = false;
        return "LED is turned OFF";
    }

    @Override
    public void updateStateWithSensors()  {
//        try {
//            this.temperature = readTemperature();
//        } catch (LoaderDisconnectedException ex) {
//            throw ex;
//        }
    }


}
