
package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import org.lsst.ccs.drivers.canopenjni.PDOData;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystems.fcs.Carousel;
import org.lsst.ccs.subsystems.fcs.CarouselSocket;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;

/**
 * This class is for the Single Filter Test carousel. 
 * The carousel in Single Filter Test has only one socket and doesn't rotate.
 *
 * @author virieux
 */
public class SftCarousel extends Carousel {
    
    @Override
    public CarouselSocket getSocketAtStandby() {
        return getSocketByName("socket1");
    }

    @Override
    public int getPosition() {
        return 0;
    }
    
    /**
     * Executed during Initialization phase by the framework.
     */
    @Override
    public void postStart() {
        if (this.ai814.isBooted()) {
            this.ai814.initializeAndCheckHardware();

        } else {
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, "ai814 not booted", ai814.getName());
        }
    }

    @Override
    public boolean isRotating() {
        return false;
    }
    
    /**
     * Read the clamps state from PDO : all the clamp sensors are read at one
     * time.
     *
     * @throws org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException
     */
    @Override
    public void updateClampsStateWithSensorsFromPDO() {

        PDOData pdoStore = this.tcpProxy.updatePDOData();
        
        try {
            ai814.updateFromPDO(pdoStore);
        } catch (DriverException ex) {
            FCSLOG.error(name, ex);
        }
        
        FCSLOG.finest(name + ":pdoStore=" + pdoStore.toString());
        socketsMap.values().stream().forEach((socket) -> {
            socket.updateClampsState();
        });
    }    

    /**
     * Carousel can't rotate in single-filter-test
     * @param angle
     * @return 
     */
    public String rotate(float angle) {
        throw new UnsupportedOperationException("Operation rotate not available in Single Filter Test");
    }
}
