
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.subsystems.fcs.CarouselClamp;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenTTC580;

/**
 *
 * @author virieux
 */
public class SimuTTC580 extends CanOpenTTC580 {
    
    public SimuTTC580(int nodeID, String serialNB) {
        super(nodeID, serialNB);
    }
    
    @Override
    public void initializeAndCheckHardware() {
        super.initializeAndCheckHardware();
        updateFakePDOData(cobid1,0);
        updateFakePDOData(cobid2,0);
    }    
    
    public void updateFakePDOData(int cobid, long newPdo) {
        if (cobid == cobid1) {
            this.pdo1 = newPdo;
        } else if (cobid == cobid2) {
            this.pdo2 = newPdo;
        }
        ((SimuCanOpenInterface) tcpProxy.getCanInterface()).simulatePDOData(cobid, newPdo);
    }
    
    /**
     * socket ID is coded on the first 3 bits.
     * @param id 
     */
    public void simulateSocketAtStandby(short id) {
        long sock = (long) id << 61;
        long mask = 0x1FFFFFFFFFFFFFFFL;
        long newpdo = sock | (pdo1 & mask);
        System.out.println("newpdo1=" + Long.toBinaryString(newpdo));
        updateFakePDOData(cobid1, newpdo);
    }
    
    public void simulateSocketNotAtStandby(short id) {
        long sock = (long) id << 61;
        long mask = 0x1FFFFFFFFFFFFFFFL;
        long newpdo = sock | (pdo2 & mask);
        System.out.println("newpdo2=" + Long.toBinaryString(newpdo));
        updateFakePDOData(cobid2, newpdo);
    }   
    
    
    public void simulateLockSensorXminusValue(long lockValue) {
        System.out.println("lockValue=" + Long.toBinaryString(lockValue));
        long pdo = (long) (lockValue << 36);
        long mask = 0xFFFF000FFFFFFFFFL;
        long newpdo = pdo | (pdo1 & mask);
        System.out.println("newpdo1=" + Long.toBinaryString(newpdo));
        updateFakePDOData(cobid1, newpdo);
    }
    
    public void simulateLockSensorXminusValueNotAtS(long lockValue) {
        System.out.println("lockValue=" + Long.toBinaryString(lockValue));
        long pdo = (long) (lockValue << 36);
        long mask = 0xFFFF000FFFFFFFFFL;
        long newpdo = pdo | (pdo2 & mask);
        System.out.println("newpdo2=" + Long.toBinaryString(newpdo));
        updateFakePDOData(cobid2, newpdo);
    }    
    
    public void simulateFilterPresenceXminusValue(long newValue) {
        System.out.println("lockValue=" + Long.toBinaryString(newValue));
        long pdo = (long) (newValue << 24);
        long mask = 0xFFFFFFF000FFFFFFL;
        long newpdo = pdo | (pdo1 & mask);
        System.out.println("newpdo1=" + Long.toBinaryString(newpdo));
        updateFakePDOData(cobid1, newpdo);
    }
    
    public void simulateFilterPresenceXminusValueNotAtS(long newValue) {
        System.out.println("lockValue=" + Long.toBinaryString(newValue));
        long pdo = (long) (newValue << 24);
        long mask = 0xFFFFFFF000FFFFFFL;
        long newpdo = pdo | (pdo2 & mask);
        System.out.println("newpdo2=" + Long.toBinaryString(newpdo));
        updateFakePDOData(cobid2, newpdo);
    }    
    
    public void simulateLockSensorXplusValue(long newValue) {
        System.out.println("lockValue=" + Long.toBinaryString(newValue));
        long pdo = (long) (newValue << 12);
        long mask = 0xFFFFFFFFFF000FFFL;
        long newpdo = pdo | (pdo1 & mask);
        System.out.println("newpdo1=" + Long.toBinaryString(newpdo));
        updateFakePDOData(cobid1, newpdo);
    } 
    
   public void simulateLockSensorXplusValueNotAtS(long newValue) {
        System.out.println("lockValue=" + Long.toBinaryString(newValue));
        long pdo = (long) (newValue << 12);
        long mask = 0xFFFFFFFFFF000FFFL;
        long newpdo = pdo | (pdo2 & mask);
        System.out.println("newpdo2=" + Long.toBinaryString(newpdo));
        updateFakePDOData(cobid2, newpdo);
    }    
    
    public void simulateFilterPresenceXplusValue(long newValue) {
        System.out.println("lockValue=" + Long.toBinaryString(newValue));
        long pdo = (long) (newValue & 0xFFF);
        long mask = 0xFFFFFFFFFFFFF000L;
        long newpdo = pdo | (pdo1 & mask);
        System.out.println("newpdo1=" + Long.toBinaryString(newpdo));
        updateFakePDOData(cobid1, newpdo);
    } 
    
    public void simulateFilterPresenceXplusValueNotAtS(long newValue) {
        System.out.println("lockValue=" + Long.toBinaryString(newValue));
        long pdo = (long) (newValue & 0xFFF);
        long mask = 0xFFFFFFFFFFFFF000L;
        long newpdo = pdo | (pdo2 & mask);
        System.out.println("newpdo2=" + Long.toBinaryString(newpdo));
        updateFakePDOData(cobid2, newpdo);
    }     
    
    public void simulateClampIsLocked(CarouselClamp clamp) {
        int lockVal = (clamp.getLockSensorValueB() + clamp.getLockSensorValueC()) / 2;
        simulateClampLockValue(clamp, lockVal);
    }
    
    public void simulateClampIsLockedNotAtS(CarouselClamp clamp) {
        int lockVal = (clamp.getLockSensorValueB() + clamp.getLockSensorValueC()) / 2;
        simulateClampLockValueNotAtS(clamp, lockVal);
    }    
    
    public void simulateClampIsUnlocked(CarouselClamp clamp) {
        int lockVal = clamp.getLockSensorValueA() - 10;
        simulateClampLockValue(clamp, lockVal);
    }
    
    private void simulateClampLockValue(CarouselClamp clamp, int lockVal) {
        if (clamp.getName().contains("Xminus")) {
            simulateLockSensorXminusValue(lockVal);
        } else if (clamp.getName().contains("Xplus")) {
            simulateLockSensorXplusValue(lockVal);
        } else throw new IllegalArgumentException(clamp.getName() + " illegal value. "
                + "Should contain Xminus or Xplus");
    }    
    
    private void simulateClampLockValueNotAtS(CarouselClamp clamp, int lockVal) {
        if (clamp.getName().contains("Xminus")) {
            simulateLockSensorXminusValueNotAtS(lockVal);
        } else if (clamp.getName().contains("Xplus")) {
            simulateLockSensorXplusValueNotAtS(lockVal);
        } else throw new IllegalArgumentException(clamp.getName() + " illegal value. "
                + "Should contain Xminus or Xplus");
    }     
    
    /**
     * filter is engaged and lockable if filterPresence sensor returns a value between 
     * FilterPresenceValueA and FilterPresenceValueB
     * @param clamp 
     */
    public void simulateClampFilterIsLockable(CarouselClamp clamp) {
        int val = (clamp.getFilterPresenceValueA() + clamp.getFilterPresenceValueB())/2;
        simulateClampFilterPresenceValue(clamp, val);
    }
    
    /**
     * filter is engaged and lockable if filterPresence sensor returns a value between 
     * FilterPresenceValueA and FilterPresenceValueB
     * @param clamp 
     */
    public void simulateClampFilterIsLockableNotAtS(CarouselClamp clamp) {
        int val = (clamp.getFilterPresenceValueA() + clamp.getFilterPresenceValueB())/2;
        simulateClampFilterPresenceValueNotAtS(clamp, val);
    }    
    
    /**
     * filter is not loackable if filterPresence sensor returns a value between
     * FilterPresenceValueB and FilterPresenceValueC
     * @param clamp 
     */
    public void simulateClampFilterIsNotLockable(CarouselClamp clamp) {
        int val = (clamp.getFilterPresenceValueB() + clamp.getFilterPresenceValueC())/2;
        simulateClampFilterPresenceValue(clamp, val);
    }
    
    /**
     * simulate there is no filter in socket socketID clampX-
     * @param clamp
     */
    public void simulateClampNoFilter(CarouselClamp clamp) {
        int val = clamp.getFilterPresenceValueC() + 1;
        simulateClampFilterPresenceValue(clamp, val);
    }
    
    
    public void simulateClampFilterIsInError(CarouselClamp clamp) {
        int val = clamp.getFilterPresenceValueA() - 1;
        simulateClampFilterPresenceValue(clamp, val);        
    }    
    
    private void simulateClampFilterPresenceValue(CarouselClamp clamp, int val) {
        if (clamp.getName().contains("Xminus")) {
            simulateFilterPresenceXminusValue(val);
        } else if (clamp.getName().contains("Xplus")) {
            simulateFilterPresenceXplusValue(val);
        } else throw new IllegalArgumentException(clamp.getName() + " illegal value. "
                + "Should contain Xminus or Xplus");        
    }
    
    private void simulateClampFilterPresenceValueNotAtS(CarouselClamp clamp, int val) {
        if (clamp.getName().contains("Xminus")) {
            simulateFilterPresenceXminusValueNotAtS(val);
        } else if (clamp.getName().contains("Xplus")) {
            simulateFilterPresenceXplusValueNotAtS(val);
        } else throw new IllegalArgumentException(clamp.getName() + " illegal value. "
                + "Should contain Xminus or Xplus");        
    }    
    

    
    
    
    
    
    

    

    
    
    

}
