
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.Subsystem;
import org.lsst.ccs.AlertService;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.common.AlertRaiser;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.utilities.logging.Logger;

/**
 *
 * A Class for the device which records temperatures in autochanger.
 * This device is a canopenSystec IO X5 with 8 chanels, one chanel for each thermometer.
 * This class uses the monitoring framework so it extends Device.
 * It delegates to its field canopenSystec the commands relative to a CanOpenDevice.
 * 
 * 
 * 
 * 
 * @author virieux
 */
public class SystecIO_X5 extends Device implements AlertRaiser {
    
    protected static final Logger FCSLOG = FCSCst.FCSLOG;
    
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    
    
    double[] temperatures;
   
    CanOpenSystecIO tempSensorsDevice;
    

    public SystecIO_X5(CanOpenSystecIO tempSensorsDevice) {
        this.tempSensorsDevice = tempSensorsDevice;
    }

    @Override
    public AlertService getAlertService() {
        return alertService;
    }
    
    @Override
    public String getName() {
        return name;
    }
    
    @Override
    public Subsystem getSubsystem() {
        return s;
    }
    
    @Override
    public void postStart() {
        FCSLOG.fine(name + " BEGIN postStart.");
        if (tempSensorsDevice.isBooted()) {
            initializePostStart();
        }        
        FCSLOG.fine(name + " END postStart.");
    }
    
    public void initializePostStart() {
        try {
            tempSensorsDevice.initialize();
            setOnline(true);

        } catch (FcsHardwareException ex) {
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, " could not initialize tempSensorsDevice", 
                    tempSensorsDevice.getName(), ex);
        }
    }
    
    @Override
    public void initialize() {
        //TODO get rid of that when Device will not call initialize in checkHardwareMethod.
    }
    
    public double[] readTemperatures() {
        return temperatures;
    }

    @Override
    protected void close() {
        /* nothing to do here because closing is done in the CANbus layer.*/
    }
     
    
    @Override
    public double readChannel(int chanelNO, int type) {
        double temp = 0;
        try {
            temp = (double) tempSensorsDevice.readChannel(chanelNO);

        } catch (Exception ex) {
            FCSLOG.warning(getName() + " : couldn't read temperatures", ex);
        }
        return temp;
    }

}
