/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Agent;
import org.lsst.ccs.AlarmNotClearedException;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.SignalsStillRunning;
import org.lsst.ccs.SystemStateException;
import org.lsst.ccs.bus.data.AgentAlerts;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AgentState;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.CommandState;
import org.lsst.ccs.bus.states.OperationalState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.framework.HardwareController;
import org.lsst.ccs.framework.Signal;
import org.lsst.ccs.framework.SignalHandler;
import org.lsst.ccs.framework.SignalLevel;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.framework.TreeWalkerUtils;
import org.lsst.ccs.messaging.ClusterDeserializationErrorHandler;
import org.lsst.ccs.utilities.logging.StackTraceFormats;
import org.lsst.ccs.utilities.logging.TextFormatter;

public class Subsystem
extends Agent {
    private boolean startupOk = false;

    Subsystem(String name) {
        this(name, AgentInfo.AgentType.WORKER, null);
    }

    public Subsystem(String name, AgentInfo.AgentType type) {
        this(name, type, null);
    }

    public Subsystem(String name, AgentInfo.AgentType type, ComponentLookup lookup) {
        super(name, type, lookup);
    }

    @Override
    public void startAgent() {
        if (!this.treeComponentInitialized) {
            this.populateComponentLookup(this.getComponentLookup());
        }
        try {
            this.checkHardware();
            this.startupOk = true;
        }
        catch (HardwareException e) {
            this.getLogger().error((Object)"check hardware problem ", (Throwable)((Object)e));
            this.startupOk = false;
        }
        super.startAgent();
    }

    @Override
    protected final boolean internalStart() {
        this.doStart();
        AlertState alertState = this.getAgentInfo().getType().equals((Object)AgentInfo.AgentType.CONSOLE) ? AlertState.WARNING : AlertState.NOMINAL;
        this.getMessagingAccess().setClusterDeserializationErrorHandler(s -> {
            HashMap<String, String> alertData = new HashMap<String, String>();
            alertData.put("sender", s);
            alertData.put("receiver", this.getName());
            this.getAlertService().raiseAlert(AgentAlerts.ClusterAlert.getAlert(alertData), alertState, this.getName() + "and " + s + " are running incompatible core versions");
        });
        if (!this.startupOk) {
            this.updateInternalState(new AgentState[]{OperationalState.ENGINEERING_FAULT});
        } else {
            try {
                this.completeInitialization(true);
            }
            catch (HardwareException e) {
                this.getLogger().error((Object)"check hardware problem ", (Throwable)((Object)e));
            }
        }
        return this.startupOk;
    }

    @Override
    protected final void internalShutdown() throws Exception {
        try {
            this.checkAllHardwareStopped();
        }
        catch (HardwareException exc) {
            this.getAlertService().raiseAlert(new Alert("Problems stopping hardware", exc.getMessage()), AlertState.ALARM, "Internl Shutdown exception: " + exc.getMessage());
            this.getLogger().error((Object)"Problems stopping hardware", (Throwable)((Object)exc));
            throw exc;
        }
        this.getLogger().fine((Object)"Hardware is stopped");
        this.getLogger().fine((Object)("Subsystem " + this.getName() + " shutdown starting"));
        Iterator iter = OBJECT_SUBSYSTEM_MAP.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (entry.getValue() != this) continue;
            iter.remove();
        }
        this.doShutdown();
        this.getMessagingAccess().setClusterDeserializationErrorHandler(ClusterDeserializationErrorHandler.DEFAULT);
    }

    public void completeInitialization(boolean checkHardwareOK) throws HardwareException {
        if (!checkHardwareOK) {
            this.checkAllHardwareStarted();
            this.postStart();
        }
        this.updateInternalState(new AgentState[]{PhaseState.OPERATIONAL, OperationalState.ENGINEERING_OK});
    }

    @Deprecated
    public void checkHardware() throws HardwareException {
        HardwareException[] exc = new HardwareException[]{null};
        TreeWalkerUtils.treeWalk(this.getComponentLookup(), null, HardwareController.class, hc -> {
            try {
                return hc.checkHardware();
            }
            catch (HardwareException e) {
                exc[0] = new HardwareException(hc.toString() + "not started ", (Throwable)((Object)e), exc[0]);
                if (e.isFatal()) {
                    return TreeWalkerDiag.STOP;
                }
                return TreeWalkerDiag.GO;
            }
        }, null);
        if (exc[0] != null) {
            throw exc[0];
        }
    }

    @Deprecated
    public void checkAllHardwareStarted() throws HardwareException {
        HardwareException[] exc = new HardwareException[]{null};
        TreeWalkerUtils.proceduralWalk(this.getComponentLookup(), null, HardwareController.class, hc -> {
            try {
                hc.checkStarted();
            }
            catch (HardwareException e) {
                exc[0] = new HardwareException(hc.toString() + "not started ", (Throwable)((Object)e), exc[0]);
            }
        }, null);
        if (exc[0] != null) {
            throw exc[0];
        }
    }

    @Deprecated
    public void checkAllHardwareStopped() throws HardwareException {
        HardwareException[] exc = new HardwareException[]{null};
        TreeWalkerUtils.proceduralWalk(this.getComponentLookup(), null, HardwareController.class, hc -> {
            try {
                hc.checkStopped();
            }
            catch (HardwareException e) {
                exc[0] = new HardwareException(hc.toString() + "not started ", (Throwable)((Object)e), exc[0]);
            }
        }, null);
        if (exc[0] != null) {
            throw exc[0];
        }
    }

    public void doStart() {
    }

    protected void doShutdown() {
    }

    @Command(description="completes initialization after hardware problems corrections", type=Command.CommandType.ACTION)
    public void completeInitialization() throws SystemStateException, HardwareException {
        if (!this.isInState((Enum)PhaseState.INITIALIZING)) {
            throw new SystemStateException("initialization already completed");
        }
        this.completeInitialization(false);
    }

    @Command(description="forces blocked shutdown (not implemented yet!)", type=Command.CommandType.SIGNAL)
    public void forceShutdown() {
    }

    @Command(description="abort subsystem", type=Command.CommandType.SIGNAL)
    public void abort() {
        this.getLogger().fine((Object)("Subsystem " + this.getName() + " abort requested"));
        this.sendSignal(new Signal(SignalLevel.HALT));
    }

    @Command(description="stops hardware with expected max delay", type=Command.CommandType.ACTION)
    public void stop(@Argument(name="timeHint", defaultValue="-1") long timeHint) throws HardwareException {
        this.getLogger().fine((Object)("Subsystem " + this.getName() + " stop requested with " + timeHint));
        this.sendSignal(new Signal(SignalLevel.STOP, timeHint));
    }

    @Command(description="waits until all the hardware devices are actually stopped", type=Command.CommandType.ACTION)
    public void stopAndWait(long timeHint) throws HardwareException, InterruptedException {
        this.stop(timeHint);
        int step = 10;
        long fracDelay = timeHint / (long)step;
        HardwareException lastExc = null;
        for (int i = 0; i < step; ++i) {
            try {
                Thread.sleep(fracDelay);
                this.checkAllHardwareStopped();
                return;
            }
            catch (HardwareException e) {
                lastExc = e;
                continue;
            }
        }
        throw lastExc;
    }

    private void sendSignal(Signal signal) {
        TreeWalkerUtils.treeWalk(this.getComponentLookup(), null, SignalHandler.class, sh -> sh.signal(signal), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(description="switch to ENGINEERING mode", type=Command.CommandType.ACTION)
    public boolean switchToEngineeringMode() {
        Object object = this.innerStateLock;
        synchronized (object) {
            if (this.isInState((Enum)OperationalState.NORMAL)) {
                this.updateInternalState(new AgentState[]{OperationalState.ENGINEERING_OK});
                return true;
            }
        }
        return false;
    }

    @Command(description="Tries to get back to NORMAL mode", type=Command.CommandType.ACTION)
    public final void switchToNormalMode() throws SystemStateException {
        if (this.getState(AlertState.class).compareTo(AlertState.WARNING) > 0) {
            throw new AlarmNotClearedException();
        }
        if (this.getCommandCount(Command.CommandType.SIGNAL) != 0) {
            throw new SignalsStillRunning();
        }
        try {
            this.updateInternalState(new AgentState[]{CommandState.READY, OperationalState.NORMAL});
        }
        catch (IllegalArgumentException x) {
            throw new SystemStateException(x);
        }
    }

    @Command(description="set the level of a Logger", type=Command.CommandType.QUERY)
    public void setLogLevel(String keyLogger, String levelName) {
        Logger logger = Logger.getLogger(keyLogger);
        Level level = Level.parse(levelName);
        logger.setLevel(level);
    }

    @Command(description="sets the the depth of stacktraces in Logger messages", type=Command.CommandType.QUERY)
    public void setStackTraceDepth(int depth) {
        StackTraceFormats.setDepth((int)depth);
    }

    @Command(description="sets the format used by TextFormatter for LogEvent messages ", type=Command.CommandType.QUERY)
    public void setLogFormat(String format) {
        Formatter formatter = this.logBusHandler.getFormatter();
        if (!(formatter instanceof TextFormatter)) {
            throw new IllegalArgumentException(" formatter to LogBusHandler not a TextFormatter");
        }
        TextFormatter textFormatter = (TextFormatter)formatter;
        textFormatter.setFormat(format);
    }

    @Command(description="sets the handler (ConsoleHandler, FileHandler, LogBusHandler) log level", type=Command.CommandType.QUERY)
    public void setLogHandlerLevel(String handlerName, String level) {
        Level newLevel = Level.parse(level);
        Handler h = this.getLogHandler(handlerName);
        if (h == null) {
            throw new RuntimeException("Could not get LogHandler for name " + handlerName);
        }
        h.setLevel(newLevel);
    }

    public Handler getLogHandler(String handlerName) {
        Handler[] handlers;
        String lowerHandlerName = handlerName.toLowerCase();
        if (!lowerHandlerName.endsWith("handler")) {
            lowerHandlerName = lowerHandlerName + "handler";
        }
        if (lowerHandlerName.equals("logbushandler")) {
            return this.logBusHandler;
        }
        Logger rootLogger = Logger.getLogger("");
        for (Handler h : handlers = rootLogger.getHandlers()) {
            if (!h.getClass().getSimpleName().toLowerCase().equals(lowerHandlerName)) continue;
            return h;
        }
        return null;
    }

    @Command(description="gets the number of commands which are currently running (except the current one!)", type=Command.CommandType.QUERY)
    public int getNumberCommandThreads() {
        return this.getCommandCount(new Command.CommandType[0]);
    }

    @Command(description="gets the name of commands which are currently running", type=Command.CommandType.QUERY)
    public String printRunningCommands() {
        Agent.RunningCommand action;
        StringBuilder sb = new StringBuilder();
        HashSet commands = new HashSet(this.currentQueries);
        if (commands.size() > 1) {
            sb.append("Queries:\n");
            commands.forEach(task -> {
                if (!task.request.getBasicCommand().getCommand().equals("printRunningCommands")) {
                    sb.append(task).append("\n");
                }
            });
        }
        if ((action = this.currentAction) != null) {
            sb.append("Actions:\n").append(action).append("\n");
        }
        if (!(commands = new HashSet(this.currentQueries)).isEmpty()) {
            sb.append("Signals:\n");
            commands.forEach(task -> sb.append(task).append("\n"));
        }
        return sb.toString();
    }

    @Command(description="broadcast on the status bus a message of presence", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
    public void ping() {
        this.broadcastStatus();
    }

    public static final Subsystem getSubsystemForObject(Object obj) {
        return (Subsystem)OBJECT_SUBSYSTEM_MAP.get(obj);
    }
}

