/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.subsystems.fcs.CarouselClamp;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenTTC580;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCanOpenInterface;

public class SimuTTC580
extends CanOpenTTC580 {
    public SimuTTC580(int nodeID, String serialNB) {
        super(nodeID, serialNB);
    }

    @Override
    public void initializeAndCheckHardware() {
        super.initializeAndCheckHardware();
        this.updateFakePDOData(this.cobid1, 0L);
        this.updateFakePDOData(this.cobid2, 0L);
    }

    public void updateFakePDOData(int cobid, long newPdo) {
        if (cobid == this.cobid1) {
            this.pdo1 = newPdo;
        } else if (cobid == this.cobid2) {
            this.pdo2 = newPdo;
        }
        ((SimuCanOpenInterface)this.tcpProxy.getCanInterface()).simulatePDOData(cobid, newPdo);
    }

    public void simulateSocketAtStandby(short id) {
        long sock = (long)id << 61;
        long mask = 0x1FFFFFFFFFFFFFFFL;
        long newpdo = sock | this.pdo1 & mask;
        System.out.println("newpdo1=" + Long.toBinaryString(newpdo));
        this.updateFakePDOData(this.cobid1, newpdo);
    }

    public void simulateSocketNotAtStandby(short id) {
        long sock = (long)id << 61;
        long mask = 0x1FFFFFFFFFFFFFFFL;
        long newpdo = sock | this.pdo2 & mask;
        System.out.println("newpdo2=" + Long.toBinaryString(newpdo));
        this.updateFakePDOData(this.cobid2, newpdo);
    }

    public void simulateLockSensorXminusValue(long lockValue) {
        System.out.println("lockValue=" + Long.toBinaryString(lockValue));
        long pdo = lockValue << 36;
        long mask = -281406257233921L;
        long newpdo = pdo | this.pdo1 & mask;
        System.out.println("newpdo1=" + Long.toBinaryString(newpdo));
        this.updateFakePDOData(this.cobid1, newpdo);
    }

    public void simulateLockSensorXminusValueNotAtS(long lockValue) {
        System.out.println("lockValue=" + Long.toBinaryString(lockValue));
        long pdo = lockValue << 36;
        long mask = -281406257233921L;
        long newpdo = pdo | this.pdo2 & mask;
        System.out.println("newpdo2=" + Long.toBinaryString(newpdo));
        this.updateFakePDOData(this.cobid2, newpdo);
    }

    public void simulateFilterPresenceXminusValue(long newValue) {
        System.out.println("lockValue=" + Long.toBinaryString(newValue));
        long pdo = newValue << 24;
        long mask = -68702699521L;
        long newpdo = pdo | this.pdo1 & mask;
        System.out.println("newpdo1=" + Long.toBinaryString(newpdo));
        this.updateFakePDOData(this.cobid1, newpdo);
    }

    public void simulateFilterPresenceXminusValueNotAtS(long newValue) {
        System.out.println("lockValue=" + Long.toBinaryString(newValue));
        long pdo = newValue << 24;
        long mask = -68702699521L;
        long newpdo = pdo | this.pdo2 & mask;
        System.out.println("newpdo2=" + Long.toBinaryString(newpdo));
        this.updateFakePDOData(this.cobid2, newpdo);
    }

    public void simulateLockSensorXplusValue(long newValue) {
        System.out.println("lockValue=" + Long.toBinaryString(newValue));
        long pdo = newValue << 12;
        long mask = -16773121L;
        long newpdo = pdo | this.pdo1 & mask;
        System.out.println("newpdo1=" + Long.toBinaryString(newpdo));
        this.updateFakePDOData(this.cobid1, newpdo);
    }

    public void simulateLockSensorXplusValueNotAtS(long newValue) {
        System.out.println("lockValue=" + Long.toBinaryString(newValue));
        long pdo = newValue << 12;
        long mask = -16773121L;
        long newpdo = pdo | this.pdo2 & mask;
        System.out.println("newpdo2=" + Long.toBinaryString(newpdo));
        this.updateFakePDOData(this.cobid2, newpdo);
    }

    public void simulateFilterPresenceXplusValue(long newValue) {
        System.out.println("lockValue=" + Long.toBinaryString(newValue));
        long pdo = newValue & 0xFFFL;
        long mask = -4096L;
        long newpdo = pdo | this.pdo1 & mask;
        System.out.println("newpdo1=" + Long.toBinaryString(newpdo));
        this.updateFakePDOData(this.cobid1, newpdo);
    }

    public void simulateFilterPresenceXplusValueNotAtS(long newValue) {
        System.out.println("lockValue=" + Long.toBinaryString(newValue));
        long pdo = newValue & 0xFFFL;
        long mask = -4096L;
        long newpdo = pdo | this.pdo2 & mask;
        System.out.println("newpdo2=" + Long.toBinaryString(newpdo));
        this.updateFakePDOData(this.cobid2, newpdo);
    }

    public void simulateClampIsLocked(CarouselClamp clamp) {
        int lockVal = (clamp.getLockSensorValueB() + clamp.getLockSensorValueC()) / 2;
        this.simulateClampLockValue(clamp, lockVal);
    }

    public void simulateClampIsLockedNotAtS(CarouselClamp clamp) {
        int lockVal = (clamp.getLockSensorValueB() + clamp.getLockSensorValueC()) / 2;
        this.simulateClampLockValueNotAtS(clamp, lockVal);
    }

    public void simulateClampIsUnlocked(CarouselClamp clamp) {
        int lockVal = clamp.getLockSensorValueA() - 10;
        this.simulateClampLockValue(clamp, lockVal);
    }

    private void simulateClampLockValue(CarouselClamp clamp, int lockVal) {
        if (clamp.getName().contains("Xminus")) {
            this.simulateLockSensorXminusValue(lockVal);
        } else if (clamp.getName().contains("Xplus")) {
            this.simulateLockSensorXplusValue(lockVal);
        } else {
            throw new IllegalArgumentException(clamp.getName() + " illegal value. Should contain Xminus or Xplus");
        }
    }

    private void simulateClampLockValueNotAtS(CarouselClamp clamp, int lockVal) {
        if (clamp.getName().contains("Xminus")) {
            this.simulateLockSensorXminusValueNotAtS(lockVal);
        } else if (clamp.getName().contains("Xplus")) {
            this.simulateLockSensorXplusValueNotAtS(lockVal);
        } else {
            throw new IllegalArgumentException(clamp.getName() + " illegal value. Should contain Xminus or Xplus");
        }
    }

    public void simulateClampFilterIsLockable(CarouselClamp clamp) {
        int val = (clamp.getFilterPresenceValueA() + clamp.getFilterPresenceValueB()) / 2;
        this.simulateClampFilterPresenceValue(clamp, val);
    }

    public void simulateClampFilterIsLockableNotAtS(CarouselClamp clamp) {
        int val = (clamp.getFilterPresenceValueA() + clamp.getFilterPresenceValueB()) / 2;
        this.simulateClampFilterPresenceValueNotAtS(clamp, val);
    }

    public void simulateClampFilterIsNotLockable(CarouselClamp clamp) {
        int val = (clamp.getFilterPresenceValueB() + clamp.getFilterPresenceValueC()) / 2;
        this.simulateClampFilterPresenceValue(clamp, val);
    }

    public void simulateClampNoFilter(CarouselClamp clamp) {
        int val = clamp.getFilterPresenceValueC() + 1;
        this.simulateClampFilterPresenceValue(clamp, val);
    }

    public void simulateClampFilterIsInError(CarouselClamp clamp) {
        int val = clamp.getFilterPresenceValueA() - 1;
        this.simulateClampFilterPresenceValue(clamp, val);
    }

    private void simulateClampFilterPresenceValue(CarouselClamp clamp, int val) {
        if (clamp.getName().contains("Xminus")) {
            this.simulateFilterPresenceXminusValue(val);
        } else if (clamp.getName().contains("Xplus")) {
            this.simulateFilterPresenceXplusValue(val);
        } else {
            throw new IllegalArgumentException(clamp.getName() + " illegal value. Should contain Xminus or Xplus");
        }
    }

    private void simulateClampFilterPresenceValueNotAtS(CarouselClamp clamp, int val) {
        if (clamp.getName().contains("Xminus")) {
            this.simulateFilterPresenceXminusValueNotAtS(val);
        } else if (clamp.getName().contains("Xplus")) {
            this.simulateFilterPresenceXplusValueNotAtS(val);
        } else {
            throw new IllegalArgumentException(clamp.getName() + " illegal value. Should contain Xminus or Xplus");
        }
    }
}

