/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.drivers.CanCBXAI814;
import org.lsst.ccs.subsystems.fcs.simulation.AutochangerTruckPositionListener;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCanOpenADC;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCanOpenSensor14bits;

public class SimuCarouselClampFilterPresenceSensor
extends SimuCanOpenSensor14bits
implements AutochangerTruckPositionListener {
    int acTrucksStandbyPosition = 992000;

    public SimuCarouselClampFilterPresenceSensor(CanCBXAI814 adc, int numOfAnalogInput) {
        super(adc, numOfAnalogInput);
    }

    public void start() {
        this.simulateFilterIsLockable();
    }

    @Override
    public void onTruckPositionChange(int newPos) {
        FCSCst.FCSLOG.finest((Object)(this.name + " :old Value=" + this.printValue()));
        if (this.isAtStandby()) {
            FCSCst.FCSLOG.finest((Object)(this.name + " is AT STANDBY."));
        }
        if (this.s.isInState((Enum)PhaseState.OPERATIONAL) && this.isAtStandby() && this.autochanger.isHoldingFilter()) {
            if (newPos < this.acTrucksStandbyPosition - 500) {
                this.simulateNoFilter();
            } else if (newPos == this.acTrucksStandbyPosition) {
                this.simulateFilterIsLockable();
            }
        }
        FCSCst.FCSLOG.finest((Object)(this.name + " :new Value=" + this.printValue()));
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateFilterIsLockable() {
        ((SimuCanOpenADC)this.adc).simulateSensorValue(this, this.clamp.getFilterPresenceValueA(), this.clamp.getFilterPresenceValueB());
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateFilterIsNotLockable() {
        ((SimuCanOpenADC)this.adc).simulateSensorValue(this, this.clamp.getFilterPresenceValueB(), this.clamp.getFilterPresenceValueC());
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateNoFilter() {
        ((SimuCanOpenADC)this.adc).simulateSensorValue(this, this.clamp.getFilterPresenceValueC(), Short.MAX_VALUE);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateFilterIsInError() {
        ((SimuCanOpenADC)this.adc).simulateSensorValue(this, 0, this.clamp.getFilterPresenceValueA());
    }
}

