/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.canopenjni.PDOData;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.drivers.PlutoGateway;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenCallTimeoutException;
import org.lsst.ccs.subsystems.fcs.errors.FailedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;
import org.lsst.ccs.utilities.logging.Logger;

public class CanOpenPlutoGateway
extends PlutoGateway {
    public static final Logger LOCAL_LOG = Logger.getLogger((String)"org.lsst.ccs.subsystems.fcs.CanOpenPlutoGateway");

    public CanOpenPlutoGateway(int nodeID, String serialNB) {
        super(nodeID, serialNB);
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="Initialize the Gateway.")
    public void initializeAndCheckHardware() {
        this.checkBooted();
        try {
            FCSCst.FCSLOG.info((Object)(this.name + " BEGIN initializeHardware"));
            this.configurePlutoGateway();
            this.initialized = true;
            FCSCst.FCSLOG.info((Object)(this.name + " is INITIALIZED."));
            this.publishData();
        }
        catch (FailedCommandException | SDORequestException ex) {
            throw new FcsHardwareException(this.name, ex);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Configures this gateway for subsystem needs. If gateway's name contains loader it executes configureLoaderPlutoGatewayelse it executes configureAutochangerPlutoGateway.")
    public void configurePlutoGateway() {
        if (this.name.contains("loader")) {
            this.configureLoaderPlutoGateway();
        } else if (this.getName().startsWith("acSensors")) {
            this.configureAutochangerPlutoGateway();
        }
    }

    private void configureAutochangerPlutoGateway() {
        FCSCst.FCSLOG.debug((Object)(this.name + " configureAutochangerGateway"));
        this.tcpProxy.writeSDO(this.getNodeID(), 8208, 1, 1, 0);
        this.tcpProxy.writeSDO(this.getNodeID(), 8209, 1, 2, 23);
        this.tcpProxy.writeSDO(this.getNodeID(), 8209, 2, 2, 4);
        this.tcpProxy.writeSDO(this.getNodeID(), 8210, 1, 2, 279);
        this.tcpProxy.writeSDO(this.getNodeID(), 8210, 2, 2, 323);
    }

    private void configureLoaderPlutoGateway() {
        FCSCst.FCSLOG.debug((Object)(this.name + " configureLoaderPlutoGateway"));
        this.tcpProxy.writeSDO(this.getNodeID(), 8208, 1, 1, 1);
        this.tcpProxy.writeSDO(this.getNodeID(), 8209, 1, 2, 1);
        this.tcpProxy.writeSDO(this.getNodeID(), 8209, 2, 2, 2);
        this.tcpProxy.writeSDO(this.getNodeID(), 8210, 1, 2, 3);
        this.tcpProxy.writeSDO(this.getNodeID(), 8194, 1, 1, 7);
    }

    public void writeTransmissionType(int transmissionType) {
        String goodAck;
        String ack = this.tcpProxy.writeSDO(this.getNodeID(), 8197, 1, 1, transmissionType);
        if (!ack.equals(goodAck = "OK")) {
            throw new FailedCommandException(this.name + " :bad returned ack for wsdo, index 1801");
        }
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Return values in hexa read on the device.")
    public int[] readNewValues() {
        this.checkBooted();
        try {
            this.readValues[0] = (int)this.tcpProxy.readSDO(this.getNodeID(), 24576, 1);
            this.readValues[1] = (int)this.tcpProxy.readSDO(this.getNodeID(), 24576, 2);
            this.readValues[2] = (int)this.tcpProxy.readSDO(this.getNodeID(), 24576, 3);
            this.readValues[3] = (int)this.tcpProxy.readSDO(this.getNodeID(), 24576, 4);
            this.readValues[4] = (int)this.tcpProxy.readSDO(this.getNodeID(), 24577, 1);
            this.readValues[5] = (int)this.tcpProxy.readSDO(this.getNodeID(), 24577, 2);
            this.readValues[6] = (int)this.tcpProxy.readSDO(this.getNodeID(), 24577, 3);
            this.readValues[7] = (int)this.tcpProxy.readSDO(this.getNodeID(), 24577, 4);
            this.readValues[8] = (int)this.tcpProxy.readSDO(this.getNodeID(), 24578, 1);
            this.readValues[9] = (int)this.tcpProxy.readSDO(this.getNodeID(), 24578, 2);
            this.readValues[10] = (int)this.tcpProxy.readSDO(this.getNodeID(), 24578, 3);
            this.readValues[11] = (int)this.tcpProxy.readSDO(this.getNodeID(), 24578, 4);
            this.readValues[12] = (int)this.tcpProxy.readSDO(this.getNodeID(), 24579, 1);
            this.readValues[13] = (int)this.tcpProxy.readSDO(this.getNodeID(), 24579, 2);
            this.readValues[14] = (int)this.tcpProxy.readSDO(this.getNodeID(), 24579, 3);
            this.readValues[15] = (int)this.tcpProxy.readSDO(this.getNodeID(), 24579, 4);
        }
        catch (ShortResponseToSDORequestException ex) {
            FCSCst.FCSLOG.warning((Object)(this.name + "=> ERROR IN READING SENSOR:" + ex));
        }
        catch (SDORequestException ex) {
            String message = this.name + "=> ERROR IN READING SENSOR:";
            this.raiseAlarm("FCS004:" + this.name, message, (Exception)ex);
        }
        catch (CanOpenCallTimeoutException ex) {
            String msg = this.name + ":" + FcsEnumerations.FcsAlert.CAN_BUS_TIMEOUT.getLongDescription() + " to command: readNewHexaValues - POWER FAILURE ? ";
            this.raiseWarning(this.name + ":" + FcsEnumerations.FcsAlert.CAN_BUS_TIMEOUT, FcsEnumerations.FcsAlert.CAN_BUS_TIMEOUT.getLongDescription(), msg + ex);
        }
        return this.readValues;
    }

    @Override
    public int[] readValuesFromPDO() {
        int[] values = new int[16];
        PDOData pdos = this.tcpProxy.updatePDOData();
        for (int i = 0; i < 16; ++i) {
            values[i] = ((Long)pdos.getPDOs().get(this.nodeID)).intValue();
        }
        return values;
    }
}

