/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.common;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;

public interface EPOSControllerForCarousel
extends EPOSController {
    @Command(type=Command.CommandType.ACTION, level=1, description="Set PositionSensorType to Absolute encoder SSI (value=4)")
    default public void setPositionSensorTypeEncoderSSI() {
        FCSCst.FCSLOG.info((Object)(this.getName() + " setting PositionSensorType Absolute encoder SSI"));
        this.writeParameter(EPOSEnumerations.Parameter.PositionSensorType, 4);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Set PositionSensorType to Sinus Incremental Encoder(value=8)")
    default public void setPositionSensorTypeSinusIncrementalEncoder() {
        FCSCst.FCSLOG.info((Object)(this.getName() + " setting PositionSensorType Sinus Incremental Encoder"));
        this.writeParameter(EPOSEnumerations.Parameter.PositionSensorType, 8);
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=3, description="Define the actual position as position given as argument.")
    default public void defineAbsolutePosition(int position) {
        FCSCst.FCSLOG.debug((Object)(this.getName() + " Defining Absolute Position:" + position));
        this.changeMode(EPOSEnumerations.EposMode.HOMING);
        this.writeParameter(EPOSEnumerations.Parameter.HomePosition, position);
        this.writeParameter(EPOSEnumerations.Parameter.HomingMethod, 35);
        this.enable();
        this.writeControlWord(31);
        this.checkHomingDone();
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Check if homing has been done otherwise throws an Exception.")
    default public void checkHomingDone() {
        long timeout = 500L;
        long timeStart = System.currentTimeMillis();
        long duration = 0L;
        while (!this.isTargetReached() && duration <= timeout) {
            FCSCst.FCSLOG.info((Object)(this.getName() + " homing target not yet reached. duration=" + duration));
            duration = System.currentTimeMillis() - timeStart;
        }
        if (!this.isTargetReached()) {
            throw new FcsHardwareException(this.getName() + " couldn't do homing : target is not reached.");
        }
        this.writeControlWord(15);
        FCSCst.FCSLOG.debug((Object)(this.getName() + " ==> END homing"));
    }
}

