/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.time.Duration;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.logging.Level;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.subsystems.fcs.Autochanger;
import org.lsst.ccs.subsystems.fcs.AutochangerOnlineClamp;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerThreeClamps;
import org.lsst.ccs.subsystems.fcs.common.ControlledBySensors;
import org.lsst.ccs.subsystems.fcs.common.MobileItem;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenCallTimeoutException;
import org.lsst.ccs.subsystems.fcs.errors.FailedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class AutochangerThreeOnlineClamps
extends MobileItem
implements ControlledBySensors {
    @LookupField(strategy=LookupField.Strategy.TREE)
    private Autochanger autochanger;
    private final AutochangerOnlineClamp onlineClampXminus;
    private final AutochangerOnlineClamp onlineClampXplus;
    private final AutochangerOnlineClamp onlineClampYminus;
    private final AutochangerOnlineClamp[] clampsList;
    private FcsEnumerations.LockStatus lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
    private final Condition stateUpdated = this.lock.newCondition();
    protected volatile boolean updatingState = false;
    private ScheduledFuture<?> currentRampHandle;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @ConfigurationParameter(description="timeout in milliseconds : if closing the clamps last more than this amount of time, then the subsystem goes in ERROR.")
    private int timeoutForLockingClamps = 15000;
    @ConfigurationParameter(description="timeout in milliseconds : if unlocking the clamps last more than this amount of time, then the subsystem goes in ERROR.")
    private int timeoutForUnlockingClamps = 15000;
    @ConfigurationParameter(description="maximum time in milliseconds to lock the 3 clamps")
    private int maxTimeToLockAllClamps = 3000;
    @ConfigurationParameter(description="maximum time in milliseconds to unlock the 3 clamps")
    private int maxTimeToUnlockAllClamps = 3000;
    @ConfigurationParameter(description="maximum time in milliseconds to open the 3 clamps")
    private int maxTimeToOpenClampsX = 2000;
    @ConfigurationParameter(description="maximum time in milliseconds to close the 3 clamps")
    private int maxTimeToCloseClampsX = 2000;
    @ConfigurationParameter(description="minimal period for current ramps. should be > 50")
    private int minPeriod = 200;

    public AutochangerThreeOnlineClamps(AutochangerOnlineClamp onlineClampXminus, AutochangerOnlineClamp onlineClampXplus, AutochangerOnlineClamp onlineClampYminus) {
        this.onlineClampXminus = onlineClampXminus;
        this.onlineClampXplus = onlineClampXplus;
        this.onlineClampYminus = onlineClampYminus;
        this.clampsList = new AutochangerOnlineClamp[]{onlineClampXminus, onlineClampXplus, onlineClampYminus};
    }

    @ConfigurationParameterChanger
    public void setMinPeriod(int minPeriod) {
        if (minPeriod < 50) {
            throw new IllegalArgumentException(minPeriod + " bad value for minPeriod. should be > 50");
        }
        this.minPeriod = minPeriod;
    }

    public FcsEnumerations.LockStatus getLockStatus() {
        this.lock.lock();
        try {
            while (this.updatingState) {
                try {
                    this.stateUpdated.await();
                }
                catch (InterruptedException ex) {
                    FCSLOG.warning((Object)(this.name + ": interrupted in getLockStatus."), (Throwable)ex);
                }
            }
            FcsEnumerations.LockStatus lockStatus = this.lockStatus;
            return lockStatus;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if the 3 clamps are LOCKED.")
    public boolean isLocked() {
        return this.onlineClampXminus.isLocked() && this.onlineClampXplus.isLocked() && this.onlineClampYminus.isLocked();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if the 3 clamps are CLOSED.")
    public boolean isClosed() {
        return this.onlineClampXminus.isClosed() && this.onlineClampXplus.isClosed() && this.onlineClampYminus.isClosed();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if the 3 clamps are OPENED.")
    public boolean isOpened() {
        return this.onlineClampXminus.isOpened() && this.onlineClampXplus.isOpened() && this.onlineClampYminus.isOpened();
    }

    private boolean isInTravel() {
        return this.onlineClampXminus.isInTravel() && this.onlineClampXplus.isInTravel() && this.onlineClampYminus.isInTravel();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if one of the clamp is in error.")
    public boolean isInError() {
        return this.onlineClampXminus.isInError() || this.onlineClampXplus.isInError() || this.onlineClampYminus.isInError();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the 3 onlineClamps hardware is ready : controllers ready, controllers parameters checked and controllers configured.")
    public boolean isInitialized() {
        return this.onlineClampXminus.isInitialized() && this.onlineClampXplus.isInitialized() && this.onlineClampYminus.isInitialized();
    }

    private void enableAndCheckControllersBeforeAction() {
        for (AutochangerOnlineClamp clamp : this.clampsList) {
            clamp.enableAndCheckControllerBeforeAction();
        }
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Closes and locks the online clamps.", timeout=15000)
    public void closeAndLockClamps() {
        this.updateStateAndCheckSensors();
        if (this.isOpened()) {
            this.onlineClampYminus.close();
            this.executeAction(FcsEnumerations.MobileItemAction.CLOSE_AND_LOCK_ONLINECLAMPS, this.timeoutForLockingClamps);
        } else if (this.isLocked()) {
            FCSLOG.info((Object)(this.name + " is already LOCKED - nothing to do."));
        } else {
            throw new RejectedCommandException(this.name + " has to be OPENED before a closeAndLockClamps");
        }
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Unlock and open the online clamps.", timeout=15000)
    public void unlockAndOpenClamps() {
        this.updateStateAndCheckSensors();
        this.enableAndCheckControllersBeforeAction();
        this.autochanger.checkConditionsForActioningOnlineClamps();
        this.currentAction = FcsEnumerations.MobileItemAction.UNLOCK_AND_OPEN_ONLINECLAMPS;
        if (this.isLocked()) {
            this.doUnlock();
            this.updateStateAndCheckSensors();
            if (!this.isClosed()) {
                throw new FailedCommandException(this.name + "couldn't unlock clamps");
            }
            this.onlineClampYminus.open();
            this.openClampsX();
            this.updateStateAndCheckSensors();
            this.activateBrakesAndSetCurrentToZero();
            if (!this.isOpened()) {
                throw new FailedCommandException(this.name + "couldn't open clamps");
            }
        } else if (this.isOpened()) {
            FCSLOG.info((Object)(this.name + " clamps already UNLOCKED and OPENED - nothing to do"));
        } else {
            throw new RejectedCommandException(this.name + " has to be LOCKED before unlockAndOpen action.");
        }
    }

    public void testPeriodTask() {
        this.periodicTaskService.scheduleAgentPeriodicTask(new AgentPeriodicTask(this.name + "-updateStateAndCheckSensors", this::updateStateAndCheckSensors).withIsFixedRate(true).withLogLevel(Level.WARNING).withPeriod(Duration.ofMillis(5000L)));
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Close the 3 online clamps.", timeout=15000)
    public void closeClamps() {
        this.updateStateAndCheckSensors();
        if (this.isOpened()) {
            this.onlineClampYminus.close();
            this.executeAction(FcsEnumerations.MobileItemAction.CLOSE_ONLINECLAMPS, this.timeoutForLockingClamps);
        } else if (this.isClosed()) {
            FCSLOG.info((Object)(this.name + " clamps already CLOSED nothing to do"));
        } else {
            throw new RejectedCommandException(this.name + " has to be unlocked before.");
        }
    }

    @Command(type=Command.CommandType.ACTION, description="close clamps X", timeout=15000)
    public void closeClampsX() {
        this.checkParametersToCloseClampsX();
        this.currentAction = FcsEnumerations.MobileItemAction.CLOSE_ONLINECLAMPS;
        this.onlineClampXminus.enableAndCheckControllerBeforeAction();
        this.onlineClampXminus.getController().doReleaseBrake();
        this.onlineClampXplus.enableAndCheckControllerBeforeAction();
        this.onlineClampXplus.getController().doReleaseBrake();
        this.onlineClampXminus.sendCurrentToControllerAndSaveValue(this.onlineClampXminus.getInitialCurrentToClose());
        this.onlineClampXplus.sendCurrentToControllerAndSaveValue(this.onlineClampXplus.getInitialCurrentToClose());
        FcsUtils.sleep(this.onlineClampXminus.getWaitTimeToClose(), this.name);
        this.executeCurrentRampToCloseClampsX();
        this.updateStateAndCheckSensors();
        this.onlineClampXminus.getController().activateBrake();
        this.onlineClampXplus.getController().activateBrake();
        this.onlineClampXminus.getController().writeCurrent(0);
        this.onlineClampXplus.getController().writeCurrent(0);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Opens the 3 online clamps with a small pressure.", timeout=15000)
    public void openClamps() {
        this.updateStateAndCheckSensors();
        if (!this.isClosed()) {
            if (this.isOpened()) {
                FCSLOG.info((Object)(this.name + " clamps already OPENED. Nothing to do."));
                throw new RejectedCommandException(this.name + " clamps already OPENED. Nothing to do.");
            }
            throw new RejectedCommandException(this.name + " has to be closed before.");
        }
        this.checkReadyForAction();
        this.checkParametersToOpenClampsX();
        this.currentAction = FcsEnumerations.MobileItemAction.OPEN_ONLINECLAMPS;
        this.onlineClampYminus.open();
        this.openClampsX();
    }

    @Command(type=Command.CommandType.ACTION, description="open softly clampX", timeout=15000)
    public void openClampsX() {
        this.checkParametersToOpenClampsX();
        this.currentAction = FcsEnumerations.MobileItemAction.OPEN_ONLINECLAMPSX;
        this.onlineClampXminus.enableAndCheckControllerBeforeAction();
        this.onlineClampXplus.enableAndCheckControllerBeforeAction();
        this.onlineClampXminus.sendCurrentToControllerAndSaveValue(this.onlineClampXminus.getFinalCurrentToClose());
        this.onlineClampXplus.sendCurrentToControllerAndSaveValue(this.onlineClampXplus.getFinalCurrentToClose());
        FcsUtils.sleep(500, this.name);
        this.onlineClampXminus.getController().doReleaseBrake();
        this.onlineClampXplus.getController().doReleaseBrake();
        this.executeAction(this.currentAction, this.timeoutForUnlockingClamps);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Locks clamps : closed with a strong pressure (high current).", timeout=15000)
    public void lockClamps() {
        this.updateStateAndCheckSensors();
        if (this.isClosed()) {
            this.executeAction(FcsEnumerations.MobileItemAction.LOCK_ONLINECLAMPS, this.timeoutForLockingClamps);
        } else if (this.isLocked()) {
            FCSLOG.info((Object)(this.name + " is already LOCKED. Nothing to do."));
        } else {
            throw new RejectedCommandException(this.name + " have to be CLOSED before to be locked.");
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="unlocks clamps : decreases current in controller to decrease pressure.", timeout=15000)
    public void unlockClamps() {
        this.updateStateAndCheckSensors();
        if (this.isLocked()) {
            this.executeAction(FcsEnumerations.MobileItemAction.UNLOCK_ONLINECLAMPS, this.timeoutForLockingClamps);
        } else if (this.isClosed()) {
            FCSLOG.info((Object)(this.name + " is already CLOSED. Nothing to do."));
        } else {
            throw new RejectedCommandException(this.name + " have to be CLOSED before to be locked.");
        }
    }

    private void sendCurrentToCloseAllClamps() {
        FCSLOG.info((Object)(this.name + " sending current to close all clamps"));
        for (AutochangerOnlineClamp clamp : this.clampsList) {
            clamp.sendCurrentToControllerAndSaveValue(clamp.getFinalCurrentToClose());
        }
    }

    private void sendCurrentToLockAllClamps() {
        for (AutochangerOnlineClamp clamp : this.clampsList) {
            clamp.sendCurrentToControllerAndSaveValue(clamp.getCurrentToClamp());
        }
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the 3 onlineClamps hardware is ready.")
    public boolean myDevicesReady() {
        return this.onlineClampXminus.myDevicesReady() && this.onlineClampXplus.myDevicesReady() && this.onlineClampYminus.myDevicesReady();
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        if (action == FcsEnumerations.MobileItemAction.CLOSE_ONLINECLAMPS || action == FcsEnumerations.MobileItemAction.UNLOCK_ONLINECLAMPS) {
            return this.isClosed();
        }
        if (action == FcsEnumerations.MobileItemAction.UNLOCK_AND_OPEN_ONLINECLAMPS || action == FcsEnumerations.MobileItemAction.OPEN_ONLINECLAMPS) {
            return this.isOpened();
        }
        if (action == FcsEnumerations.MobileItemAction.LOCK_ONLINECLAMPS || action == FcsEnumerations.MobileItemAction.CLOSE_AND_LOCK_ONLINECLAMPS) {
            return this.isLocked();
        }
        if (action == FcsEnumerations.MobileItemAction.OPEN_ONLINECLAMPSX) {
            return this.onlineClampXminus.isOpened() && this.onlineClampXplus.isOpened();
        }
        throw new IllegalArgumentException(this.name + " invalid action:" + (Object)((Object)action));
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() {
        this.autochanger.updateStateWithSensors();
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) {
        this.enableAndCheckControllersBeforeAction();
        this.autochanger.checkConditionsForActioningOnlineClamps();
        this.autochanger.increaseCurrentMonitoring();
        if (action == FcsEnumerations.MobileItemAction.CLOSE_AND_LOCK_ONLINECLAMPS) {
            this.closeClampsX();
            this.doLock();
        } else if (action == FcsEnumerations.MobileItemAction.CLOSE_ONLINECLAMPS) {
            this.closeClampsX();
        } else if (action == FcsEnumerations.MobileItemAction.UNLOCK_AND_OPEN_ONLINECLAMPS) {
            this.openClampsX();
        } else if (action == FcsEnumerations.MobileItemAction.UNLOCK_ONLINECLAMPS) {
            this.doUnlock();
        } else if (action == FcsEnumerations.MobileItemAction.LOCK_ONLINECLAMPS) {
            this.doLock();
        } else if (action != FcsEnumerations.MobileItemAction.OPEN_ONLINECLAMPS) {
            if (action == FcsEnumerations.MobileItemAction.OPEN_ONLINECLAMPSX) {
                this.executeCurrentRampToOpenClampsX();
            } else {
                throw new IllegalArgumentException(this.name + " invalid action:" + (Object)((Object)action));
            }
        }
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) {
        if (action == FcsEnumerations.MobileItemAction.OPEN_ONLINECLAMPSX) {
            this.onlineClampXminus.getController().activateBrake();
            this.onlineClampXplus.getController().activateBrake();
            this.onlineClampXminus.getController().writeCurrent(0);
            this.onlineClampXplus.getController().writeCurrent(0);
        } else {
            this.activateBrakesAndSetCurrentToZero();
        }
        this.autochanger.decreaseCurrentMonitoring();
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void postAction(FcsEnumerations.MobileItemAction action) {
    }

    private void activateBrakesAndSetCurrentToZero() {
        for (AutochangerOnlineClamp clamp : this.clampsList) {
            clamp.getController().activateBrake();
            clamp.getController().writeCurrent(0);
        }
    }

    private void doReleaseBrakes() {
        for (AutochangerOnlineClamp clamp : this.clampsList) {
            clamp.getController().doReleaseBrake();
        }
    }

    private void doLock() {
        this.sendCurrentToCloseAllClamps();
        FcsUtils.sleep(500, this.name);
        this.doReleaseBrakes();
        this.executeCurrentRampToLockAllClamps();
    }

    private void doUnlock() {
        this.sendCurrentToLockAllClamps();
        FcsUtils.sleep(500, this.name);
        this.doReleaseBrakes();
        this.executeCurrentRampToUnlockAllClamps();
    }

    public StatusDataPublishedByAutochangerThreeClamps createStatusDataPublishedByThreeClamps() {
        StatusDataPublishedByAutochangerThreeClamps status = new StatusDataPublishedByAutochangerThreeClamps();
        status.setName(this.name);
        status.setLockStatus(this.lockStatus);
        return status;
    }

    @Override
    public void publishData() {
        this.s.publishSubsystemDataOnStatusBus(new KeyValueData("autochangerClamps", (Serializable)this.createStatusDataPublishedByThreeClamps()));
    }

    private void updateStateAndCheckSensors() {
        this.autochanger.updateStateWithSensors();
        this.checkSensors(FcsEnumerations.FcsAlert.AC_SENSOR_ERROR, this.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, level=1, description="Update state.")
    public void updateState() {
        this.lock.lock();
        try {
            this.updatingState = true;
            for (AutochangerOnlineClamp clamp : this.clampsList) {
                clamp.updateState();
            }
            this.computeLockStatus();
        }
        finally {
            this.updatingState = false;
            this.stateUpdated.signalAll();
            this.lock.unlock();
            this.publishData();
        }
    }

    private void computeLockStatus() {
        this.lockStatus = this.isInError() ? FcsEnumerations.LockStatus.ERROR : (this.isLocked() ? FcsEnumerations.LockStatus.LOCKED : (this.isOpened() ? FcsEnumerations.LockStatus.OPENED : (this.isClosed() ? FcsEnumerations.LockStatus.CLOSED : (this.isInTravel() ? FcsEnumerations.LockStatus.INTRAVEL : FcsEnumerations.LockStatus.UNKNOWN))));
    }

    private void executeCurrentRampToCloseClampsX() {
        this.writeCurrentRampToCloseClampsX();
        this.waitForEndOfCurrentRamp(this.timeoutForLockingClamps);
    }

    private void executeCurrentRampToOpenClampsX() {
        FCSLOG.info((Object)(this.name + " executeCurrentRampToOpenClampsX"));
        this.writeCurrentRampToOpenClampsX();
        this.waitForEndOfCurrentRamp(this.timeoutForUnlockingClamps);
    }

    private void executeCurrentRampToLockAllClamps() {
        FCSLOG.info((Object)(this.name + " executing current ramp to lock all clamps."));
        this.writeCurrentRampToLockAllClamps();
        this.waitForEndOfCurrentRamp(this.timeoutForLockingClamps);
    }

    private void executeCurrentRampToUnlockAllClamps() {
        this.writeCurrentRampToUnlockAllClamps();
        this.waitForEndOfCurrentRamp(this.timeoutForUnlockingClamps);
    }

    private void cancelCurrentRamp() {
        FCSLOG.finest((Object)" => stop writing current");
        this.currentRampHandle.cancel(true);
        FCSLOG.finest((Object)" => current ramp ended");
    }

    private void waitForEndOfCurrentRamp(int timeout) {
        FCSLOG.info((Object)(this.name + " BEGIN WAITING FOR END OF CURRENT RAMP"));
        try {
            this.currentRampHandle.get(timeout, TimeUnit.SECONDS);
        }
        catch (CancellationException ex) {
            if (this.currentRampHandle.isDone()) {
                FCSLOG.info((Object)(this.name + " CURRENT RAMP ENDED"));
            } else {
                FCSLOG.error((Object)(this.name + " during action " + (Object)((Object)this.currentAction) + " waiting was cancelled before END of CURRENT RAMP " + ex));
            }
        }
        catch (TimeoutException ex) {
            FCSLOG.error((Object)(this.name + " CURRENT RAMP IS DURING TOO LONG - timeout=" + timeout), (Throwable)ex);
        }
        catch (InterruptedException ex) {
            FCSLOG.error((Object)(this.name + " interrupted while waiting end of current ramp during action=" + (Object)((Object)this.currentAction)), (Throwable)ex);
            throw new FcsHardwareException(this.name + " interrupted while waiting end of current ramp during action=" + (Object)((Object)this.currentAction), ex);
        }
        catch (ExecutionException ex) {
            FCSLOG.error((Object)(this.name + " error during action=" + (Object)((Object)this.currentAction)), (Throwable)ex);
            throw new FcsHardwareException(this.name + " error during action=" + (Object)((Object)this.currentAction) + " cause=" + ex);
        }
        finally {
            this.cancelCurrentRamp();
            FCSLOG.info((Object)(this.name + " STOP WAITING FOR END OF CURRENT RAMP"));
        }
    }

    private void writeCurrentRampToCloseClampsX() {
        this.writeCurrentRampToClampsX(this.onlineClampXminus.getInitialCurrentToClose(), this.onlineClampXminus.getFinalCurrentToClose(), this.onlineClampXminus.getIncrementCurrentToClose(), this.onlineClampXplus.getInitialCurrentToClose(), this.onlineClampXplus.getFinalCurrentToClose(), this.onlineClampXplus.getIncrementCurrentToClose(), this.maxTimeToCloseClampsX);
    }

    private void writeCurrentRampToOpenClampsX() {
        FCSLOG.info((Object)(this.name + " writeCurrentRampToOpenClampsX"));
        this.writeCurrentRampToClampsX(this.onlineClampXminus.getFinalCurrentToClose(), this.onlineClampXminus.getCurrentToOpen(), this.onlineClampXminus.getIncrementCurrentToOpen(), this.onlineClampXplus.getFinalCurrentToClose(), this.onlineClampXplus.getCurrentToOpen(), this.onlineClampXplus.getIncrementCurrentToOpen(), this.maxTimeToOpenClampsX);
    }

    private void writeCurrentRampToLockAllClamps() {
        this.writeCurrentRampToAllClamps(this.onlineClampYminus.getFinalCurrentToClose(), this.onlineClampYminus.getCurrentToClamp(), this.onlineClampYminus.getIncrementCurrentToClamp(), this.onlineClampXminus.getFinalCurrentToClose(), this.onlineClampXminus.getCurrentToClamp(), this.onlineClampXminus.getIncrementCurrentToClamp(), this.onlineClampXplus.getFinalCurrentToClose(), this.onlineClampXplus.getCurrentToClamp(), this.onlineClampXplus.getIncrementCurrentToClamp(), this.maxTimeToLockAllClamps);
    }

    private void writeCurrentRampToUnlockAllClamps() {
        this.writeCurrentRampToAllClamps(this.onlineClampYminus.getCurrentToClamp(), this.onlineClampYminus.getFinalCurrentToClose(), this.onlineClampYminus.getIncrementCurrentToClamp(), this.onlineClampXminus.getCurrentToClamp(), this.onlineClampXminus.getFinalCurrentToClose(), this.onlineClampXminus.getIncrementCurrentToClamp(), this.onlineClampXplus.getCurrentToClamp(), this.onlineClampXplus.getFinalCurrentToClose(), this.onlineClampXplus.getIncrementCurrentToClamp(), this.maxTimeToUnlockAllClamps);
    }

    @Command(type=Command.CommandType.QUERY)
    public void checkParametersToOpenClampsX() {
        int nbStepXplus;
        int initialValueXminus = this.onlineClampXminus.getFinalCurrentToClose();
        int finalValueXminus = this.onlineClampXminus.getCurrentToOpen();
        int incrementCurrentXminus = this.onlineClampXminus.getIncrementCurrentToOpen();
        int initialValueXplus = this.onlineClampXplus.getFinalCurrentToClose();
        int finalValueXplus = this.onlineClampXplus.getCurrentToOpen();
        int incrementCurrentXplus = this.onlineClampXplus.getIncrementCurrentToOpen();
        int nbStepXminus = Math.abs((finalValueXminus - initialValueXminus) / incrementCurrentXminus);
        int period = this.maxTimeToOpenClampsX / Math.min(nbStepXminus, nbStepXplus = Math.abs((finalValueXplus - initialValueXplus) / incrementCurrentXplus));
        if (period < this.minPeriod) {
            int newMaxTime = this.minPeriod * Math.min(nbStepXminus, nbStepXplus);
            throw new IllegalArgumentException(this.maxTimeToOpenClampsX + " : value too low for maxTimeToOpenClampsX. should be >= " + newMaxTime);
        }
        if (nbStepXminus != nbStepXplus) {
            FCSLOG.finest((Object)(this.name + ": nbstep to open are not equal for the 2 clamps X"));
        }
    }

    @Command(type=Command.CommandType.QUERY)
    public void checkParametersToCloseClampsX() {
        int nbStepXplus;
        int initialValueXminus = this.onlineClampXminus.getInitialCurrentToClose();
        int finalValueXminus = this.onlineClampXminus.getFinalCurrentToClose();
        int incrementCurrentXminus = this.onlineClampXminus.getIncrementCurrentToClose();
        int initialValueXplus = this.onlineClampXplus.getInitialCurrentToClose();
        int finalValueXplus = this.onlineClampXplus.getFinalCurrentToClose();
        int incrementCurrentXplus = this.onlineClampXplus.getIncrementCurrentToClose();
        int nbStepXminus = Math.abs((finalValueXminus - initialValueXminus) / incrementCurrentXminus);
        int period = this.maxTimeToCloseClampsX / Math.min(nbStepXminus, nbStepXplus = Math.abs((finalValueXplus - initialValueXplus) / incrementCurrentXplus));
        if (period < this.minPeriod) {
            int newMaxTime = this.minPeriod * Math.min(nbStepXminus, nbStepXplus);
            throw new IllegalArgumentException(this.maxTimeToCloseClampsX + " : value too low. should be > " + newMaxTime);
        }
        if (nbStepXminus != nbStepXplus) {
            FCSLOG.finest((Object)(this.name + ": nbstep to open are not equal for the 2 clamps X"));
        }
    }

    private void writeCurrentRampToClampsX(final int initialValueXminus, final int finalValueXminus, int incrementCurrentXminus, final int initialValueXplus, final int finalValueXplus, int incrementCurrentXplus, int maxTime) {
        final int stepHeightXminus = FcsUtils.getSignedStepHeight(initialValueXminus, finalValueXminus, incrementCurrentXminus);
        final int stepHeightXplus = FcsUtils.getSignedStepHeight(initialValueXplus, finalValueXplus, incrementCurrentXplus);
        int nbStepXminus = Math.abs((finalValueXminus - initialValueXminus) / incrementCurrentXminus);
        int nbStepXplus = Math.abs((finalValueXplus - initialValueXplus) / incrementCurrentXplus);
        int period = maxTime / Math.min(nbStepXminus, nbStepXplus);
        FCSLOG.finest((Object)"############################################################");
        FCSLOG.finest((Object)("initialValue for clampXminus=" + initialValueXminus));
        FCSLOG.finest((Object)("finalValue for clampXminus=" + finalValueXminus));
        FCSLOG.finest((Object)("initialValue for clampXplus=" + initialValueXplus));
        FCSLOG.finest((Object)("finalValue for clampXplus=" + finalValueXplus));
        FCSLOG.finest((Object)("period=" + period));
        FCSLOG.finest((Object)("nbStepXminus=" + nbStepXminus));
        FCSLOG.finest((Object)("stepHeightXplus=" + stepHeightXplus));
        FCSLOG.finest((Object)("nbStepXminus=" + nbStepXminus));
        FCSLOG.finest((Object)("nbStepXplus=" + nbStepXplus));
        FCSLOG.finest((Object)"############################################################");
        Runnable currentRamp = new Runnable(){
            private int newCurrentValueXminus;
            private int newCurrentValueXplus;
            private boolean finalValueReachedXminus;
            private boolean finalValueReachedXplus;
            {
                this.newCurrentValueXminus = initialValueXminus;
                this.newCurrentValueXplus = initialValueXplus;
                this.finalValueReachedXminus = false;
                this.finalValueReachedXplus = false;
            }

            @Override
            public void run() {
                this.newCurrentValueXminus = FcsUtils.computeNewCurrentValue(stepHeightXminus, this.newCurrentValueXminus, finalValueXminus);
                this.newCurrentValueXplus = FcsUtils.computeNewCurrentValue(stepHeightXplus, this.newCurrentValueXplus, finalValueXplus);
                try {
                    if (!this.finalValueReachedXminus) {
                        AutochangerThreeOnlineClamps.this.onlineClampXminus.sendCurrentToControllerAndSaveValue(this.newCurrentValueXminus);
                    }
                    if (!this.finalValueReachedXplus) {
                        AutochangerThreeOnlineClamps.this.onlineClampXplus.sendCurrentToControllerAndSaveValue(this.newCurrentValueXplus);
                    }
                    this.finalValueReachedXminus = this.newCurrentValueXminus == finalValueXminus;
                }
                catch (CanOpenCallTimeoutException ex) {
                    try {
                        FCSLOG.error((Object)ex);
                        this.finalValueReachedXminus = this.newCurrentValueXminus == finalValueXminus;
                    }
                    catch (Throwable throwable) {
                        this.finalValueReachedXminus = this.newCurrentValueXminus == finalValueXminus;
                        this.finalValueReachedXplus = this.newCurrentValueXplus == finalValueXplus;
                        throw throwable;
                    }
                    this.finalValueReachedXplus = this.newCurrentValueXplus == finalValueXplus;
                }
                this.finalValueReachedXplus = this.newCurrentValueXplus == finalValueXplus;
                if (this.finalValueReachedXminus && this.finalValueReachedXplus) {
                    AutochangerThreeOnlineClamps.this.cancelCurrentRamp();
                }
            }
        };
        this.currentRampHandle = this.scheduler.scheduleAtFixedRate(currentRamp, 0L, period, TimeUnit.MILLISECONDS);
    }

    private void writeCurrentRampToAllClamps(final int initialValueYminus, final int finalValueYminus, int incrementYminus, final int initialValueXminus, final int finalValueXminus, int incrementXminus, final int initialValueXplus, final int finalValueXplus, int incrementXplus, int maxTime) {
        final int stepHeightYminus = FcsUtils.getSignedStepHeight(initialValueYminus, finalValueYminus, incrementYminus);
        final int stepHeightXminus = FcsUtils.getSignedStepHeight(initialValueXminus, finalValueXminus, incrementXminus);
        final int stepHeightXplus = FcsUtils.getSignedStepHeight(initialValueXplus, finalValueXplus, incrementXplus);
        int nbStepYminus = Math.abs((finalValueYminus - initialValueYminus) / stepHeightYminus);
        int nbStepXminus = Math.abs((finalValueXminus - initialValueXminus) / stepHeightXminus);
        int nbStepXplus = Math.abs((finalValueXplus - initialValueXplus) / stepHeightXplus);
        int period = maxTime / nbStepYminus;
        if (period < 200) {
            throw new IllegalArgumentException(period + " : bad value for period");
        }
        FCSLOG.finest((Object)"############################################################");
        FCSLOG.finest((Object)("initialValue for clampYminus=" + initialValueYminus));
        FCSLOG.finest((Object)("finalValue for clampYminus=" + finalValueYminus));
        FCSLOG.finest((Object)("initialValue for clampXminus=" + initialValueXminus));
        FCSLOG.finest((Object)("finalValue for clampXminus=" + finalValueXminus));
        FCSLOG.finest((Object)("initialValue for clampXplus=" + initialValueXplus));
        FCSLOG.finest((Object)("finalValue for clampXplus=" + finalValueXplus));
        FCSLOG.finest((Object)("nbStepYminus=" + nbStepYminus + " nbStepXminus=" + nbStepXminus + " nbStepXplus=" + nbStepXplus));
        FCSLOG.finest((Object)("period=" + period));
        FCSLOG.finest((Object)("stepHeightYminus=" + stepHeightYminus));
        FCSLOG.finest((Object)("stepHeightXminus=" + stepHeightXminus));
        FCSLOG.finest((Object)("stepHeightXplus=" + stepHeightXplus));
        FCSLOG.finest((Object)"############################################################");
        Runnable currentRamp = new Runnable(){
            private int newCurrentValueYminus;
            private int newCurrentValueXminus;
            private int newCurrentValueXplus;
            boolean finalValueReachedYminus;
            boolean finalValueReachedXminus;
            boolean finalValueReachedXplus;
            {
                this.newCurrentValueYminus = initialValueYminus;
                this.newCurrentValueXminus = initialValueXminus;
                this.newCurrentValueXplus = initialValueXplus;
                this.finalValueReachedYminus = false;
                this.finalValueReachedXminus = false;
                this.finalValueReachedXplus = false;
            }

            @Override
            public void run() {
                this.newCurrentValueYminus = FcsUtils.computeNewCurrentValue(stepHeightYminus, this.newCurrentValueYminus, finalValueYminus);
                this.newCurrentValueXminus = FcsUtils.computeNewCurrentValue(stepHeightXminus, this.newCurrentValueXminus, finalValueXminus);
                this.newCurrentValueXplus = FcsUtils.computeNewCurrentValue(stepHeightXplus, this.newCurrentValueXplus, finalValueXplus);
                try {
                    if (!this.finalValueReachedYminus) {
                        AutochangerThreeOnlineClamps.this.onlineClampYminus.sendCurrentToControllerAndSaveValue(this.newCurrentValueYminus);
                    }
                    if (!this.finalValueReachedXminus) {
                        AutochangerThreeOnlineClamps.this.onlineClampXminus.sendCurrentToControllerAndSaveValue(this.newCurrentValueXminus);
                    }
                    if (!this.finalValueReachedXplus) {
                        AutochangerThreeOnlineClamps.this.onlineClampXplus.sendCurrentToControllerAndSaveValue(this.newCurrentValueXplus);
                    }
                    this.finalValueReachedYminus = this.newCurrentValueYminus == finalValueYminus;
                }
                catch (CanOpenCallTimeoutException ex) {
                    try {
                        FCSLOG.error((Object)ex);
                        this.finalValueReachedYminus = this.newCurrentValueYminus == finalValueYminus;
                    }
                    catch (Throwable throwable) {
                        this.finalValueReachedYminus = this.newCurrentValueYminus == finalValueYminus;
                        this.finalValueReachedXminus = this.newCurrentValueXminus == finalValueXminus;
                        this.finalValueReachedXplus = this.newCurrentValueXplus == finalValueXplus;
                        throw throwable;
                    }
                    this.finalValueReachedXminus = this.newCurrentValueXminus == finalValueXminus;
                    this.finalValueReachedXplus = this.newCurrentValueXplus == finalValueXplus;
                }
                this.finalValueReachedXminus = this.newCurrentValueXminus == finalValueXminus;
                this.finalValueReachedXplus = this.newCurrentValueXplus == finalValueXplus;
                if (this.finalValueReachedYminus && this.finalValueReachedXminus && this.finalValueReachedXplus) {
                    AutochangerThreeOnlineClamps.this.cancelCurrentRamp();
                }
            }
        };
        this.currentRampHandle = this.scheduler.scheduleAtFixedRate(currentRamp, 0L, period, TimeUnit.MILLISECONDS);
    }
}

