/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.AlertService;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.HardwareController;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystems.fcs.AutochangerThreeOnlineClamps;
import org.lsst.ccs.subsystems.fcs.AutochangerTwoLatches;
import org.lsst.ccs.subsystems.fcs.AutochangerTwoTrucks;
import org.lsst.ccs.subsystems.fcs.ComplementarySensors;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.FilterIdentificator;
import org.lsst.ccs.subsystems.fcs.FilterManager;
import org.lsst.ccs.subsystems.fcs.Inclinometer;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChanger;
import org.lsst.ccs.subsystems.fcs.common.AlertRaiser;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.FilterHolder;
import org.lsst.ccs.subsystems.fcs.common.PlutoGatewayInterface;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;

public class Autochanger
implements HardwareController,
FilterHolder,
AlertRaiser,
HasLifecycle {
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem subs;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private ConfigurationService configurationService;
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.BYNAME)
    private BridgeToHardware tcpProxy;
    private final PlutoGatewayInterface plutoGateway;
    @LookupField(strategy=LookupField.Strategy.BYNAME)
    private FilterManager filterManager;
    @LookupField(strategy=LookupField.Strategy.BYNAME)
    private FilterIdentificator filterIdentificator;
    @LookupField(strategy=LookupField.Strategy.BYNAME)
    private ComplementarySensors loaderConnectedSensors;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private AutochangerTwoTrucks autochangerTrucks;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private AutochangerTwoLatches latches;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private AutochangerThreeOnlineClamps onlineClamps;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private MainModule main;
    private int filterOnTrucksID = 0;
    @LookupField(strategy=LookupField.Strategy.BYNAME)
    private FilterHolder carousel;
    @LookupField(strategy=LookupField.Strategy.BYNAME)
    private FilterHolder loader;
    @LookupField(strategy=LookupField.Strategy.BYNAME)
    private Inclinometer inclinometerXminus;
    @LookupField(strategy=LookupField.Strategy.BYNAME)
    private Inclinometer inclinometerXplus;
    private final Lock lock = new ReentrantLock();
    private final Condition stateUpdated = this.lock.newCondition();
    private volatile boolean updatingState = false;

    public Autochanger(PlutoGatewayInterface plutoGateway) {
        this.plutoGateway = plutoGateway;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Subsystem getSubsystem() {
        return this.subs;
    }

    @Override
    public AlertService getAlertService() {
        return this.alertService;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return true if an error has been detected on sensors.")
    public boolean isSensorsInError() {
        return this.latches.isInError() || this.onlineClamps.isInError() || this.autochangerTrucks.isPositionSensorsInError();
    }

    public AutochangerTwoTrucks getAutochangerTrucks() {
        return this.autochangerTrucks;
    }

    public AutochangerThreeOnlineClamps getOnlineClamps() {
        return this.onlineClamps;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="If autochanger holds a filter, return filterID, else return 0.")
    public int getFilterOnTrucksID() {
        return this.filterOnTrucksID;
    }

    public void setFilterOnTrucksID(int filterOnTrucksID) {
        this.filterOnTrucksID = filterOnTrucksID;
    }

    public void setFilterOnAutochanger() {
        if (this.filterOnTrucksID != 0) {
            this.filterManager.setFilterLocation(this.filterOnTrucksID, FcsEnumerations.FilterLocation.AUTOCHANGER);
        }
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="If autochanger holds a filter, return filter name else return null.")
    public String getFilterOnTrucksName() {
        if (this.isHoldingFilter()) {
            return this.filterManager.getFilterNameByID(this.filterOnTrucksID);
        }
        return null;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the loader is connected to the camera. This command doesn't read again the sensors.")
    public boolean isLoaderConnected() {
        this.lock.lock();
        try {
            while (this.updatingState) {
                try {
                    this.stateUpdated.await();
                }
                catch (InterruptedException ex) {
                    FCSCst.FCSLOG.error((Object)(this.name + ": has been interrupted while waiting for end of update."));
                }
            }
            boolean bl = this.loaderConnectedSensors.isOn() && !this.loaderConnectedSensors.isInError();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the carousel is holding the filter at STANDBY position.")
    public boolean isCarouselHoldingFilterAtStandby() {
        return this.carousel.isAtStandby() && this.carousel.isHoldingFilter();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if loader is connected and holding a filter. This command doesn't read again the sensors.")
    public boolean isLoaderHoldingFilterAtHandoff() {
        return this.isLoaderConnected() && this.loader.isHoldingFilter();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if all autochanger CANopen devices are booted, identified and initialized.")
    public boolean isCANDevicesReady() {
        return this.tcpProxy.allDevicesBooted();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if all autochanger CANopen devices are booted, identified and initialized and homing of the controllers is done.")
    public boolean isHardwareReady() {
        return this.tcpProxy.allDevicesBooted() && this.isInitialized();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if all autochanger hardware is initialized.")
    public boolean isInitialized() {
        return this.plutoGateway.isInitialized() && this.autochangerTrucks.isInitialized() && this.latches.isInitialized() && this.onlineClamps.isInitialized();
    }

    public void postStart() {
        FCSCst.FCSLOG.fine((Object)(this.name + " BEGIN postStart."));
        if (this.plutoGateway.isBooted()) {
            this.initializeGateway();
        } else {
            this.plutoGateway.raiseAlarmIfMissing();
        }
        FCSCst.FCSLOG.fine((Object)(this.name + " END postStart."));
    }

    private void initializeGateway() {
        try {
            this.plutoGateway.initializeAndCheckHardware();
            this.updateStateWithSensors();
        }
        catch (FcsHardwareException ex) {
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, this.name + " couldn't initialize gateway", this.plutoGateway.getName(), ex);
        }
    }

    public void checkStarted() {
        FCSCst.FCSLOG.info((Object)(this.name + " BEGIN checkStarted"));
        this.tcpProxy.bootProcess();
        try {
            this.plutoGateway.initializeAndCheckHardware();
            this.updateStateWithSensors();
            this.autochangerTrucks.initializeControllers();
        }
        catch (FcsHardwareException ex) {
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, " couldn't initialize autochanger", ex);
        }
        FCSCst.FCSLOG.info((Object)(this.name + " END checkStarted"));
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if the latches can be opened.")
    public void checkConditionsForOpeningLatches() {
        FCSCst.FCSLOG.info((Object)(this.name + " checking pre-conditions for opening latches"));
        this.updateStateWithSensors();
        this.checkLatchesInitialized();
        if (this.latches.isInError()) {
            throw new FcsHardwareException(this.name + ": latches are in ERROR state - can't unlockClamps latches.");
        }
        if (this.isEmpty()) {
            throw new RejectedCommandException(this.name + ": no filter in autochanger - can't open latches.");
        }
        if (!this.autochangerTrucks.isAtStandby() && !this.autochangerTrucks.isAtHandoff()) {
            throw new RejectedCommandException(this.name + ": autochanger is loaded with a filter but is not at handoff position neither at standby - can't open latches.");
        }
        if (this.autochangerTrucks.isAtStandby()) {
            this.checkConditionsForOpeningLatchesAtStandby();
        } else if (this.autochangerTrucks.isAtHandoff()) {
            this.checkConditionsForOpeningLatchesAtHandoff();
        }
    }

    private void checkLatchesInitialized() {
        if (!this.latches.isInitialized()) {
            throw new RejectedCommandException(this.name + ": latches are not intialized. Please initialize hardware first.");
        }
    }

    private void checkConditionsForOpeningLatchesAtStandby() {
        if (!this.isCarouselHoldingFilterAtStandby()) {
            throw new RejectedCommandException(this.name + ": autochanger is loaded with a filter and is  at STANDBY position but carousel doesn't hold the filter - can't open latches.");
        }
        FCSCst.FCSLOG.info((Object)(this.name + " carousel is holding filter at STANDBY => latches can be open safely."));
    }

    private void checkConditionsForOpeningLatchesAtHandoff() {
        if (!this.isLoaderHoldingFilterAtHandoff()) {
            throw new RejectedCommandException(this.name + ": autochanger is loaded with a filter and is  at HANDOFF position but loader doesn't hold the filter - can't open latches.");
        }
        FCSCst.FCSLOG.info((Object)(this.name + " loader is holding filter at HANDOFF => latches can be open safely."));
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if Autochanger latches can be closed.")
    public void checkConditionsForClosingLatches() {
        FCSCst.FCSLOG.info((Object)(this.name + " checking conditions for closing latches."));
        this.updateStateWithSensors();
        this.checkLatchesInitialized();
        if (this.latches.isInError()) {
            throw new RejectedCommandException(this.name + ": latches are in ERROR state - can't close latches.");
        }
        if (this.isEmpty()) {
            String message = this.name + ": no filter in autochanger - can't close latches.";
            throw new RejectedCommandException(message);
        }
        if (!this.autochangerTrucks.isAtStandby() && !this.autochangerTrucks.isAtHandoff()) {
            throw new RejectedCommandException(this.name + ": autochanger is not at handoff position neither at standby - can't close latches.");
        }
    }

    @Command(type=Command.CommandType.QUERY, description="log if actions on online clamps are allowed,throws an exception otherwise.")
    public void checkConditionsForActioningOnlineClamps() {
        if (!this.isAtOnline()) {
            throw new RejectedCommandException(this.name + " actions not allowed on ONLINE clamps when trucks are not at ONLINE.");
        }
        if (this.isEmpty()) {
            throw new RejectedCommandException(this.name + " actions not allowed on ONLINE clamps when no filter on trucks.");
        }
        FCSCst.FCSLOG.info((Object)(this.name + " autochangerTrucks are at ONLINE, a filter is there : actions are allowed."));
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if its safe for filters to move autochanger trucks.")
    public void checkFilterSafetyBeforeMotion() {
        String msg = this.name + " can't move autochanger trucks because ";
        this.updateStateWithSensors();
        if (this.isSensorsInError()) {
            this.handleSensorsError();
        } else if (this.isEmpty()) {
            FCSCst.FCSLOG.info((Object)(this.name + " trucks are empty - can move"));
        } else {
            if (!this.onlineClamps.isOpened()) {
                throw new RejectedCommandException(this.name + " : a filter is in trucks and ONLINE clamps are NOT OPENED.");
            }
            if (this.isAtStandby()) {
                this.checkFilterSafetyAtStandby(msg);
            } else if (this.autochangerTrucks.isAtHandoff()) {
                FCSCst.FCSLOG.info((Object)(this.name + " : trucks are AT HANDOFF "));
                this.checkFilterSafetyAtHandoff(msg);
            } else if (this.autochangerTrucks.isAtOnline()) {
                FCSCst.FCSLOG.info((Object)(this.name + " : trucks are at ONLINE "));
                this.checkFilterSafetyAtOnline(msg);
            } else if (!this.latches.isHoldingFilter()) {
                throw new RejectedCommandException(msg + " latches are not CLOSED");
            }
        }
    }

    private void checkFilterSafetyAtStandby(String message) {
        if (this.isHoldingFilter() && this.isCarouselHoldingFilterAtStandby()) {
            throw new RejectedCommandException(message + "both carousel and autochanger are holding filter at STANDBY");
        }
        if (!this.isHoldingFilter() && !this.isCarouselHoldingFilterAtStandby()) {
            throw new RejectedCommandException(message + "neither carousel nor autochanger are holding filter at STANDBY");
        }
        FCSCst.FCSLOG.info((Object)(this.name + " filter safe at STANDBY - can move"));
    }

    private void checkFilterSafetyAtHandoff(String message) {
        if (this.isHoldingFilter() && this.isCarouselHoldingFilterAtStandby()) {
            throw new RejectedCommandException(message + "autochanger is holding filter at HANDOFF but another filter is at STANDBY - can't move trucks");
        }
        if (this.isHoldingFilter() && this.isLoaderHoldingFilterAtHandoff()) {
            throw new RejectedCommandException(message + "both loader and autochanger are holding filter at HANDOFF");
        }
        if (!this.isHoldingFilter() && !this.isLoaderHoldingFilterAtHandoff()) {
            throw new RejectedCommandException(message + "neither loader nor autochanger are holding filter at HANDOFF");
        }
        FCSCst.FCSLOG.info((Object)(this.name + " filter safe at HANDOFF - can move"));
    }

    private void checkFilterSafetyAtOnline(String message) {
        if (this.isHoldingFilter() && this.isCarouselHoldingFilterAtStandby()) {
            throw new RejectedCommandException(message + "autochanger is holding filter at ONLINE but another filter is at STANDBY - can't move trucks");
        }
        if (this.isHoldingFilter() && !this.onlineClamps.isOpened()) {
            throw new RejectedCommandException(message + "onlineClamps have to be opened on filter at ONLINE - can't move trucks.");
        }
        if (!this.isHoldingFilter() && !this.onlineClamps.isLocked()) {
            throw new RejectedCommandException(message + "neither latches nor onlineClamps are holding filter at ONLINE");
        }
        FCSCst.FCSLOG.info((Object)(this.name + " filter safe at ONLINE - can move"));
    }

    private void handleSensorsError() {
        String msg = this.name + " error detected in sensors:";
        if (this.autochangerTrucks.isPositionSensorsInError()) {
            msg = msg + " trucks position sensors";
        }
        if (this.latches.isInError()) {
            msg = msg + " latches sensors";
        }
        if (this.onlineClamps.isInError()) {
            msg = msg + " onlineClamps sensors";
        }
        this.raiseAlarm(FcsEnumerations.FcsAlert.AC_SENSOR_ERROR, msg);
        throw new FcsHardwareException(msg);
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Return true if a filter is in trucks and latches are CLOSED.")
    public boolean isHoldingFilter() {
        return this.latches.isHoldingFilter();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Update clamp state in reading sensors.")
    public void updateStateWithSensors() {
        this.plutoGateway.checkInitialized();
        this.lock.lock();
        try {
            this.updatingState = true;
            this.plutoGateway.updateValues();
            this.updateState();
            this.updateFilterOnTrucksID();
        }
        finally {
            this.updatingState = false;
            this.stateUpdated.signalAll();
            this.lock.unlock();
            this.publishData();
            this.autochangerTrucks.publishData();
            this.latches.publishData();
            this.onlineClamps.publishData();
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="update filterOnTrucksID.")
    public void updateFilterOnTrucksID() {
        this.filterOnTrucksID = !this.latches.isEmpty() ? this.filterIdentificator.getFilterId() : 0;
    }

    private void updateState() {
        this.autochangerTrucks.updateState();
        this.latches.updateState();
        this.onlineClamps.updateState();
        this.filterIdentificator.updateFilterId();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Update FCS state and FCS readyness state and publishes on the status bus.")
    public void updateFCSStateToReady() {
        if (this.isCANDevicesReady() && this.latches.isInitialized() && this.autochangerTrucks.isInitialized() && this.onlineClamps.isInitialized()) {
            this.main.updateFCSStateToReady();
        }
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if autochanger trucks are at HANDOFF. This command doesn't read again the sensors.")
    public boolean isAtHandoff() {
        return this.autochangerTrucks.isAtHandoff();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if autochanger trucks are at STANDBY. This command doesn't read again the sensors.")
    public boolean isAtStandby() {
        return this.autochangerTrucks.isAtStandby();
    }

    @Command(type=Command.CommandType.QUERY, description="Return true if autochanger trucks are at ONLINE. This command doesn't read again the sensors.")
    public boolean isAtOnline() {
        return this.autochangerTrucks.isAtOnline();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if there is no filter in the autochanger. This command doesn't read again the sensors.")
    public boolean isEmpty() {
        return this.latches.isEmpty();
    }

    void grabFilterAtHandoff(Filter aFilter) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    void ungrabFilterAtHandoff(Filter aFilter) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    void moveFilterToHandoff(Filter aFilter) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Command(type=Command.CommandType.ACTION, level=1, alias="grabFilter", description="Go to STANDBY to grab filter and stay at STANDBY.")
    public void grabFilterAtStandby() {
        if (!this.isAtStandby()) {
            throw new RejectedCommandException(this.name + ": can't grab a filter when trucks are not at STANDBY.");
        }
        FCSCst.FCSLOG.info((Object)(this.name + ": grabbing a filter at standby position."));
        this.latches.close();
        this.filterOnTrucksID = this.identifyFilterAtStandby();
        FCSCst.FCSLOG.info((Object)(this.name + ": filter " + this.filterOnTrucksID + " is grabbed on autochanger"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, level=1, description="Ungrab filter at STANDBY")
    public void ungrabFilterAtStandby() {
        if (!this.isCarouselHoldingFilterAtStandby()) {
            throw new RejectedCommandException(this.name + ": can't ungrab a filter at STANDBY when carousel is not holding filter.");
        }
        FCSCst.FCSLOG.info((Object)(this.name + ": ungrabing filter at standby position."));
        this.latches.open();
        Autochanger autochanger = this;
        synchronized (autochanger) {
            this.filterManager.setFilterLocation(this.filterOnTrucksID, FcsEnumerations.FilterLocation.CAROUSEL);
            this.filterOnTrucksID = 0;
        }
    }

    @Command(type=Command.CommandType.QUERY, description="set a new value for the acquisition frequency of linear rail controllers current, in milliseconds.")
    public void setFastAcqFrequencyLinearRails(int rate) {
        this.configurationService.change("acTruckXminus-monitorCurrent", "taskPeriodMillis", (Object)rate);
        this.configurationService.change("acTruckXplus-monitorCurrent", "taskPeriodMillis", (Object)rate);
        this.configurationService.saveChangesForCategoriesAs(new String[]{"timers:fast"});
    }

    @Command(type=Command.CommandType.QUERY, description="set a new value for the acquisition frequency of ONLINE clamps controllers current, in milliseconds.")
    public void setFastAcqFrequencyOnlineClamps(int rate) {
        this.configurationService.change("onlineClampXminus-monitorCurrent", "taskPeriodMillis", (Object)rate);
        this.configurationService.change("onlineClampXplus-monitorCurrent", "taskPeriodMillis", (Object)rate);
        this.configurationService.change("onlineClampYminus-monitorCurrent", "taskPeriodMillis", (Object)rate);
        this.configurationService.saveChangesForCategoriesAs(new String[]{"timers:fast"});
    }

    @Command(type=Command.CommandType.QUERY)
    public void increaseCurrentMonitoring() {
        this.configurationService.loadCategories(new String[]{"timers:fast"});
    }

    @Command(type=Command.CommandType.QUERY)
    public void decreaseCurrentMonitoring() {
        this.configurationService.loadCategories(new String[]{"timers:slow"});
    }

    private int identifyFilterAtStandby() {
        return this.filterIdentificator.getFilterId();
    }

    public StatusDataPublishedByAutoChanger createStatusDataPublishedByAutoChanger() {
        StatusDataPublishedByAutoChanger status = new StatusDataPublishedByAutoChanger();
        status.setName(this.name);
        status.setLoaderConnectedSensorValue(this.loaderConnectedSensors.isOn());
        status.setLoaderConnectedSensorsInError(this.loaderConnectedSensors.isInError());
        status.setInclinaisonXminus(this.inclinometerXminus.getInclinaison());
        status.setInclinaisonXplus(this.inclinometerXplus.getInclinaison());
        return status;
    }

    public void publishData() {
        this.subs.publishSubsystemDataOnStatusBus(new KeyValueData("autochangerGeneral", (Serializable)this.createStatusDataPublishedByAutoChanger()));
    }
}

