/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.utils;

import org.lsst.ccs.drivers.canopenjni.PDOData;
import org.lsst.ccs.subsystems.fcs.FCSCst;

public class CWrapperUtils {
    private static final String[] CAN_OPEN_COMMANDS = new String[]{"sync", "scan", "rsdo", "wsdo", "info", "quit", "srtr", "reset"};
    private static final String SEP = "_";
    private static final String VAR_SUFFIXE = "v";

    private CWrapperUtils() {
    }

    public static String buildWsdoCommand(int nodeID, int index, int subindex, int size, long data) {
        char sep = ',';
        StringBuilder sb = new StringBuilder("wsdo").append(sep);
        sb.append(Integer.toHexString(nodeID)).append(sep);
        sb.append(Integer.toHexString(index)).append(sep);
        sb.append(Integer.toHexString(subindex)).append(sep);
        sb.append(Integer.toHexString(size)).append(sep);
        sb.append(Integer.toHexString((int)data));
        return sb.toString();
    }

    public static String buildRsdoCommand(int nodeID, int index, int subindex) {
        char sep = ',';
        StringBuilder sb = new StringBuilder("rsdo").append(sep);
        sb.append(Integer.toHexString(nodeID)).append(sep);
        sb.append(Integer.toHexString(index)).append(sep);
        sb.append(Integer.toHexString(subindex));
        return sb.toString();
    }

    public static boolean isValidCommandWord(String command) {
        for (String s : CAN_OPEN_COMMANDS) {
            if (!s.equals(command)) continue;
            return true;
        }
        return false;
    }

    public static void checkCommand(String command) {
        if (command == null) {
            throw new IllegalArgumentException(" null command");
        }
        String[] words = command.split(",");
        if (words.length == 0 || !CWrapperUtils.isValidCommandWord(words[0])) {
            throw new IllegalArgumentException(command + " invalid command");
        }
    }

    public static PDOData createPDOData(String pdoLine) {
        PDOData d = new PDOData();
        FCSCst.FCSLOG.finest((Object)(": pdoLine=" + pdoLine));
        String[] words = pdoLine.split(",");
        FCSCst.FCSLOG.finest((Object)(": words.length=" + words.length));
        for (int ix = 0; ix < words.length; ++ix) {
            FCSCst.FCSLOG.finest((Object)("ix=" + ix + "words[ix]=" + words[ix]));
            String[] toStore = words[ix].split("=");
            String[] varName = toStore[0].substring(VAR_SUFFIXE.length()).split(SEP);
            FCSCst.FCSLOG.finest((Object)("varName=" + varName));
            int nodeID = Integer.parseInt(varName[0], 16);
            int inputNB = Integer.parseInt(varName[1]);
            int varValue = Integer.parseInt(toStore[1], 16);
            FCSCst.FCSLOG.finest((Object)String.format("%nwords(%s):%s nodeID=%s", ix, words[ix], nodeID));
            d.updatePDO(nodeID + inputNB, (long)varValue);
        }
        return d;
    }
}

