/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDevice;
import org.lsst.ccs.subsystems.fcs.errors.HardwareNotDetectedException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;

public class CompactIO
extends CanOpenDevice {
    public int hexaValue = 0;
    private volatile boolean updatingValue = false;
    private final Lock lock = new ReentrantLock();
    private final Condition valueUpdated = this.lock.newCondition();

    public CompactIO(int nodeID, String serialNB) {
        super(nodeID, serialNB);
    }

    public int readNewHexaValue() {
        try {
            this.hexaValue = this.tcpProxy.readSDO(this.nodeID, 24576, 1);
        }
        catch (SDORequestException ex) {
            String mes = this.name + ": ERROR IN READING SENSOR:";
            this.raiseAlarm("FCS004:" + this.name, mes, (Exception)((Object)ex));
        }
        catch (ShortResponseToSDORequestException ex) {
            String mes = this.name + ": GOT A STRANGE RESPONSE IN READING SENSOR:";
            FCSCst.FCSLOG.warning((Object)(mes + (Object)((Object)ex)));
        }
        return this.hexaValue;
    }

    public int getHexaValue() {
        this.lock.lock();
        try {
            while (this.updatingValue) {
                try {
                    this.valueUpdated.await();
                }
                catch (InterruptedException ex) {
                    FCSCst.FCSLOG.error((Object)(this.name + ex.getMessage()));
                }
            }
            int n = this.hexaValue;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getValue() {
        FCSCst.FCSLOG.debug((Object)(this.name + this.hexaValue));
        return this.hexaValue;
    }

    public void updateValue() {
        this.lock.lock();
        try {
            this.updatingValue = true;
            this.hexaValue = this.readNewHexaValue();
            FCSCst.FCSLOG.debug((Object)(this.name + " HEXA VALUE READ=" + this.hexaValue));
        }
        finally {
            this.updatingValue = false;
            this.valueUpdated.signal();
            this.lock.unlock();
        }
    }

    public String writeDigitalOutput(int outputNB, int value) {
        if (!this.tcpProxy.allDevicesBooted()) {
            String message = String.format("DAC %s / nodeID=%s is NOT BOOTED", this.getName(), this.nodeID);
            FCSCst.FCSLOG.error((Object)message);
            throw new HardwareNotDetectedException("a CanOpenDIO is missing", this.getName(), this.nodeID, this.serialNB);
        }
        if (outputNB < 1 || outputNB > 8) {
            throw new IllegalArgumentException("CAN-CBX-DIO8 : input has to be 1..8");
        }
        return this.tcpProxy.writeSDO(this.nodeID, 25088, outputNB, 2, value);
    }

    public String writeMask() {
        return this.tcpProxy.writeSDO(this.nodeID, 8784, 1, 1, 3);
    }

    public boolean checkMask() {
        return this.tcpProxy.readSDO(this.nodeID, 24576, 1) == 3;
    }
}

