/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.net.Socket;
import org.lsst.ccs.AlertService;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.drivers.canopenjni.BootMessageListener;
import org.lsst.ccs.drivers.canopenjni.CanOpenInterface;
import org.lsst.ccs.drivers.canopenjni.EmergencyMessageListener;
import org.lsst.ccs.drivers.canopenjni.PDOData;
import org.lsst.ccs.drivers.canopenjni.SDOException;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenEventListener;
import org.lsst.ccs.subsystems.fcs.drivers.CommandDispenser;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.utils.CWrapperUtils;
import org.lsst.ccs.utilities.beanutils.WrappedException;
import org.lsst.ccs.utilities.logging.Logger;

public class FcsTcpProxy
implements CanOpenInterface {
    private static final Logger COMMAND_LOG = Logger.getLogger((String)"org.lsst.ccs.subsystems.fcs.drivers.FcsTcpProxy");
    @LookupName
    protected String name;
    @LookupField(strategy=LookupField.Strategy.TOP)
    protected Subsystem subs;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @ConfigurationParameter(isFinal=true, range="1024..99000", description="tcpip port number on which this tcpip server starts on.")
    private int portNumber;
    @ConfigurationParameter(description="Timeout in Millisecond. If a command sent to the CANbus doesn't respond during this amount of time, we considere that they could be an issue on the hardware.")
    private int fieldBusTimeout;
    private ServerSocket serverSock;
    private Thread readerThread;
    private volatile boolean stopped = true;
    private volatile boolean stopping = false;
    private volatile boolean tcpServerStarted = false;
    private ClientContext clientContext;
    private CommandDispenser commandDispenser;
    @ConfigurationParameter(isFinal=true)
    private String clientName;
    @LookupField(strategy=LookupField.Strategy.ANCESTORS)
    private CanOpenEventListener listener;

    public void addReceivedPDO(int cobId) throws DriverException {
    }

    public void setEmergencyMessageListener(EmergencyMessageListener eml) throws DriverException {
    }

    public void setBootMessageListener(BootMessageListener bml) throws DriverException {
    }

    public FcsTcpProxy(String clientName, int portNumber, int fieldBusTimeout) {
        this.portNumber = portNumber;
        this.fieldBusTimeout = fieldBusTimeout;
        this.clientName = clientName;
    }

    public AlertService getAlertService() {
        return this.alertService;
    }

    public void init() {
        this.stopped = false;
        this.stopping = false;
        this.tcpServerStarted = false;
        this.commandDispenser = new CommandDispenser();
    }

    public void start() {
        this.startServer();
        this.startThreadReader();
    }

    public void stop() {
        this.stopServer();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Starts the tcp server.")
    public void startServer() {
        try {
            this.serverSock = new ServerSocket(this.portNumber);
            FCSCst.FCSLOG.info((Object)(this.name + ":SERVER STARTED ON PORT:" + this.portNumber));
        }
        catch (IOException e) {
            FCSCst.FCSLOG.error((Object)(this.name + ":server not started"), (Throwable)e);
            throw new WrappedException((Throwable)e);
        }
        try {
            FCSCst.FCSLOG.info((Object)(this.name + ":WAITING FOR C-WRAPPER CLIENT..."));
            this.subs.updateAgentState(new Enum[]{FcsEnumerations.FilterState.WAITING_FOR_CWRAPPER, FcsEnumerations.FilterReadinessState.NOT_READY});
            FCSCst.FCSLOG.debug((Object)(this.name + ":DEBUGGING MODE"));
            Socket sock = this.serverSock.accept();
            FCSCst.FCSLOG.info((Object)(this.name + ":socket accept on " + this.portNumber));
            BufferedReader reader = new BufferedReader(new InputStreamReader(sock.getInputStream(), "ISO-8859-1"), 256);
            String nameAndProtocol = reader.readLine();
            if (nameAndProtocol == null) {
                FCSCst.FCSLOG.error((Object)(this.name + ": nameAndProtocol is null : CWrapper disconnected ?. Bye."));
                this.stopServer();
            } else {
                String[] words = nameAndProtocol.split(" ");
                String cname = words[0];
                this.clientContext = new ClientContext(cname, sock, reader, sock.getOutputStream());
                FCSCst.FCSLOG.info((Object)(this.name + ":REGISTERED : " + cname));
                this.tcpServerStarted = true;
                this.stopped = false;
            }
        }
        catch (IOException e) {
            FCSCst.FCSLOG.error((Object)(this.name + " unexpected "), (Throwable)e);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Starts to listen to the tcp client.")
    public void startThreadReader() {
        FCSCst.FCSLOG.info((Object)(this.name + "startThreadReader"));
        if (!this.tcpServerStarted) {
            String errorMsg = this.name + " tcp server has to be started before startThreadReader.";
            throw new FcsHardwareException(errorMsg);
        }
        Runnable readingFromTcpProxy = new Runnable(){

            @Override
            public void run() {
                while (!FcsTcpProxy.this.stopped) {
                    try {
                        String readline = FcsTcpProxy.this.clientContext.reader.readLine();
                        if (readline == null) {
                            if (FcsTcpProxy.this.stopping) {
                                FCSCst.FCSLOG.info((Object)(FcsTcpProxy.this.name + " : CWrapper is stopped."));
                                continue;
                            }
                            FCSCst.FCSLOG.error((Object)(FcsTcpProxy.this.name + " :nameAndProtocol is null : that should not happen."));
                            continue;
                        }
                        FcsTcpProxy.this.processCommand(readline);
                    }
                    catch (IOException ex) {
                        FCSCst.FCSLOG.error((Object)ex);
                        FCSCst.FCSLOG.error((Object)(FcsTcpProxy.this.name + ": Error in Thread reading from the tcp client."));
                    }
                }
            }
        };
        FCSCst.FCSLOG.info((Object)(this.name + ":STARTING Thread reader"));
        this.readerThread = new Thread(readingFromTcpProxy);
        this.readerThread.start();
    }

    protected void processCommand(String command) {
        COMMAND_LOG.finest((Object)(this.name + ":message read from socket=" + command));
        String[] words = command.split(",");
        String commandWord = words[0];
        if (command.startsWith("emcy")) {
            int nodeID = Integer.parseInt(words[1], 16);
            int deviceErrorCode = Integer.parseInt(words[2], 16);
            int errReg = Integer.parseInt(words[3], 16);
            COMMAND_LOG.warning((Object)(this.name + " received EMERGENCY message=" + command + " for nodeID=" + nodeID));
            this.listener.onEmergencyMessage(nodeID, deviceErrorCode, errReg);
        } else if (command.startsWith("Unknown")) {
            COMMAND_LOG.info((Object)(this.name + ": Unknown command received by CWrapper:" + command));
        } else if (command.startsWith("boot")) {
            int nodeID = Integer.parseInt(words[1], 16);
            FCSCst.FCSLOG.info((Object)(this.name + ":boot message received for nodeID (in hexa): " + Integer.toHexString(nodeID)));
            this.listener.onBootMessage(nodeID);
        } else if (command.startsWith("sync")) {
            this.processCommandResponse(command, "sync");
        } else {
            int nodeID = Integer.parseInt(words[1], 16);
            this.processCommandResponse(command, commandWord + Integer.toHexString(nodeID));
        }
    }

    private void processCommandResponse(String command, String token) {
        COMMAND_LOG.finest((Object)("Command token=" + token));
        if (this.commandDispenser.isTokenUsed(token)) {
            COMMAND_LOG.finest((Object)("Response to a registred command:" + command));
            try {
                this.commandDispenser.registerResponse(token, command);
            }
            catch (Exception ex) {
                FCSCst.FCSLOG.error((Object)ex);
                FCSCst.FCSLOG.error((Object)(this.name + ":Error in registering response to command :" + command), ex.getCause());
            }
        } else {
            FCSCst.FCSLOG.warning((Object)(this.name + ":Unsynchronous message read from CANbus=" + command));
        }
    }

    public void stopServer() {
        if (!this.tcpServerStarted) {
            FCSCst.FCSLOG.warning((Object)(this.name + " is stopped; nothing to stop."));
            return;
        }
        FCSCst.FCSLOG.info((Object)(this.name + ": ABOUT TO STOP TCP server....."));
        FCSCst.FCSLOG.finest((Object)("clientName=" + this.clientContext.clientName));
        this.stopping = true;
        try {
            this.call("quit");
        }
        catch (Exception ex) {
            throw new FcsHardwareException("cannot stop CWrapper", (Throwable)ex);
        }
        this.stopped = true;
        this.readerThread.interrupt();
        try {
            this.serverSock.close();
            this.tcpServerStarted = false;
            FCSCst.FCSLOG.info((Object)(this.name + " TCPIP SERVER STOPPED:"));
        }
        catch (IOException ex) {
            FCSCst.FCSLOG.error((Object)ex);
            FCSCst.FCSLOG.error((Object)(this.name + " : stop method does not work properly when closing socket"), (Throwable)ex);
        }
        try {
            this.clientContext.reader.close();
            this.clientContext.writer.close();
            this.clientContext.socket.close();
        }
        catch (IOException ex) {
            FCSCst.FCSLOG.error((Object)ex);
            FCSCst.FCSLOG.error((Object)(this.name + " : stop method does not work properly"), (Throwable)ex);
        }
    }

    public synchronized boolean isReady() {
        if (this.clientName == null) {
            throw new IllegalArgumentException("Client name can't be null.");
        }
        if (this.clientContext == null || this.clientContext.clientName == null) {
            return false;
        }
        if (this.stopped) {
            return false;
        }
        if (!this.tcpServerStarted) {
            return false;
        }
        FCSCst.FCSLOG.debug((Object)(this.name + "client name:= " + this.clientContext.clientName + "#"));
        return this.clientContext.clientName.equals(this.clientName);
    }

    public void init(int master, String baud, String busName, int nodeID) {
    }

    public PDOData sync() throws DriverException {
        String reply = (String)this.call("sync");
        PDOData pdoD = CWrapperUtils.createPDOData(reply);
        return pdoD;
    }

    public int scan() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String info(int nodeID) throws DriverException {
        return (String)this.call("info," + Integer.toHexString(nodeID));
    }

    public void wsdo(int nodeId, int index, int subindex, int size, long data) throws DriverException {
        String request = CWrapperUtils.buildWsdoCommand(nodeId, index, subindex, size, data);
        String sdoResponseLine = (String)this.call(request);
        String[] words = sdoResponseLine.split(",");
        int errorCode = Integer.parseInt(words[2], 16);
        if (0 != errorCode) {
            throw new SDOException(String.valueOf(errorCode), "request : " + request + " returned " + sdoResponseLine);
        }
    }

    public long rsdo(int nodeId, int index, int subindex) throws DriverException {
        String request = CWrapperUtils.buildRsdoCommand(nodeId, index, subindex);
        String sdoLine = (String)this.call(CWrapperUtils.buildRsdoCommand(nodeId, index, subindex));
        String[] words = sdoLine.split(",");
        int responseLength = words.length;
        int errorCode = Integer.parseInt(words[2], 16);
        if (errorCode == 0 && responseLength > 3) {
            return Long.parseLong(words[3], 16);
        }
        throw new SDOException(String.valueOf(errorCode), "request : " + request + " returned " + sdoLine);
    }

    public void ssta(int nodeId) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void ssto(int nodeId) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void reset(int nodeId) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void quit() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object call(String command) throws DriverException {
        if (this.clientContext == null) {
            throw new DriverException("CWrapper not connected. clientName : " + this.clientName + ", port : " + this.portNumber);
        }
        if (this.stopped) {
            throw new IllegalStateException(this.name + ":textTCP module stopped");
        }
        String sentCommand = command + "\r\u0000\n";
        COMMAND_LOG.finest((Object)(this.name + ":Sent command=" + command));
        this.clientContext.writer.write(sentCommand, 0, sentCommand.length());
        this.clientContext.writer.flush();
        if (!command.startsWith("rsdo") && !command.startsWith("wsdo") && !command.startsWith("info") && !command.startsWith("sync") && !command.startsWith("srtr")) return "asynchronous command sent:" + command;
        String commandToken = this.commandDispenser.register(command);
        try {
            String string = this.commandDispenser.getCommandResponse(commandToken, this.fieldBusTimeout);
            this.commandDispenser.remove(commandToken);
            return string;
        }
        catch (Throwable throwable) {
            try {
                this.commandDispenser.remove(commandToken);
                throw throwable;
            }
            catch (IOException ex) {
                FCSCst.FCSLOG.error((Object)(this.name + ":ERROR in tcpProxy call method"));
                FCSCst.FCSLOG.error((Object)ex);
                throw new WrappedException(this.name + ":ERROR in tcpProxy call method " + this.clientName, (Throwable)ex);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append("/port=");
        sb.append(this.portNumber);
        return sb.toString();
    }

    private static class ClientContext {
        private String clientName;
        private BufferedReader reader;
        private BufferedWriter writer;
        protected Socket socket;

        ClientContext(String name, Socket socket, BufferedReader reader, OutputStream os) {
            try {
                this.clientName = name;
                this.reader = reader;
                this.socket = socket;
                this.writer = new BufferedWriter(new OutputStreamWriter(os, "ISO-8859-1"), 256);
            }
            catch (UnsupportedEncodingException e) {
                FCSCst.FCSLOG.error((Object)(name + ":context not started"), (Throwable)e);
                throw new Error(e);
            }
        }
    }
}

