/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.io.Serializable;
import org.lsst.ccs.AlertService;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCanOpenDevice;
import org.lsst.ccs.subsystems.fcs.common.AlertRaiser;
import org.lsst.ccs.subsystems.fcs.common.EmergencyMessage;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenErrorsTable;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenCallTimeoutException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;

public class CanOpenDevice
implements PieceOfHardware,
AlertRaiser {
    @ConfigurationParameter(isFinal=true, description="CANOpen node ID of this CANOpen device")
    protected int nodeID;
    @ConfigurationParameter(description="serial number of this CANOpen device")
    protected String serialNB;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.ANCESTORS)
    protected CanOpenProxy tcpProxy;
    protected boolean initialized = false;
    protected boolean booted = false;
    protected boolean inError = false;
    protected int[] errorHistory = new int[0];
    protected String errorRegister = "NO ERROR";
    @LookupName
    protected String name;
    @LookupField(strategy=LookupField.Strategy.TOP)
    protected Subsystem s;

    public CanOpenDevice(int nodeID, String serialNB) {
        this.nodeID = nodeID;
        this.serialNB = serialNB;
    }

    @Override
    public AlertService getAlertService() {
        return this.alertService;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Subsystem getSubsystem() {
        return this.s;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns this CANopen device's serial number.")
    public String getSerialNB() {
        return this.serialNB;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns this CANopen device's node ID and print it in decimal format.")
    public int getNodeID() {
        return this.nodeID;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if this CANopen node is booted.")
    public boolean isBooted() {
        return this.booted;
    }

    @Override
    public void setBooted(boolean isBooted) {
        this.booted = isBooted;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if this CANopen node is initialized.")
    public boolean isInitialized() {
        return this.initialized;
    }

    public CanOpenProxy getTcpProxy() {
        return this.tcpProxy;
    }

    public int[] getErrorHistory() {
        return (int[])this.errorHistory.clone();
    }

    public String getErrorRegister() {
        return this.errorRegister;
    }

    public boolean isInError() {
        return this.inError;
    }

    @Override
    public void onEmergencyMessage(EmergencyMessage emcyMsg) {
        FCSCst.FCSLOG.debug((Object)(this.name + " received emergency message : " + emcyMsg));
        if (0 != emcyMsg.getErrorRegisterCode()) {
            FCSCst.FCSLOG.error((Object)(this.name + " emergency message received: " + emcyMsg.toString()));
            this.inError = true;
            try {
                this.errorRegister = emcyMsg.getErrorRegisterName();
                this.errorHistory = this.readErrorHistory();
                this.publishData();
            }
            catch (FcsHardwareException ex) {
                this.raiseWarning(FcsEnumerations.FcsAlert.CAN_BUS_TIMEOUT, "couldn't read EPOS error register because " + (Object)((Object)ex), this.getName());
            }
        }
    }

    public void resetError() {
        this.inError = false;
        this.errorRegister = "NO ERROR";
        this.errorHistory = new int[0];
        this.publishData();
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="Initialize the device.")
    public void initializeAndCheckHardware() {
        if (this.isBooted()) {
            this.initialized = true;
        }
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Write on the Can Open Device with a command wsdo. All the values are in hexadecimal format. To write new data value in decimal format, please use command writeSDO of tcpProxy.")
    public void writeSDO(int index, int subindex, int size, int newValue) {
        this.tcpProxy.writeSDO(this.nodeID, index, subindex, size, newValue);
    }

    @Command(type=Command.CommandType.QUERY, level=3, description="Reads the Can Open Device with a command rsdo.")
    public int readSDO(int index, int subindex) {
        return this.tcpProxy.readSDO(this.nodeID, index, subindex);
    }

    @Command(type=Command.CommandType.QUERY, level=3, description="Reads serial number on the Can Open Device with a command rsdo.")
    public String readStringSerialNumber() {
        int sn = this.readSDO(4120, 4);
        return Integer.toHexString(sn);
    }

    @Command(type=Command.CommandType.QUERY, level=3, description="Reads Error Register on the controller (index 1001).")
    public int readErrorRegister() {
        return this.readSDO(4097, 0);
    }

    @Command(type=Command.CommandType.QUERY, level=3, description="Display Error Register on the controller (index 1001).")
    public String displayErrorRegister() {
        int error = this.readErrorRegister();
        String errorName = CanOpenErrorsTable.getErrorRegisterNameByCode(error);
        FCSCst.FCSLOG.debug((Object)("error register=" + Integer.toHexString(error) + " error name=" + errorName));
        return errorName;
    }

    public int[] readErrorHistory() {
        int numberOfErrors = this.readNumberOfErrors();
        int[] errors = new int[numberOfErrors];
        for (int i = 0; i < numberOfErrors; ++i) {
            try {
                errors[i] = this.readSDO(4099, i + 1);
                continue;
            }
            catch (CanOpenCallTimeoutException ex) {
                String msg = " timeout expired while waiting to a response  to command: readErrorHistory - POWER FAILURE ? ";
                this.raiseWarning(this.name + ":" + FcsEnumerations.FcsAlert.CAN_BUS_TIMEOUT, FcsEnumerations.FcsAlert.CAN_BUS_TIMEOUT.getLongDescription(), msg + (Object)((Object)ex));
            }
        }
        return errors;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Display Error Register on the controller (index 1001).")
    public String displayErrorHistory() {
        this.errorHistory = this.readErrorHistory();
        StringBuilder sb = new StringBuilder("Error history contains " + this.errorHistory.length + " errors.");
        if (this.errorHistory.length != 0) {
            sb.append("\nList of errors in history,the newest is the first, the oldest the last :\n");
            for (int ix = 0; ix < this.errorHistory.length; ++ix) {
                sb.append("Error code (in hexa)=");
                sb.append(Integer.toHexString(this.errorHistory[ix]));
                sb.append("/ error name= ");
                sb.append(CanOpenErrorsTable.getDeviceErrorNameByCode(this.errorHistory[ix]));
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Read and returns the number of errors registred in the Error History.")
    public int readNumberOfErrors() {
        return this.readSDO(4099, 0);
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="This method saves the parameters in the controller memory.")
    public void saveParameters() {
        this.writeSDO(4112, 1, 4, 1702257011);
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Configure a CANopen device as a heartbeat producer.")
    public String configAsHeartbeatProducer(int nodeID, int heartbeatTime) {
        if (heartbeatTime < 0 || heartbeatTime > 65535) {
            throw new IllegalArgumentException("heartbeat time is coded on 2 bytes can't be > 65535");
        }
        return this.tcpProxy.writeSDO(nodeID, 4119, 0, 2, heartbeatTime);
    }

    public String configAsHeartbeatConsumer(int nodeID, int producerNodeID, int heartbeatTime) {
        if (nodeID < 0 || nodeID > 127) {
            throw new IllegalArgumentException("nodeID must be > 0 and <=127");
        }
        if (producerNodeID < 0 || producerNodeID > 127) {
            throw new IllegalArgumentException("producerNodeID must be > 0 and <=127");
        }
        if (heartbeatTime < 0 || heartbeatTime > 65535) {
            throw new IllegalArgumentException("heartbeat time is coded on 2 bytes can't be > 65535");
        }
        int value = producerNodeID + heartbeatTime;
        return this.tcpProxy.writeSDO(nodeID, 4118, 1, 4, value);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Print CANopen device.")
    public String toString() {
        StringBuilder sb = this.name == null ? new StringBuilder() : new StringBuilder(this.name);
        sb.append("/SerialNumber=");
        sb.append(this.serialNB);
        sb.append("/NodeID_in_hexa=");
        sb.append(Integer.toHexString(this.nodeID));
        sb.append("/NodeID_in_decimal=");
        sb.append(this.nodeID);
        sb.append("/");
        if (this.tcpProxy == null) {
            return sb.toString();
        }
        if (this.isBooted()) {
            sb.append("BOOTED/");
        } else {
            sb.append("NOT YET BOOTED/");
        }
        return sb.toString();
    }

    public StatusDataPublishedByCanOpenDevice createStatusDataPublishedByCanOpenDevice() {
        StatusDataPublishedByCanOpenDevice status = new StatusDataPublishedByCanOpenDevice(this.name, this.isBooted(), this.initialized);
        status.setInError(this.inError);
        status.setErrorRegister(this.errorRegister);
        status.setErrorHistory(this.errorHistory);
        return status;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, alias="refreshGUI", description="Publish data for the device on the status bus.")
    public void publishData() {
        KeyValueData kvd = new KeyValueData(this.name, (Serializable)this.createStatusDataPublishedByCanOpenDevice());
        this.s.publishSubsystemDataOnStatusBus(kvd);
    }
}

