/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.common;

import java.util.Map;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.errors.EPOSConfigurationException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public interface EPOSController
extends PieceOfHardware {
    public boolean isEnabledToPublish();

    public void setEnabledToPublish(boolean var1);

    public String readStatusWord();

    public void writeControlWord(int var1);

    @Command(type=Command.CommandType.ACTION, level=1, description="Shutdown the controller.")
    default public void disable() {
        this.writeControlWord(6);
        this.setEnabledToPublish(false);
        FCSCst.FCSLOG.debug((Object)(this.getName() + ": is DISABLED/SHUTDOWN."));
        this.publishData();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Switch on and enable controller.")
    default public void switchOnEnableOperation() {
        this.writeControlWord(15);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Stop action and disable(shutdown) controller.")
    default public void stopAction() {
        if (this.getMode() == EPOSEnumerations.EposMode.HOMING) {
            this.writeControlWord(287);
        } else if (this.getMode() == EPOSEnumerations.EposMode.CURRENT) {
            this.writeCurrent(0);
        } else if (this.getMode() == EPOSEnumerations.EposMode.PROFILE_POSITION) {
            this.stopPosition();
        } else if (this.getMode() == EPOSEnumerations.EposMode.PROFILE_VELOCITY) {
            this.stopVelocity();
        }
        this.disable();
        FCSCst.FCSLOG.info((Object)(this.getName() + " ACTION STOPPED"));
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="QuickStop.")
    default public void quickStop() {
        FCSCst.FCSLOG.debug((Object)(this.getName() + " running QUICKSTOP command."));
        if (this.getMode().equals((Object)EPOSEnumerations.EposMode.HOMING) || this.getMode().equals((Object)EPOSEnumerations.EposMode.PROFILE_POSITION) || this.getMode().equals((Object)EPOSEnumerations.EposMode.VELOCITY)) {
            this.writeControlWord(11);
        } else if (this.getMode().equals((Object)EPOSEnumerations.EposMode.CURRENT)) {
            this.writeControlWord(2);
        } else {
            throw new IllegalArgumentException(this.getName() + " has invalid Epos mode:" + this.getMode());
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="This methods enables the controller : i.e. this makes it able to receive commands.")
    default public void enable() {
        this.disable();
        this.switchOnEnableOperation();
        this.checkEnabled();
        this.setEnabledToPublish(true);
        FCSCst.FCSLOG.debug((Object)(this.getName() + ": is ENABLED."));
        this.publishData();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Check if controller is enabled otherwise, throw an Exception.")
    default public void checkEnabled() {
        long timeout = 500L;
        long timeStart = System.currentTimeMillis();
        long duration = 0L;
        boolean enabled = false;
        while (!enabled && duration <= timeout) {
            FCSCst.FCSLOG.info((Object)(this.getName() + " is not enabled yet. duration = " + duration));
            duration = System.currentTimeMillis() - timeStart;
            enabled = this.isEnabled();
        }
        if (!enabled) {
            String statusWord = this.readStatusWord();
            FCSCst.FCSLOG.info((Object)(this.getName() + " NOT ENABLED StatusWord=" + statusWord));
            throw new FcsHardwareException(this.getName() + " couldn't be enabled during time allocated of " + timeout + " ms");
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if the controller is enabled.")
    default public boolean isEnabled() {
        try {
            String statusWordInHexa = this.readStatusWord();
            int statusWord = Integer.parseInt(statusWordInHexa, 16);
            int[] statusWordInBinary = FcsUtils.toReverseBinary(statusWord);
            FCSCst.FCSLOG.debug((Object)(this.getName() + ":statusWord = " + statusWord));
            FCSCst.FCSLOG.debug((Object)(this.getName() + ":statusWordInBinary[0]=" + statusWordInBinary[0]));
            FCSCst.FCSLOG.debug((Object)(this.getName() + ":statusWordInBinary[1]=" + statusWordInBinary[1]));
            FCSCst.FCSLOG.debug((Object)(this.getName() + ":statusWordInBinary[2]=" + statusWordInBinary[2]));
            FCSCst.FCSLOG.debug((Object)(this.getName() + ":statusWordInBinary[3]=" + statusWordInBinary[3]));
            return statusWordInBinary[0] == 1 && statusWordInBinary[1] == 1 && statusWordInBinary[2] == 1 && statusWordInBinary[3] == 0;
        }
        catch (ShortResponseToSDORequestException ex) {
            String msg = this.getName() + " couldn't read status word because ShortResponseToSDORequestException :" + ex.getMessage();
            FCSCst.FCSLOG.error((Object)msg);
            FCSCst.FCSLOG.error((Object)ex);
            throw new FcsHardwareException(msg, (Throwable)ex);
        }
    }

    public void changeMode(EPOSEnumerations.EposMode var1);

    public EPOSEnumerations.EposMode readMode();

    public EPOSEnumerations.EposMode getMode();

    @Command(type=Command.CommandType.QUERY, description="return true if this controller is in the mode given as argument.")
    default public boolean isInMode(EPOSEnumerations.EposMode aMode) {
        return aMode.equals((Object)this.readMode());
    }

    public int readCurrent();

    public int readVelocity();

    @Command(type=Command.CommandType.ACTION, level=1, description="In current mode this methods send a current to the motor.")
    public void writeCurrent(int var1) throws EPOSConfigurationException;

    @Command(type=Command.CommandType.ACTION, level=3, description="Enables controller and sets the current value in the EPOS CPU.")
    default public void enableAndWriteCurrent(int aValue) {
        this.checkCurrent(aValue);
        this.enable();
        this.changeMode(EPOSEnumerations.EposMode.CURRENT);
        this.writeCurrent(aValue);
    }

    default public void checkCurrent(int aValue) {
        if (aValue > this.readParameter("ContinuousCurrentLimit")) {
            throw new IllegalArgumentException(aValue + " is greater than ContinuousCurrentLimit.");
        }
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Define the actual position as position given as argument.")
    default public void defineAbsolutePosition(int position) {
        FCSCst.FCSLOG.debug((Object)(this.getName() + " Defining Absolute Position:" + position));
        this.changeMode(EPOSEnumerations.EposMode.HOMING);
        this.writeParameter(EPOSEnumerations.Parameter.HomePosition, position);
        this.writeParameter(EPOSEnumerations.Parameter.HomingMethod, 35);
        this.enable();
        this.writeControlWord(31);
    }

    @Command(type=Command.CommandType.QUERY, level=1, alias="readPositionActualValue", description="In PROFILE_POSITION Mode this methods returns the actual position.")
    default public int readPosition() {
        int positionActualValue = this.readParameter(EPOSEnumerations.Parameter.PositionActualValue);
        FCSCst.FCSLOG.debug((Object)(this.getName() + ":readPosition=" + positionActualValue));
        return positionActualValue;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Read the position returned by the absolute encoder (single serial data).")
    default public int readSSIPosition() {
        return this.readParameter(EPOSEnumerations.Parameter.SSIEncoderActualPosition);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="In PROFILE_POSITION returns the value of the parameter ProfileVelocity.")
    default public int readProfileVelocity() {
        int profileVelocity = this.readParameter(EPOSEnumerations.Parameter.ProfileVelocity);
        FCSCst.FCSLOG.debug((Object)(this.getName() + ":readProfileVelocity=" + profileVelocity));
        return profileVelocity;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Read PositionSensorType.")
    default public int readPositionSensorType() {
        return this.readParameter(EPOSEnumerations.Parameter.PositionSensorType);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="In PROFILE_POSITION mode this methods set the target position.")
    public void writeTargetPosition(int var1);

    @Command(type=Command.CommandType.ACTION, level=1, description="In PROFILE_VELOCITY mode this methods set the target velocity.")
    public void writeTargetVelocity(int var1);

    public boolean isParametersOK();

    public int readParameter(EPOSEnumerations.Parameter var1);

    public void writeParameter(EPOSEnumerations.Parameter var1, int var2);

    public void checkParameters(EPOSEnumerations.EposMode var1);

    public void writeParameters(EPOSEnumerations.EposMode var1);

    @Command(type=Command.CommandType.ACTION, level=3, description="Write in the CPU of the EPOS device the values of the parameters set for the mode.")
    default public void writeParameters() {
        this.readMode();
        this.writeParameters(this.getMode());
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Reads in the EPOS CPU the decimal value of the Parameter which parameter name is given as argument.")
    default public int readParameter(String parameterName) {
        EPOSEnumerations.Parameter param = EPOSEnumerations.Parameter.valueOf((String)parameterName);
        return this.readParameter(param);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Read the parameters for the actual mode.")
    default public String readParameters() {
        return this.readParameters(this.readMode().toString());
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="This methods reads in the CPU of the EPOS the values of the parameters for a given mode.")
    default public String readParameters(String modeInString) {
        return this.readParameters(EPOSEnumerations.EposMode.valueOf((String)modeInString));
    }

    default public String readParameters(EPOSEnumerations.EposMode aMode) {
        EPOSEnumerations.Parameter[] params;
        String modeIS = aMode.toString();
        StringBuilder sb = new StringBuilder(this.getName() + " parameters VALUES in decimal format for mode ");
        sb.append(modeIS);
        sb.append("\n");
        for (EPOSEnumerations.Parameter param : params = aMode.getParameters()) {
            sb.append(param.toString());
            sb.append("=");
            int valueInt = this.readParameter(param);
            sb.append(valueInt);
            sb.append("\n");
        }
        FCSCst.FCSLOG.debug((Object)(this.getName() + sb.toString()));
        return sb.toString();
    }

    default public void writeParameters(Map<String, Integer> paramMap) {
        for (Map.Entry<String, Integer> entry : paramMap.entrySet()) {
            String paramName = entry.getKey();
            int value = entry.getValue();
            this.writeParameter(EPOSEnumerations.Parameter.valueOf((String)paramName), value);
        }
    }

    public boolean isInError();

    public String getErrorRegister();

    public int[] getErrorHistory();

    public int readNumberOfErrors();

    public String displayErrorHistory();

    public void checkFault();

    @Command(type=Command.CommandType.QUERY, level=1, description="In HOMING mode and PROFILE_POSITION mode this indicates that the position is reached.")
    default public boolean isTargetReached() {
        String statusWordInHexa = this.readStatusWord();
        int statusWord = Integer.parseInt(statusWordInHexa, 16);
        int[] statusWordInBinary = FcsUtils.toReverseBinary(statusWord);
        return statusWordInBinary[10] == 1;
    }

    default public void checkTargetReached(long timeout) {
        long timeStart = System.currentTimeMillis();
        long duration = 0L;
        while (!this.isTargetReached() && duration <= timeout) {
            FCSCst.FCSLOG.info((Object)(this.getName() + " target is not yet reached."));
            duration = System.currentTimeMillis() - timeStart;
        }
        if (!this.isTargetReached()) {
            String msg = this.getName() + " couldn't reach target during time allocated of " + timeout + " ms";
            FCSCst.FCSLOG.info((Object)msg);
            throw new FcsHardwareException(msg);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Enable controller and go to absolute position. Doesn't check condition. DANGER !!!! ")
    default public void enableAndWriteAbsolutePosition(int pos) {
        this.enable();
        this.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
        this.writeTargetPosition(pos);
        this.writeControlWord(63);
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Enable controller and go to relative position. Doesn't check condition. DANGER !!!! ")
    default public void enableAndWriteRelativePosition(int pos) {
        this.enable();
        this.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
        this.writeTargetPosition(pos);
        this.writeControlWord(127);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Change to PROFILE_VELOCITY mode, and move with velocity given as argument. To stop motion command is stopVelocity.")
    default public void startVelocity(int velocity) {
        this.changeMode(EPOSEnumerations.EposMode.PROFILE_VELOCITY);
        this.enable();
        this.writeTargetVelocity(velocity);
        this.switchOnEnableOperation();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Stop motion when in mode PROFILE_POSITION.")
    default public void stopPosition() {
        if (!this.isInMode(EPOSEnumerations.EposMode.PROFILE_POSITION)) {
            throw new RejectedCommandException(this.getName() + " is not in PROFILE_POSITION mode.");
        }
        this.writeControlWord(271);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Stop motion when in mode PROFILE_VELOCITY.")
    default public void stopVelocity() {
        if (!this.isInMode(EPOSEnumerations.EposMode.PROFILE_VELOCITY)) {
            throw new RejectedCommandException(this.getName() + " is not in PROFILE_VELOCITY mode.");
        }
        this.writeControlWord(263);
    }

    default public StatusDataPublishedByEPOSController createStatusDataPublishedByEPOSController() {
        StatusDataPublishedByEPOSController status = new StatusDataPublishedByEPOSController(this.getName(), this.isBooted(), this.isInitialized());
        status.setInError(this.isInError());
        status.setErrorRegister(this.getErrorRegister());
        status.setErrorHistory(this.getErrorHistory());
        status.setEnabled(this.isEnabledToPublish());
        status.setMode(this.getMode());
        return status;
    }
}

