/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.subsystems.fcs.DigitalSensor;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderHook;

public class LoaderHook {
    @LookupName
    private String name;
    private final DigitalSensor closeSensor;
    private final DigitalSensor openSensor;
    private FcsEnumerations.LockStatus lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
    protected final Lock lock = new ReentrantLock();
    private final Condition stateUpdated = this.lock.newCondition();
    private boolean closed;
    private boolean opened;
    private boolean inError;
    protected volatile boolean updatingState = false;

    public LoaderHook(DigitalSensor closeSensor, DigitalSensor openSensor) {
        this.closeSensor = closeSensor;
        this.openSensor = openSensor;
    }

    public FcsEnumerations.LockStatus getLockStatus() {
        this.lock.lock();
        try {
            while (this.updatingState) {
                try {
                    this.stateUpdated.await();
                }
                catch (InterruptedException ex) {
                    FCSCst.FCSLOG.error((Object)(this.name + ": getLockStatus was interrupted while waiting for update."));
                }
            }
            FcsEnumerations.LockStatus lockStatus = this.lockStatus;
            return lockStatus;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Update state in reading sensors.")
    public void updateStateWithSensors(int[] hexaValues) {
        this.lock.lock();
        try {
            this.updatingState = true;
            this.closeSensor.updateValue(hexaValues);
            this.openSensor.updateValue(hexaValues);
            this.closed = this.closeSensor.isOn();
            this.opened = this.openSensor.isOn();
            boolean bl = this.inError = this.closed && this.opened;
            this.lockStatus = this.inError ? FcsEnumerations.LockStatus.ERROR : (this.closed ? FcsEnumerations.LockStatus.CLOSED : (this.opened ? FcsEnumerations.LockStatus.OPENED : FcsEnumerations.LockStatus.INTRAVEL));
        }
        finally {
            this.updatingState = false;
            this.stateUpdated.signal();
            this.lock.unlock();
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="display sensors info")
    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append("#closeSensor=");
        sb.append(this.closeSensor.toString());
        sb.append("#openSensor=");
        sb.append(this.openSensor.toString());
        return sb.toString();
    }

    StatusDataPublishedByLoaderHook createStatusDataPublishedByLoaderHook() {
        return new StatusDataPublishedByLoaderHook(this.name, this.closeSensor.isOn(), this.openSensor.isOn(), this.inError, this.lockStatus);
    }
}

