/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.util.concurrent.locks.Condition;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.subsystems.fcs.DigitalSensor;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.ForceSensor;
import org.lsst.ccs.subsystems.fcs.Loader;
import org.lsst.ccs.subsystems.fcs.LoaderHook;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderClamp;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.ControlledBySensors;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.MobileItem;
import org.lsst.ccs.subsystems.fcs.common.MovedByEPOSController;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenCallTimeoutException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;

public class LoaderClamp
extends MobileItem
implements MovedByEPOSController,
ControlledBySensors {
    private final LoaderHook hook1;
    private final LoaderHook hook2;
    private final LoaderHook hook3;
    private final LoaderHook hook4;
    private final ForceSensor forceSensor0;
    private final ForceSensor forceSensor1;
    private final DigitalSensor clampedStatusSensor;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private LoaderHook[] hooks;
    @LookupField(strategy=LookupField.Strategy.BYNAME)
    private EPOSController hooksController;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private Loader loader;
    @LookupField(strategy=LookupField.Strategy.BYNAME)
    private BridgeToHardware loaderTcpProxy;
    private FcsEnumerations.LockStatus lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
    private FcsEnumerations.LockStatus forceStatus;
    @ConfigurationParameter(description="timeout in milliseconds : if closing the clamp last more than this amount of time, then the subsystem goes in ERROR.")
    private int timeoutForClosingHooks = 60000;
    @ConfigurationParameter(description="timeout in milliseconds : if closing strongly the clamp last more than this amount of time, then the subsystem goes in ERROR.")
    private int timeoutForClampingHooks = 60000;
    @ConfigurationParameter(description="timeout in milliseconds : if opening the clamp last more than this amount of time, then the subsystem goes in ERROR.")
    private int timeoutForOpeningHooks = 60000;
    private static final int TIMEOUT_FOR_MOVING_CLAMP = 60000;
    @ConfigurationParameter(description="target encoder absolute value in qc to open")
    private int targetPositionToOpen = 0;
    @ConfigurationParameter(description="target encoder absolute value in qc when hooks are CLOSED")
    private int absolutePositionToClose = 435000;
    @ConfigurationParameter(description="target encoder absolute value in qc when hooks are CLAMPED, used only by simulation since May 2017")
    private int targetPositionToClamp = 468000;
    @ConfigurationParameter(description="relative position in qc to unclamp when hooks are CLAMPED")
    private int relativePositionToUnclamp = -33000;
    @ConfigurationParameter(description="current to clamp hooks, in mA")
    private int currentToClamp = 450;
    @ConfigurationParameter(description="current to open hooks, in mA")
    private int currentToOpen = -150;
    private int positionToReach = 0;
    private volatile boolean homingDone = false;
    private final Condition stateUpdated = this.lock.newCondition();
    protected volatile boolean updatingState = false;
    private int position;
    private int readCurrent;

    public LoaderClamp(LoaderHook hook1, LoaderHook hook2, LoaderHook hook3, LoaderHook hook4, ForceSensor forceSensor0, ForceSensor forceSensor1, DigitalSensor clampedStatusSensor) {
        this.hook1 = hook1;
        this.hook2 = hook2;
        this.hook3 = hook3;
        this.hook4 = hook4;
        this.hooks = new LoaderHook[]{hook1, hook2, hook3, hook4};
        this.forceSensor0 = forceSensor0;
        this.forceSensor1 = forceSensor1;
        this.clampedStatusSensor = clampedStatusSensor;
    }

    @Override
    public String getControllerName() {
        return this.hooksController.getName();
    }

    public int getTargetPositionToOpen() {
        return this.targetPositionToOpen;
    }

    public int getRelativePositionToClose() {
        return this.absolutePositionToClose;
    }

    public int getRelativePositionToUnclamp() {
        return this.relativePositionToUnclamp;
    }

    public int getTargetPositionToClamp() {
        return this.targetPositionToClamp;
    }

    public int getCurrentToClamp() {
        return this.currentToClamp;
    }

    public int getCurrentToOpen() {
        return this.currentToOpen;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Display position for end user.Do not read again controller.")
    public int getPosition() {
        return this.position;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if homing of loader clamp has been done.")
    public boolean isHomingDone() {
        return this.homingDone;
    }

    public FcsEnumerations.LockStatus getLockStatus() {
        this.lock.lock();
        try {
            while (this.updatingState) {
                try {
                    this.stateUpdated.await();
                }
                catch (InterruptedException ex) {
                    FCSLOG.warning((Object)(this.name + ": interrupted in getLockStatus."), (Throwable)ex);
                }
            }
            FcsEnumerations.LockStatus lockStatus = this.lockStatus;
            return lockStatus;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LockStatus=CLOSED")
    public boolean isClosed() {
        return this.getLockStatus() == FcsEnumerations.LockStatus.CLOSED;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LockStatus=OPENED")
    public boolean isOpened() {
        return this.getLockStatus() == FcsEnumerations.LockStatus.OPENED;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LockStatus=CLAMPED")
    public boolean isClamped() {
        return this.getLockStatus() == FcsEnumerations.LockStatus.CLAMPED;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LockStatus=ERROR or UNKNOWN.")
    public boolean isInError() {
        return this.getLockStatus() == FcsEnumerations.LockStatus.ERROR;
    }

    public boolean isUnderLoad() {
        return this.getLockStatus() == FcsEnumerations.LockStatus.UNDER_LOAD;
    }

    @Override
    public boolean myDevicesReady() {
        return this.loaderTcpProxy.allDevicesBooted();
    }

    public void postStart() {
        if (this.hooksController.isBooted()) {
            this.initializeController();
        }
    }

    public void initializeController() {
        try {
            this.hooksController.initializeAndCheckHardware();
        }
        catch (ShortResponseToSDORequestException ex) {
            FCSLOG.warning((Object)(this.name + ":" + (Object)((Object)ex)));
        }
        catch (FcsHardwareException ex) {
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, " could not initialize loader clamp controller", (Exception)((Object)ex));
        }
    }

    public void checkInitialized() {
        if (!this.hooksController.isInitialized()) {
            String msg = this.getName() + ": clamp is not intialized.";
            FCSLOG.error((Object)msg);
            throw new RejectedCommandException(msg);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Open clamp.")
    public void open() {
        this.loader.updateStateAndCheckSensors();
        this.loader.checkConditionsForOpeningHooks();
        this.executeAction(FcsEnumerations.MobileItemAction.OPENLOADERHOOKS, this.timeoutForOpeningHooks);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Closes clamp.", timeout=60000)
    public void close() {
        this.loader.updateStateAndCheckSensors();
        this.loader.checkLoaderNotEmpty();
        if (!this.isHomingDone()) {
            throw new RejectedCommandException(this.getName() + " can't be CLOSED because homing is not done.");
        }
        if (this.isOpened() || this.lockStatus == FcsEnumerations.LockStatus.INTRAVEL || this.getLockStatus() == FcsEnumerations.LockStatus.UNKNOWN) {
            this.positionToReach = this.absolutePositionToClose;
            this.executeAction(FcsEnumerations.MobileItemAction.CLOSELOADERHOOKS, this.timeoutForClosingHooks);
        } else if (this.isClosed()) {
            FCSLOG.info((Object)(this.getName() + " is already CLOSED. Nothing to do."));
        } else {
            throw new RejectedCommandException(this.getName() + " has to be OPENED before a close action.");
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Clamp to hold tightly a filter.")
    public void clamp() {
        this.loader.updateStateAndCheckSensors();
        if (this.isClosed()) {
            this.loader.checkLoaderNotEmpty();
            this.checkConditionsForClampingHooks();
            this.executeAction(FcsEnumerations.MobileItemAction.CLAMPLOADERHOOKS, this.timeoutForClampingHooks);
        } else if (this.isClamped()) {
            FCSLOG.info((Object)(this.getName() + " is already CLAMPED. Nothing to do."));
        } else {
            throw new RejectedCommandException(this.getName() + " has to be CLOSED before a clamp action.");
        }
    }

    private void checkConditionsForClampingHooks() {
        if (this.loader.isAutochangerHoldingFilter()) {
            throw new RejectedCommandException(this.getName() + " Autochanger is holding filter. Open autochanger latches before clamping loader hooks.");
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Unclamp filter and return to CLOSED position.")
    public void unclamp() {
        this.loader.updateStateAndCheckSensors();
        if (this.isClamped() || this.isUnderLoad()) {
            this.loader.checkLoaderNotEmpty();
            this.loader.checkConditionsForUnclampingHooks();
            FCSLOG.info((Object)("position=" + this.position));
            FCSLOG.info((Object)("relativePositionToUnclamp=" + this.relativePositionToUnclamp));
            this.positionToReach = this.position + this.relativePositionToUnclamp;
            FCSLOG.info((Object)("positionToReach=" + this.positionToReach));
            this.executeAction(FcsEnumerations.MobileItemAction.UNCLAMPLOADERHOOKS, this.timeoutForClampingHooks);
        } else if (this.isClosed()) {
            FCSLOG.info((Object)(this.getName() + " is already CLOSED. Nothing to do."));
        } else {
            throw new RejectedCommandException(this.getName() + " has to be CLAMPED before an unclamp action.");
        }
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        boolean actionCompleted = false;
        if (action == FcsEnumerations.MobileItemAction.OPENLOADERHOOKS) {
            actionCompleted = this.isCurrentReached(this.currentToOpen) && this.isOpened();
        } else if (action == FcsEnumerations.MobileItemAction.CLOSELOADERHOOKS) {
            actionCompleted = this.isPositionReached(this.positionToReach) && this.isClosed() && this.hooksController.isTargetReached();
        } else if (action == FcsEnumerations.MobileItemAction.CLAMPLOADERHOOKS) {
            actionCompleted = this.readCurrent == this.currentToClamp && this.clampedStatusSensor.isOn();
        } else if (action == FcsEnumerations.MobileItemAction.UNCLAMPLOADERHOOKS) {
            actionCompleted = this.isPositionReached(this.positionToReach) && !this.clampedStatusSensor.isOn() && this.hooksController.isTargetReached();
        }
        return actionCompleted;
    }

    private boolean isCurrentReached(int currentToReach) {
        int DELTA = 5;
        FCSLOG.debug((Object)("readCurrent=" + this.readCurrent + " currentToReached=" + currentToReach));
        return currentToReach - DELTA <= this.readCurrent && this.readCurrent <= currentToReach + DELTA;
    }

    private boolean isPositionReached(int positionToReach) {
        int DELTA = 10;
        FCSLOG.debug((Object)("position=" + this.position + " positionToReached=" + positionToReach));
        return positionToReach - DELTA <= this.position && this.position <= positionToReach + DELTA;
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() {
        try {
            this.hooksController.checkFault();
            this.loader.updateStateWithSensors();
            if (this.currentAction == FcsEnumerations.MobileItemAction.CLOSELOADERHOOKS || this.currentAction == FcsEnumerations.MobileItemAction.UNCLAMPLOADERHOOKS) {
                this.position = this.hooksController.readPosition();
            } else if (this.currentAction == FcsEnumerations.MobileItemAction.OPENLOADERHOOKS || this.currentAction == FcsEnumerations.MobileItemAction.CLAMPLOADERHOOKS) {
                this.readCurrent = this.hooksController.readCurrent();
                this.position = this.hooksController.readPosition();
            }
        }
        catch (CanOpenCallTimeoutException ex) {
            this.raiseWarning(FcsEnumerations.FcsAlert.CAN_BUS_TIMEOUT, " error in updateStateWithSensorsToCheckIfActionIsCompleted:" + (Object)((Object)ex), this.getName());
        }
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) {
        if (action == FcsEnumerations.MobileItemAction.OPENLOADERHOOKS) {
            this.hooksController.enableAndWriteCurrent((short)this.currentToOpen);
        } else if (action == FcsEnumerations.MobileItemAction.CLOSELOADERHOOKS) {
            this.hooksController.enableAndWriteAbsolutePosition(this.absolutePositionToClose);
        } else if (action == FcsEnumerations.MobileItemAction.CLAMPLOADERHOOKS) {
            this.hooksController.enableAndWriteCurrent((short)this.currentToClamp);
        } else if (action == FcsEnumerations.MobileItemAction.UNCLAMPLOADERHOOKS) {
            this.hooksController.enableAndWriteRelativePosition(this.relativePositionToUnclamp);
        }
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) {
        FCSLOG.debug((Object)(this.name + " is ABORTING action " + action.toString() + " within delay " + delay));
        this.hooksController.stopAction();
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) {
        FCSLOG.debug((Object)(this.name + " is STOPPING action " + action.toString() + " within delay " + delay));
        this.hooksController.stopAction();
    }

    @Override
    public void postAction(FcsEnumerations.MobileItemAction action) {
        this.hooksController.stopAction();
        FCSLOG.info((Object)(this.name + ":" + action.toString() + " completed - doing postAction."));
        if (action == FcsEnumerations.MobileItemAction.OPENLOADERHOOKS) {
            this.homing();
        } else if (action == FcsEnumerations.MobileItemAction.CLAMPLOADERHOOKS && this.forceStatus == FcsEnumerations.LockStatus.OVER_LOAD) {
            String msg = " force sensor value is higher than max force limit " + this.forceSensor0.getMaxRangeValue();
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, msg);
            throw new FcsHardwareException(this.name + msg);
        }
        this.loader.updateFCSStateToReady();
        this.publishData();
    }

    private void homing() {
        this.hooksController.defineAbsolutePosition(0);
        this.updatePosition();
        this.homingDone = true;
        this.publishData();
        this.loader.updateFCSStateToReady();
    }

    public void updateStateAndCheckSensors() {
        this.loader.updateStateWithSensors();
        this.checkSensors(FcsEnumerations.FcsAlert.LO_SENSOR_ERROR, this.name);
    }

    void updateStateWithSensors(int[] readHexaValues) {
        this.lock.lock();
        try {
            this.updatingState = true;
            this.updateHooksSensorsValue(readHexaValues);
            this.updateForceStatus(readHexaValues);
            this.clampedStatusSensor.updateValue(readHexaValues);
            if (this.oneHookInError()) {
                this.lockStatus = FcsEnumerations.LockStatus.ERROR;
            } else if (this.allHooksInState(FcsEnumerations.LockStatus.OPENED)) {
                this.computeStatusHooksOpened();
            } else if (this.allHooksInState(FcsEnumerations.LockStatus.CLOSED)) {
                this.computeStatusHooksClosed();
            } else {
                this.lockStatus = this.allHooksInState(FcsEnumerations.LockStatus.INTRAVEL) ? FcsEnumerations.LockStatus.INTRAVEL : FcsEnumerations.LockStatus.UNKNOWN;
            }
        }
        finally {
            this.updatingState = false;
            this.stateUpdated.signal();
            this.lock.unlock();
            this.publishData();
        }
    }

    private void updateHooksSensorsValue(int[] hexaValues) {
        for (LoaderHook hook : this.hooks) {
            hook.updateStateWithSensors(hexaValues);
        }
    }

    private boolean oneHookInError() {
        boolean bool = false;
        for (LoaderHook hook : this.hooks) {
            bool = bool || hook.getLockStatus() == FcsEnumerations.LockStatus.ERROR;
        }
        return bool;
    }

    private boolean allHooksInState(FcsEnumerations.LockStatus status) {
        boolean bool = true;
        for (LoaderHook hook : this.hooks) {
            bool = bool && hook.getLockStatus() == status;
        }
        return bool;
    }

    private void updateForceStatus(int[] readHexaValues) {
        this.forceSensor0.updateForce(readHexaValues);
        this.forceSensor1.updateForce(readHexaValues);
        this.forceStatus = Math.abs(this.forceSensor0.getForce() - this.forceSensor1.getForce()) < 120.0 ? this.forceSensor0.getForceStatus() : FcsEnumerations.LockStatus.ERROR;
    }

    private void computeStatusHooksClosed() {
        this.lockStatus = this.clampedStatusSensor.isOn() ? FcsEnumerations.LockStatus.CLAMPED : FcsEnumerations.LockStatus.CLOSED;
    }

    private void computeStatusHooksOpened() {
        this.lockStatus = this.forceStatus == FcsEnumerations.LockStatus.UNCLAMPED ? FcsEnumerations.LockStatus.OPENED : (this.forceStatus == FcsEnumerations.LockStatus.CLAMPED ? FcsEnumerations.LockStatus.ERROR : this.forceStatus);
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Update clamp current in reading controller.")
    public void updateCurrent() {
        try {
            this.readCurrent = this.hooksController.readCurrent();
        }
        catch (ShortResponseToSDORequestException ex) {
            FCSLOG.warning((Object)(this.name + "=> ERROR IN READING CONTROLLER:"), (Throwable)ex);
        }
        this.publishData();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update clamp position in reading controller.")
    public void updatePosition() {
        try {
            this.position = this.hooksController.readPosition();
        }
        catch (ShortResponseToSDORequestException ex) {
            FCSLOG.warning((Object)(this.name + "=> ERROR IN READING CONTROLLER:"), (Throwable)ex);
        }
        this.publishData();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="To update and display position for end user.Updates loader clamp position in reading controller and returns it.")
    public int readPosition() {
        this.updatePosition();
        return this.position;
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Return a printed list of hardware with initialization information.")
    public String printHardwareState() {
        StringBuilder sb = new StringBuilder(this.name);
        if (this.homingDone) {
            sb.append(" is INITIALIZED.");
        } else {
            sb.append(" is NOT INITIALIZED.");
        }
        return sb.toString();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="List and display clamp info.")
    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append("/timeoutForClosingHooks=");
        sb.append(this.timeoutForClosingHooks);
        sb.append("/timeoutForClosingHooksStrongly=");
        sb.append(this.timeoutForClampingHooks);
        sb.append("/timeoutForOpeningHooks=");
        sb.append(this.timeoutForOpeningHooks);
        return sb.toString();
    }

    public StatusDataPublishedByLoaderClamp createStatusDataPublishedByLoaderClamp() {
        StatusDataPublishedByLoaderClamp status = new StatusDataPublishedByLoaderClamp();
        status.setName(this.name);
        status.setPosition(this.position);
        status.setCurrent(this.readCurrent);
        status.setClampState(this.lockStatus);
        status.setForce0(this.forceSensor0.getForce());
        status.setForce1(this.forceSensor1.getForce());
        status.setForceStatusOn(this.clampedStatusSensor.isOn());
        status.setForceStatus(this.forceStatus);
        status.setHomingDone(this.homingDone);
        status.setStatusPublishedByHook1(this.hook1.createStatusDataPublishedByLoaderHook());
        status.setStatusPublishedByHook2(this.hook2.createStatusDataPublishedByLoaderHook());
        status.setStatusPublishedByHook3(this.hook3.createStatusDataPublishedByLoaderHook());
        status.setStatusPublishedByHook4(this.hook4.createStatusDataPublishedByLoaderHook());
        return status;
    }

    @Override
    public void publishData() {
        KeyValueData kvd = new KeyValueData("loaderClamp", (Serializable)this.createStatusDataPublishedByLoaderClamp());
        this.s.publishSubsystemDataOnStatusBus(kvd);
    }
}

