/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;

public class ForceSensor {
    @LookupName
    private String name;
    @ConfigurationParameter
    public double transfert_coeff = 0.4932;
    @ConfigurationParameter
    public double transfert_Constante = 467.99;
    private int voltage;
    private double force;
    @ConfigurationParameter
    private final int byteNumero;
    @ConfigurationParameter(description="Min value for range where hooks are clamped: over this value and below maxRangeValue, hooks are clamped.  Unit = N")
    private int minRangeValue = 778;
    @ConfigurationParameter(description="Max value for range where hooks are clamped:below this value and over minRangeValue, hooks are clamped.  Unit = N")
    private int maxRangeValue = 920;
    @ConfigurationParameter(description="Below this limit, there is no load on the clamp  so clamp is really unclamped.Over this limit and below minRangeValue, clamp is UNDER_LOAD, neither clamped, neither unclamped.  Unit = N")
    private int underLoadLimit = 30;
    private FcsEnumerations.LockStatus forceStatus;

    public ForceSensor(int byteNumero) {
        this.byteNumero = byteNumero;
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Returns force sensor analog Value. Unit= mV")
    public int getVoltage() {
        return this.voltage;
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Returns force sensor value in Newton. Unit = N")
    public double getForce() {
        return this.force;
    }

    public FcsEnumerations.LockStatus getForceStatus() {
        return this.forceStatus;
    }

    public int getByteNumero() {
        return this.byteNumero;
    }

    public double getTransfert_coeff() {
        return this.transfert_coeff;
    }

    public double getTransfert_Constante() {
        return this.transfert_Constante;
    }

    public int getMaxRangeValue() {
        return this.maxRangeValue;
    }

    public void updateForce(int[] hexaValues) {
        FCSCst.FCSLOG.finest((Object)(this.name + " updating voltage and force value from byte " + this.byteNumero));
        this.voltage = 100 * hexaValues[this.byteNumero];
        this.force = this.transfertFunction(this.voltage);
        this.computeForceStatus();
    }

    private void computeForceStatus() {
        this.forceStatus = this.force < (double)this.underLoadLimit ? FcsEnumerations.LockStatus.UNCLAMPED : (this.force < (double)this.minRangeValue ? FcsEnumerations.LockStatus.UNDER_LOAD : (this.force < (double)this.maxRangeValue ? FcsEnumerations.LockStatus.CLAMPED : FcsEnumerations.LockStatus.OVER_LOAD));
    }

    public double transfertFunction(int tension) {
        double transfertValue = this.transfert_coeff * (double)tension - this.transfert_Constante;
        if (transfertValue > 0.0) {
            return transfertValue;
        }
        return 0.0;
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Returns true if force sensor value is in range values where clamp is clamped.")
    public boolean isClamped() {
        return this.force > (double)this.minRangeValue && this.force < (double)this.maxRangeValue;
    }
}

