/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByFilter;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class Filter {
    public static final String SOCKET_NAME = "socket";
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem s;
    @ConfigurationParameter(isFinal=true, description="weight of this filter", range="0..100")
    private double weight;
    @ConfigurationParameter(description="Name of the socket where the filter is stored in.", category="filterLocation")
    private String socketName;
    @ConfigurationParameter(isFinal=true, description="FilterID which is coded on filter frame with 6 hall effect sensors.", range="1..63")
    private int filterID;
    private FcsEnumerations.FilterLocation filterLocation = FcsEnumerations.FilterLocation.UNKNOWN;

    public Filter(int filterID, double weight, String socketName) {
        this.filterID = filterID;
        this.weight = weight;
        this.socketName = socketName;
    }

    public void initializeFilterLocation() {
        this.filterLocation = this.socketName.contains(SOCKET_NAME) ? FcsEnumerations.FilterLocation.CAROUSEL : (this.socketName.contains("AC") ? FcsEnumerations.FilterLocation.AUTOCHANGER : (this.socketName.contains("OUT") ? FcsEnumerations.FilterLocation.OUT : FcsEnumerations.FilterLocation.UNKNOWN));
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns true if filter is held by the carousel.")
    public boolean isOnCarousel() {
        return this.filterLocation == FcsEnumerations.FilterLocation.CAROUSEL;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns true if filter is held by autochanger.")
    public boolean isOnAutoChanger() {
        return this.filterLocation == FcsEnumerations.FilterLocation.AUTOCHANGER;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns true if filter is out of camera.")
    public boolean isOut() {
        return this.filterLocation == FcsEnumerations.FilterLocation.OUT;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns true if filter location is UNKNOWN.")
    public boolean isUnknown() {
        return this.filterLocation == FcsEnumerations.FilterLocation.UNKNOWN;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns filter location.")
    public FcsEnumerations.FilterLocation getFilterLocation() {
        return this.filterLocation;
    }

    public void setFilterLocation(FcsEnumerations.FilterLocation filterLocation) {
        this.filterLocation = filterLocation;
        if (FcsEnumerations.FilterLocation.AUTOCHANGER.equals((Object)filterLocation)) {
            this.setSocketName("AC");
        } else if (FcsEnumerations.FilterLocation.OUT.equals((Object)filterLocation)) {
            this.setSocketName("");
        }
        this.publishData();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns filter id.")
    public int getFilterID() {
        return this.filterID;
    }

    public String getName() {
        return this.name;
    }

    public double getWeight() {
        return this.weight;
    }

    public String getSocketName() {
        return this.socketName;
    }

    @ConfigurationParameterChanger
    public void setSocketName(String socketName) {
        FcsUtils.checkSocketName(socketName);
        this.socketName = socketName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putFilterOnSocket(String socketName) {
        try {
            Filter filter = this;
            synchronized (filter) {
                this.filterLocation = FcsEnumerations.FilterLocation.CAROUSEL;
                this.s.getComponentConfigurationEnvironmentByName(this.name).change("socketName", (Object)socketName);
            }
        }
        catch (Exception ex) {
            String msg = this.name + " Software error : couln't update socket name:";
            FCSCst.FCSLOG.error((Object)(this.name + msg), (Throwable)ex);
            Alert alert = new Alert("FCS010" + this.name, msg + ex.getMessage());
            this.s.getAlertService().raiseAlert(alert, AlertState.ALARM, "cause");
        }
        this.publishData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromCarousel() {
        try {
            Filter filter = this;
            synchronized (filter) {
                this.filterLocation = FcsEnumerations.FilterLocation.AUTOCHANGER;
                this.s.getComponentConfigurationEnvironmentByName(this.name).change("socketName", (Object)"AC");
            }
        }
        catch (Exception ex) {
            String msg = " Software error : couln't remove filter from carousel:";
            FCSCst.FCSLOG.error((Object)(this.name + msg), (Throwable)ex);
            Alert alert = new Alert("FCS010" + this.name, " Software error : couln't remove filter from carousel:" + ex.getMessage());
            this.s.getAlertService().raiseAlert(alert, AlertState.ALARM, "cause");
        }
        FCSCst.FCSLOG.info((Object)(this.name + " removed from carousel"));
        this.publishData();
    }

    public void publishData() {
        this.s.publishSubsystemDataOnStatusBus(new KeyValueData(this.name, (Serializable)new StatusDataPublishedByFilter(this.filterLocation, this.socketName)));
    }

    @Command(alias="printFilter", type=Command.CommandType.QUERY, level=0, description="Return a printed filter.")
    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append(":filterID:");
        sb.append(this.filterID);
        sb.append(",Weight:");
        sb.append(this.weight);
        sb.append(",FilterLocation:");
        sb.append(this.filterLocation);
        if (this.filterLocation.equals((Object)FcsEnumerations.FilterLocation.CAROUSEL)) {
            sb.append(",socket:");
            sb.append(this.socketName);
        }
        return sb.toString();
    }
}

