/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.util.concurrent.locks.Condition;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarouselClamp;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.FilterHolder;
import org.lsst.ccs.subsystems.fcs.common.MobileItem;
import org.lsst.ccs.subsystems.fcs.common.PDOStorage;
import org.lsst.ccs.subsystems.fcs.common.Sensor14bits;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.SensorValueOutOfRangeException;

public class CarouselClamp
extends MobileItem {
    @LookupField(strategy=LookupField.Strategy.TREE)
    private MainModule mainModule;
    @LookupField(strategy=LookupField.Strategy.BYNAME)
    private BridgeToHardware tcpProxy;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private FilterHolder autochanger;
    protected EPOSController controller;
    private final Sensor14bits filterPresenceSensor;
    private final Sensor14bits lockSensor;
    protected FcsEnumerations.FilterClampState clampState = FcsEnumerations.FilterClampState.UNDEFINED;
    protected FcsEnumerations.FilterPresenceStatus filterPresenceStatus = FcsEnumerations.FilterPresenceStatus.NOT_LOCKABLE;
    private FcsEnumerations.LockStatus lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
    private final Condition stateUpdated = this.lock.newCondition();
    protected volatile boolean updatingState = false;
    @ConfigurationParameter
    protected int currentToUnlock = 1500;
    @ConfigurationParameter
    protected int currentToMaintainUnlocked = 200;
    @ConfigurationParameter(range="0..32768")
    private Integer lockSensorValueA = 5000;
    @ConfigurationParameter(range="0..32768")
    private Integer lockSensorValueB = 28800;
    @ConfigurationParameter(range="0..32768")
    private Integer lockSensorValueC = 32000;
    @ConfigurationParameter(range="0..32768")
    private Integer lockSensorOffset = 0;
    @ConfigurationParameter(range="0..32768")
    private Integer filterPresenceValueA = 1500;
    @ConfigurationParameter(range="0..32768")
    private Integer filterPresenceValueB = 24400;
    @ConfigurationParameter(range="0..32768")
    private Integer filterPresenceValueC = 32000;
    @ConfigurationParameter(range="0..32768")
    private Integer filterPresenceOffset = 0;
    @ConfigurationParameter(range="0..10000")
    protected long timeoutForUnlocking = 1500L;
    @ConfigurationParameter(range="0..10000")
    protected long timeoutForReleasing = 1500L;

    public CarouselClamp(Sensor14bits filterPresenceSensor, Sensor14bits lockSensor) {
        this.filterPresenceSensor = filterPresenceSensor;
        this.lockSensor = lockSensor;
    }

    public short getCurrentToUnlock() {
        return (short)this.currentToUnlock;
    }

    protected void setController(EPOSController actuator) {
        this.controller = actuator;
    }

    public int getLockSensorValueA() {
        return this.lockSensorValueA;
    }

    public int getLockSensorValueB() {
        return this.lockSensorValueB;
    }

    public int getLockSensorValueC() {
        return this.lockSensorValueC;
    }

    public int getFilterPresenceValueA() {
        return this.filterPresenceValueA;
    }

    public int getFilterPresenceValueB() {
        return this.filterPresenceValueB;
    }

    public int getFilterPresenceValueC() {
        return this.filterPresenceValueC;
    }

    public Sensor14bits getFilterPresenceSensor() {
        return this.filterPresenceSensor;
    }

    public Sensor14bits getLockSensor() {
        return this.lockSensor;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="return the lockStatus")
    public FcsEnumerations.LockStatus getLockStatus() {
        return this.lockStatus;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="return filterPresenceStatus")
    public FcsEnumerations.FilterPresenceStatus getFilterPresenceStatus() {
        return this.filterPresenceStatus;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if CANopen hardware is connected and ready.")
    public boolean myDevicesReady() {
        return this.mainModule.allDevicesBooted();
    }

    public FcsEnumerations.FilterClampState getClampState() {
        this.lock.lock();
        try {
            while (this.updatingState) {
                try {
                    this.stateUpdated.await();
                }
                catch (InterruptedException ex) {
                    FCSLOG.warning((Object)(this.name + ": getClampState interrupted while waiting for update."), (Throwable)ex);
                }
            }
            FcsEnumerations.FilterClampState filterClampState = this.clampState;
            return filterClampState;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if the clamp is locked")
    public boolean isLocked() {
        return this.lockStatus == FcsEnumerations.LockStatus.LOCKED;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if filter is engaged on the clamp : filter presence sensors sees it ")
    public synchronized boolean isFilterEngaged() {
        return this.filterPresenceStatus == FcsEnumerations.FilterPresenceStatus.LOCKABLE;
    }

    @Deprecated
    private void updateFilterPresenceStatus() {
        this.filterPresenceSensor.updateValue();
        int newFilterPresenceSensorValue = this.filterPresenceSensor.getValue();
        int mechaValue = newFilterPresenceSensorValue - this.filterPresenceOffset;
        if (mechaValue < this.filterPresenceValueA) {
            this.filterPresenceStatus = FcsEnumerations.FilterPresenceStatus.ERROR;
            FCSLOG.error((Object)(this.name + " ERROR new read value FOR FILTER POSITION SENSOR  = " + newFilterPresenceSensorValue));
            throw new SensorValueOutOfRangeException("FILTER POSITION SENSOR", this.filterPresenceSensor.getName(), 0, this.filterPresenceValueA.intValue(), mechaValue);
        }
        this.filterPresenceStatus = mechaValue < this.filterPresenceValueB ? FcsEnumerations.FilterPresenceStatus.LOCKABLE : (mechaValue < this.filterPresenceValueC ? FcsEnumerations.FilterPresenceStatus.NOT_LOCKABLE : FcsEnumerations.FilterPresenceStatus.NOFILTER);
    }

    private void updateFilterPresenceStatus(PDOStorage pdoStorage) {
        int newFilterPresenceSensorValue = this.filterPresenceSensor.updateValue(pdoStorage);
        int mechaValue = newFilterPresenceSensorValue - this.filterPresenceOffset;
        if (mechaValue < this.filterPresenceValueA) {
            this.filterPresenceStatus = FcsEnumerations.FilterPresenceStatus.ERROR;
            FCSLOG.error((Object)(this.name + " ERROR new read value FOR FILTER POSITION SENSOR  = " + newFilterPresenceSensorValue));
            throw new SensorValueOutOfRangeException("FILTER POSITION SENSOR", this.filterPresenceSensor.getName(), 0, Short.MAX_VALUE, mechaValue);
        }
        this.filterPresenceStatus = mechaValue < this.filterPresenceValueB ? FcsEnumerations.FilterPresenceStatus.LOCKABLE : (mechaValue < this.filterPresenceValueC ? FcsEnumerations.FilterPresenceStatus.NOT_LOCKABLE : FcsEnumerations.FilterPresenceStatus.NOFILTER);
    }

    @Deprecated
    private void updateLockStatus() {
        this.lockSensor.updateValue();
        this.computeLockStatus(this.lockSensor.getValue());
    }

    private void updateLockStatus(PDOStorage pdoStorage) {
        this.computeLockStatus(this.lockSensor.updateValue(pdoStorage));
    }

    private void computeLockStatus(int newValue) {
        int mechaValue = newValue - this.lockSensorOffset;
        if (mechaValue < this.lockSensorValueA) {
            this.lockStatus = FcsEnumerations.LockStatus.UNLOCKED;
        } else if (mechaValue <= this.lockSensorValueB) {
            this.lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
        } else if (mechaValue <= this.lockSensorValueC) {
            this.lockStatus = FcsEnumerations.LockStatus.LOCKED;
        } else {
            this.lockStatus = FcsEnumerations.LockStatus.ERROR;
            FCSLOG.error((Object)(this.name + " ERROR new read value FOR LOCK SENSOR  = " + newValue));
            throw new FcsHardwareException(this.name + ": ERROR in reading LOCK SENSOR - value read=" + mechaValue + " should be > " + this.lockSensorValueC);
        }
    }

    @Deprecated
    public void updateStateWithSensorsFromSDO() {
        this.lock.lock();
        this.updatingState = true;
        try {
            this.updateFilterPresenceStatus();
            this.updateLockStatus();
            this.computeClampState();
        }
        finally {
            this.updatingState = false;
            this.stateUpdated.signalAll();
            this.lock.unlock();
        }
        this.publishData();
    }

    @Command(type=Command.CommandType.QUERY, level=1, alias="updateState", description="Read clamp sensors and update clampState")
    public void updateStateWithSensors() {
        this.updateStateWithSensors(this.tcpProxy.readPDOs());
    }

    void updateStateWithSensors(PDOStorage pdoStorage) {
        this.lock.lock();
        try {
            this.updatingState = true;
            this.updateFilterPresenceStatus(pdoStorage);
            this.updateLockStatus(pdoStorage);
            this.computeClampState();
        }
        finally {
            this.updatingState = false;
            this.stateUpdated.signalAll();
            this.lock.unlock();
        }
        this.publishData();
    }

    @Override
    public void publishData() {
        StatusDataPublishedByCarouselClamp status = this.createStatusDataPublishedByClamp();
        this.s.publishSubsystemDataOnStatusBus(new KeyValueData(this.name, (Serializable)status));
    }

    public StatusDataPublishedByCarouselClamp createStatusDataPublishedByClamp() {
        StatusDataPublishedByCarouselClamp status = new StatusDataPublishedByCarouselClamp();
        status.setName(this.name);
        status.setClampState(this.clampState.toString());
        status.setFilterPresenceStatus(this.filterPresenceStatus);
        status.setFilterPositionSensorValue(this.filterPresenceSensor.getValue());
        status.setLockSensorValue(this.lockSensor.getValue());
        status.setLockStatus(this.lockStatus);
        return status;
    }

    private void computeClampState() {
        this.clampState = this.filterPresenceStatus == FcsEnumerations.FilterPresenceStatus.ERROR || this.lockStatus == FcsEnumerations.LockStatus.ERROR ? FcsEnumerations.FilterClampState.ERROR : (this.filterPresenceStatus == FcsEnumerations.FilterPresenceStatus.LOCKABLE ? (this.lockStatus == FcsEnumerations.LockStatus.LOCKED ? FcsEnumerations.FilterClampState.CLAMPEDONFILTER : (this.lockStatus == FcsEnumerations.LockStatus.UNLOCKED ? FcsEnumerations.FilterClampState.UNCLAMPEDONFILTER : FcsEnumerations.FilterClampState.UNDEFINED)) : (this.filterPresenceStatus == FcsEnumerations.FilterPresenceStatus.NOFILTER ? (this.lockStatus == FcsEnumerations.LockStatus.LOCKED ? FcsEnumerations.FilterClampState.READYTOCLAMP : (this.lockStatus == FcsEnumerations.LockStatus.UNLOCKED ? FcsEnumerations.FilterClampState.UNCLAMPEDEMPTY : FcsEnumerations.FilterClampState.ERROR)) : FcsEnumerations.FilterClampState.UNDEFINED));
    }

    private void computeClampStateWhenReleasing() {
        if (this.name.contains("Xminus") && this.clampState == FcsEnumerations.FilterClampState.UNCLAMPEDEMPTY) {
            this.clampState = FcsEnumerations.FilterClampState.READYTOCLAMP;
        }
    }

    @Command(level=3, type=Command.CommandType.ACTION, description="Release clamp in order to get ready to clamp a filter again")
    public void release() {
        FCSLOG.info((Object)("Checking conditions for release clamp " + this.name + " on socket at standby position."));
        this.updateStateWithSensors();
        if (this.clampState != FcsEnumerations.FilterClampState.UNCLAMPEDEMPTY) {
            throw new RejectedCommandException("Can't release a clamp if isn't unclamped and empty.");
        }
        FCSLOG.info((Object)("Releasing clamp " + this.name + " on socket at standby position."));
        this.executeAction(FcsEnumerations.MobileItemAction.RELEASE, this.timeoutForReleasing);
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Unlock the clamp")
    public void unlock() {
        FCSLOG.info((Object)(this.name + ": UNLOCK State1 = " + this.clampState.toString()));
        this.updateStateWithSensors();
        if (this.clampState != FcsEnumerations.FilterClampState.CLAMPEDONFILTER) {
            throw new RejectedCommandException("Can't unlock a clamp if it is already unlocked.");
        }
        if (this.autochanger == null) {
            throw new RejectedCommandException("NO AUTOCHANGER");
        }
        if (this.autochanger.isAtStandby() && !this.autochanger.isHoldingFilter()) {
            throw new RejectedCommandException("CANNOT UNLOCK A CLAMP if FILTER is not HELD by autochanger.");
        }
        this.executeAction(FcsEnumerations.MobileItemAction.UNLOCK, this.timeoutForUnlocking);
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) {
        if (action == FcsEnumerations.MobileItemAction.UNLOCK) {
            this.controller.enable();
            this.controller.writeCurrent((short)this.currentToUnlock);
        } else if (action == FcsEnumerations.MobileItemAction.RELEASE) {
            this.controller.stopAction();
        } else {
            throw new IllegalArgumentException("Action on clamp must be UNLOCK or RELEASE");
        }
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        if (action == FcsEnumerations.MobileItemAction.UNLOCK) {
            return this.clampState == FcsEnumerations.FilterClampState.UNCLAMPEDONFILTER;
        }
        if (action == FcsEnumerations.MobileItemAction.RELEASE) {
            this.computeClampStateWhenReleasing();
            return this.clampState == FcsEnumerations.FilterClampState.READYTOCLAMP;
        }
        throw new IllegalArgumentException("Action on clamp must be UNLOCK or RELEASE");
    }

    @Override
    public void postAction(FcsEnumerations.MobileItemAction action) {
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() {
        this.updateStateWithSensors();
    }

    public double updateTemperature() {
        return 0.0;
    }

    @Command(type=Command.CommandType.QUERY, level=3, description="display configuration values for this clamp.")
    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append("/filterPresenceSensor=");
        sb.append(this.filterPresenceSensor.getName());
        sb.append("#valueA=");
        sb.append(this.filterPresenceValueA);
        sb.append("#valueB=");
        sb.append(this.filterPresenceValueB);
        sb.append("#valueC=");
        sb.append(this.filterPresenceValueC);
        sb.append("/lockSensor=");
        sb.append(this.lockSensor.getName());
        sb.append("#valueA=");
        sb.append(this.lockSensorValueA);
        sb.append("#valueB=");
        sb.append(this.lockSensorValueB);
        sb.append("#valueC=");
        sb.append(this.lockSensorValueC);
        return sb.toString();
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) {
        FCSLOG.info((Object)("Current Command: " + this.s.getCurrentAction() + " " + this.s.getState()));
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

