#####################################################################
#Script to test the simulated hardware of autochanger in standalone.
#This can be used with real hardware.
#This test is a part of integration tests.
#####################################################################
#import CCS Scripting Implementation                                                                                          
from org.lsst.ccs.scripting import CCS
#import the definition for a Java Exception                                                                                   
from java.lang import Exception
from org.lsst.ccs.command import CommandInvocationException

#
CCS.setThrowExceptions(True);
#####################################################################
# launch autochanger-standalone subsystem and initialize
#####################################################################
autochangerStandalone = CCS.attachSubsystem("autochanger-standalone")

print "Connected to autochanger ", autochangerStandalone

###autochanger
autochanger = CCS.attachSubsystem("autochanger-standalone/autochanger")
###plutoGateway
plutoGateway = CCS.attachSubsystem("autochanger-standalone/acSensorsGateway")
###autochangerTrucks
trucks = CCS.attachSubsystem("autochanger-standalone/autochangerTrucks")
###latches
latches = CCS.attachSubsystem("autochanger-standalone/latches")

timeoutForTrucksMotion = int((trucks.synchCommandLine(5,"getTimeoutForTrucksMotion")).getResult())
standbyPosition = int((trucks.synchCommandLine(5,"getStandbyPosition")).getResult())
handoffPosition = int((trucks.synchCommandLine(5,"getHandoffPosition")).getResult())
onlinePosition = int((trucks.synchCommandLine(5,"getOnlinePosition")).getResult())

timeoutForOpeningLatches = int((latches.synchCommandLine(5,"getTimeoutForOpening")).getResult())
timeoutForClosingLatches = int((latches.synchCommandLine(5,"getTimeoutForClosing")).getResult())

#####################################################################
# read sensors and updateState
#####################################################################
CCS.setThrowExceptions(False);

#Handle the thrown exceptions                                                                                                 
print "=> Read sensors and update state "
result = autochanger.synchCommandLine(3000,"updateStateWithSensors")

if isinstance(result.getResult(), CommandInvocationException):
     raise Exception(result.getResult())
print "state has been updated"

CCS.setThrowExceptions(True)

#####################################################################
# FONCTION move trucks to ONLINE
#####################################################################
def moveToOnline():
    "Move trucks to ONLINE"
    print "=>Moving to ONLINE"
    trucks.synchCommandLine(timeoutForTrucksMotion,"goToOnline")
    #check that trucks are at ONLINE
    trucksPosition = int((trucks.synchCommandLine(5,"getPosition")).getResult())
    print "trucks position=", trucksPosition
    print "ONLINE position=", onlinePosition
    if trucksPosition == onlinePosition :
        print "=>Gone to ONLINE."
    else :
        raise Exception("Autochanger Trucks are NOT at ONLINE position")

#####################################################################
# FONCTION move trucks to HANDOFF
#####################################################################
def moveToHandoff():
    print "=>Moving to HANDOFF"
    CCS.setThrowExceptions(True);
    trucks.synchCommandLine(timeoutForTrucksMotion,"goToHandoff")
    #check that trucks are at HANDOFF
    trucksPosition = int((trucks.synchCommandLine(5,"getPosition")).getResult())
    print "trucks position=", trucksPosition
    print "HANDOFF position=", handoffPosition
    if trucksPosition == handoffPosition:
        print "=>Gone to HANDOFF."
    else :
        raise Exception("Autochanger Trucks are NOT at HANDOFF position")


#####################################################################
# FONCTION move trucks to STANDBY
#####################################################################
def moveToStandby():
    print "=> Moving to STANDBY"
    trucks.synchCommandLine(timeoutForTrucksMotion,"goToStandby")
    #check that trucks are at STANDBY
    trucksPosition = int((trucks.synchCommandLine(5,"getPosition")).getResult())
    print "trucks position =", trucksPosition
    print "STANDBY position =", standbyPosition
    if trucksPosition == standbyPosition :
        print "=> Gone to STANDBY."
    else :
        raise Exception("Autochanger Trucks are NOT at STANDBY position")

#####################################################################
# FONCTION should be empty. If not empty, raise an Exception
#####################################################################
def shouldBeEmpty(action):
    """
    If autochanger is NOT empty, raise an exception.
    """
    isEmpty = (autochanger.synchCommandLine(5," isEmpty")).getResult();
    print "isEmpty =", isEmpty
    if isEmpty :
        print "No filter on autochanger"
    else :
        raise Exception("Autochanger should be empty after action: " + action)
    
#####################################################################
# FONCTION should NOT be empty. If empty, raise an Exception
#####################################################################
def shouldNotBeEmpty(action):
    """
    If autochanger is empty, raise an exception.
    """
    isEmpty = (autochanger.synchCommandLine(5," isEmpty")).getResult();
    print "isEmpty =", isEmpty
    if isEmpty :
        raise Exception("Autochanger should NOT be empty after action: " + action)  
    else :
        print "A filter is on autochanger"


#################################################################################
# move trucks to ONLINE, then to HANDOFF, then to STANDBY, then back to HANDOFF 
#################################################################################
moveToOnline()
shouldBeEmpty("moveToOnline")

moveToHandoff()
shouldBeEmpty("moveToHandoff1")

moveToStandby()
shouldNotBeEmpty("moveToStandby")

moveToHandoff()
shouldBeEmpty("moveToHandoff2")

#############################################################################
# Go to STANDBY, grab filter, moves it to ONLINE, moves it back to STANDBY,
# ungrab it at STANDBY, and returns empty to HANDOFF.
#############################################################################
isEmpty = (autochanger.synchCommandLine(5, "isEmpty")).getResult()
if isEmpty :
    print "===> BEGIN Sequence"
else :
    raise Exception("Autochanger is not Empty.")
###
moveToStandby()
###
print "=> simulateFilterID"
plutoGateway.synchCommandLine(5, "simulateFilterID 1");

print "=> grabFilterAtStandby"
print "timeoutForOpeningLatches", timeoutForOpeningLatches
autochanger.synchCommandLine(timeoutForOpeningLatches, "grabFilterAtStandby");

isEmpty = (autochanger.synchCommandLine(5, "isEmpty")).getResult();
if isEmpty :
    raise Exception("Autochanger is empty after grabFilterAtStandby. Something weird happened.")
else :
    filterID=int((autochanger.synchCommandLine(5, "getFilterOnTrucksID")).getResult())
    print "filter on autochanger trucks ID=", filterID
    print "===> Sequence can continue"

###Simulate that carousel is not holding a filter
###ONLY for simulation
print "=> simulateCarouselIsNotHoldingFilter"
plutoGateway.synchCommandLine(5, "simulateCarouselIsNotHoldingFilter")
autochangerStandalone.synchCommandLine(5, "updateStateWithSensors")

###
moveToOnline()

###
moveToStandby()
print "=> simulateCarouselIsHoldingFilter"
plutoGateway.synchCommandLine(5,"simulateCarouselIsHoldingFilter")
autochangerStandalone.synchCommandLine(5,"updateStateWithSensors")

###
print "=> ungrabFilterAtStandby"
print "timeoutForClosingLatches",timeoutForClosingLatches
autochanger.synchCommandLine(timeoutForClosingLatches,"ungrabFilterAtStandby")

###
moveToHandoff()
print "===> END Sequence"

