/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.concurrent.TimeUnit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.scripting.CCS;
import org.lsst.ccs.scripting.jython.JythonScriptExecutorUtils;
import org.lsst.ccs.subsystems.fcs.Autochanger;
import org.lsst.ccs.subsystems.fcs.AutochangerOnlineClamp;
import org.lsst.ccs.subsystems.fcs.AutochangerTwoLatches;
import org.lsst.ccs.subsystems.fcs.AutochangerTwoTrucks;
import org.lsst.ccs.subsystems.fcs.Carousel;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.FcsMain;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.FilterManager;
import org.lsst.ccs.subsystems.fcs.Utils;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.simulation.SimuAutochangerPlutoGateway;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCarouselController;

public class FcsTest
extends CcsTestCaseTemplate {
    private static Subsystem fcsSubsystem = null;
    private static FcsMain main;
    private static Autochanger autochanger;
    private static AutochangerTwoTrucks trucks;
    private static AutochangerTwoLatches latches;
    private static Carousel carousel;
    private static SimuCarouselController carouselController;
    private static SimuAutochangerPlutoGateway acPlutoGateway;
    private static FilterManager filterManager;
    private static Filter filterI;
    private static int socket1StandbyPos;
    private static AutochangerOnlineClamp onlineClampXminus;
    private static AutochangerOnlineClamp onlineClampXplus;
    private static AutochangerOnlineClamp onlineClampYminus;
    private static AutochangerOnlineClamp[] clampsList;

    @BeforeClass
    public static void before() throws Exception {
        System.out.println("************************************************************************************");
        System.out.println("***                  TESTS OF THE WHOLE FCS SIMULATED                            ***");
        System.out.println("************************************************************************************");
        fcsSubsystem = BootUtils.getSubsystemFromFile((String)"fcs__simulation", (String)"");
        fcsSubsystem.startAgent();
        fcsSubsystem.waitFor(state -> state.isInState((Enum)PhaseState.OPERATIONAL), 60L, TimeUnit.SECONDS);
        ComponentLookup lookup = fcsSubsystem.getComponentLookup();
        main = (FcsMain)lookup.getComponentByName("main");
        autochanger = (Autochanger)lookup.getComponentByName("autochanger");
        carousel = (Carousel)lookup.getComponentByName("carousel");
        carouselController = (SimuCarouselController)lookup.getComponentByName("carouselController");
        acPlutoGateway = (SimuAutochangerPlutoGateway)lookup.getComponentByName("acSensorsGateway");
        acPlutoGateway.simulateAutochangerTrucksAreAtHandoff();
        acPlutoGateway.simulateAutochangerOnlineClampsAreOpened();
        autochanger.updateStateWithSensors();
        carousel.updateStateWithSensors();
        carouselController.initializeAndCheckHardware();
        trucks = (AutochangerTwoTrucks)lookup.getComponentByName("autochangerTrucks");
        trucks.updatePosition();
        latches = (AutochangerTwoLatches)lookup.getComponentByName("latches");
        filterManager = (FilterManager)lookup.getComponentByName("filterManager");
        filterI = filterManager.getFilterByName("filterI");
        onlineClampXminus = (AutochangerOnlineClamp)lookup.getComponentByName("onlineClampXminus");
        onlineClampXplus = (AutochangerOnlineClamp)lookup.getComponentByName("onlineClampXplus");
        onlineClampYminus = (AutochangerOnlineClamp)lookup.getComponentByName("onlineClampYminus");
        for (AutochangerOnlineClamp clamp : clampsList = new AutochangerOnlineClamp[]{onlineClampXminus, onlineClampXplus, onlineClampYminus}) {
            clamp.setIncrementCurrentToClose(300);
            clamp.setIncrementCurrentToOpen(300);
            clamp.setIncrementCurrentToClamp(532);
            clamp.setInitialCurrentToClose(300);
            clamp.setFinalCurrentToClose(1800);
            clamp.setCurrentToOpen(-300);
            clamp.setCurrentToClamp(4992);
            clamp.setMaxTimeToClose(1000);
            clamp.setMaxTimeToOpen(1400);
            clamp.setMaxTimeToLock(1200);
            clamp.setMaxTimeToUnlock(1200);
        }
        Assert.assertTrue((String)"AutochangerTrucks are at HANDOFF", (boolean)trucks.isAtHandoff());
        Assert.assertTrue((String)"Carousel and Autochanger hardware is ready", (boolean)main.isChangerReady());
        Assert.assertTrue((String)"fcsSubsystem.isInState(PhaseState.OPERATIONAL", (boolean)fcsSubsystem.isInState((Enum)PhaseState.OPERATIONAL));
    }

    @Before
    public void setUp() {
        Utils.printJoliSetUp("FcsTest");
        socket1StandbyPos = carousel.getSocketByName("socket1").getStandbyPosition();
        carouselController.setSsiPosition(socket1StandbyPos);
        carousel.updatePosition();
        Assert.assertEquals((String)("socket1StandbyPos is " + socket1StandbyPos), (long)socket1StandbyPos, (long)carousel.getSocketByName("socket1").getStandbyPosition());
        Assert.assertEquals((String)"carousel position is socket1 STANDBY position", (long)socket1StandbyPos, (long)carousel.getPosition());
        Assert.assertEquals((String)"socket in STANDBY is socket1", (Object)"socket1", (Object)carousel.getSocketAtStandby().getName());
        Assert.assertEquals((String)"socket1 is at STANDBY", (Object)carousel.getSocketAtStandby(), (Object)carousel.getSocketByName("socket1"));
    }

    @Test
    public void testExchangeBetweenCarouselAndAutochanger() {
        System.out.println("*******************************************************");
        System.out.println("*** test Exchange Between Carousel And Autochanger  ***");
        System.out.println("*******************************************************");
        System.out.println(" from carousel to autochanger");
        trucks.goToStandby();
        carousel.updateClampsStateWithSensorsFromPDO();
        autochanger.grabFilterAtStandby();
        Assert.assertFalse((String)"Autochanger is NOT empty", (boolean)autochanger.isEmpty());
        Assert.assertTrue((boolean)autochanger.isHoldingFilter());
        int filterID = autochanger.getFilterOnTrucksID();
        Filter filter = filterManager.getFilterByID(filterID);
        carousel.ungrabFilterAtStandby(filter.getName());
        trucks.goToOnline();
        carousel.updateClampsStateWithSensorsFromPDO();
        Assert.assertEquals((String)"socket1 is socketAtStandby", (Object)carousel.getSocketAtStandby(), (Object)carousel.getSocketByName("socket1"));
        Assert.assertFalse((String)"Autochanger is NOT empty", (boolean)autochanger.isEmpty());
        Assert.assertFalse((String)"carousel is no more holding filter at STANDBY", (boolean)carousel.isHoldingFilter());
        Assert.assertFalse((String)"socket2 is NOT at STANDBY", (boolean)carousel.getSocketByName("socket2").isAtStandby());
        Assert.assertEquals((String)"socket2 is CLAMPEDONFILTER", (Object)FcsEnumerations.FilterClampState.CLAMPEDONFILTER, (Object)carousel.getSocketByName("socket2").getClampsState());
        Assert.assertEquals((String)"socket1 is UNCLAMPEDEMPTY", (Object)FcsEnumerations.FilterClampState.UNCLAMPEDEMPTY, (Object)carousel.getSocketByName("socket1").getClampsState());
        Assert.assertTrue((String)"Filter is now on Autochanger", (boolean)filter.isOnAutoChanger());
        carousel.releaseClamps();
        Assert.assertEquals((String)"clamps at STANDBY are READYTOCLAMP", (Object)FcsEnumerations.FilterClampState.READYTOCLAMP, (Object)carousel.getSocketAtStandby().getClampsState());
        System.out.println(" from autochanger to carousel");
        trucks.goToStandby();
        Assert.assertFalse((String)"Autochanger is NOT empty", (boolean)autochanger.isEmpty());
        carousel.grabFilterAtStandby(filterManager.getFilterByID(filterID));
        Assert.assertTrue((String)"carousel is holding filter at STANDBY", (boolean)carousel.isHoldingFilter());
        Assert.assertEquals((String)"socket1 is now CLAMPEDONFILTER", (Object)FcsEnumerations.FilterClampState.CLAMPEDONFILTER, (Object)carousel.getSocketByName("socket1").getClampsState());
        Assert.assertFalse((String)"Autochanger is NOT empty", (boolean)autochanger.isEmpty());
        latches.open();
        trucks.goToHandOff();
        Assert.assertTrue((String)"Autochanger is now empty", (boolean)autochanger.isEmpty());
        Assert.assertTrue((String)"Autochanger is at HANDOFF", (boolean)autochanger.getAutochangerTrucks().isAtHandoff());
        Assert.assertTrue((String)"Filter is now on Carousel", (boolean)filter.isOnCarousel());
    }

    @Test
    public void testSetFilter() {
        System.out.println("**********************************");
        System.out.println("***       testSetFilter        ***");
        System.out.println("**********************************");
        System.out.println("********  setFilter(filterU)  *********************");
        String filterName = "filterU";
        System.out.println("Filter List:" + filterManager.getFiltersMapByName());
        main.setFilter(filterName.substring(6, filterName.length()));
        Assert.assertEquals((String)("Now filter at ONLINE is " + filterName), (Object)filterName, (Object)main.getOnlineFilterName());
        Assert.assertTrue((String)"Carousel is ready to grab a filter at STANDBY", (boolean)carousel.isReadyToGrabAFilterAtStandby());
        System.out.println("********  setFilter(filterT)  *********************");
        filterName = "filterT";
        try {
            main.setFilter(filterName.substring(6, filterName.length()));
            Assert.fail((String)(filterName + " unknown filtername. Should raise an IllegalArgumentException"));
        }
        catch (IllegalArgumentException ex) {
            System.out.println(filterName + " unknown filtername. Exception raised:" + ex);
        }
        System.out.println("********  setFilter(filterY)  *********************");
        filterName = "filterY";
        try {
            main.setFilter(filterName.substring(6, filterName.length()));
            Assert.fail((String)(filterName + " out of camera. Should raise an RejectedCommandException"));
        }
        catch (RejectedCommandException ex) {
            System.out.println(filterName + " filterY is out of camera. Exception raised:" + (Object)((Object)ex));
        }
        System.out.println("********  setFilter(filterG)  *********************");
        filterName = "filterG";
        System.out.println("Filter List:" + filterManager.getFiltersMapByName());
        main.setFilter(filterName.substring(6, filterName.length()));
        Assert.assertEquals((String)("Now filter at ONLINE is " + filterName), (Object)filterName, (Object)main.getOnlineFilterName());
        Assert.assertTrue((String)"Carousel is ready to grab a filter at STANDBY", (boolean)carousel.isReadyToGrabAFilterAtStandby());
        System.out.println("********  setFilter(filterI)  *********************");
        filterName = "filterI";
        System.out.println("Filter List:" + filterManager.getFiltersMapByName());
        main.setFilter(filterName.substring(6, filterName.length()));
        Assert.assertEquals((String)("Now filter at ONLINE is " + filterName), (Object)filterName, (Object)main.getOnlineFilterName());
        Assert.assertTrue((String)"Carousel is ready to grab a filter at STANDBY", (boolean)carousel.isReadyToGrabAFilterAtStandby());
        System.out.println("********  store filter on carousel again   ********");
        autochanger.getOnlineClamps().unlockAndOpenClamps();
        trucks.goToStandby();
        Assert.assertFalse((String)"Autochanger is NOT empty", (boolean)autochanger.isEmpty());
        carousel.grabFilterAtStandby(filterManager.getFilterByID(autochanger.getFilterOnTrucksID()));
        Assert.assertTrue((String)"carousel is holding filter at STANDBY", (boolean)carousel.isHoldingFilter());
        Assert.assertEquals((String)"socket at STANDBY is now CLAMPEDONFILTER", (Object)FcsEnumerations.FilterClampState.CLAMPEDONFILTER, (Object)carousel.getSocketAtStandby().getClampsState());
        Assert.assertFalse((String)"Autochanger is NOT empty", (boolean)autochanger.isEmpty());
        latches.open();
        trucks.goToHandOff();
        Assert.assertTrue((String)"Autochanger is now empty", (boolean)autochanger.isEmpty());
        Assert.assertTrue((String)"Autochanger is at HANDOFF", (boolean)autochanger.getAutochangerTrucks().isAtHandoff());
        Assert.assertTrue((String)"Filter I is now on Carousel", (boolean)filterI.isOnCarousel());
    }

    @AfterClass
    public static void after() throws Exception {
        fcsSubsystem.shutdown();
        fcsSubsystem.waitFor(state -> state.isInState((Enum)PhaseState.OFF_LINE), 60L, TimeUnit.SECONDS);
    }

    public void launchScript() throws Exception {
        System.out.println("**************************************");
        System.out.println("***       launch  fcsTest.py       ***");
        System.out.println("**************************************");
        CCS.initializeScriptingEnvironment();
        Assert.assertTrue((String)"fcsSubsystem should be in OPERATIONAL phase.", (boolean)fcsSubsystem.isInState((Enum)PhaseState.OPERATIONAL));
        JythonScriptExecutorUtils.executeScript((String)"org/lsst/ccs/subsystems/fcs/scripts/fcsTest.py", (String[])new String[0]);
        System.out.println("**************************************");
        System.out.println("*** end of execution of fcsTest.py ***");
        System.out.println("**************************************");
    }
}

