/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.security.SecureRandom;
import java.util.concurrent.TimeUnit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.scripting.CCS;
import org.lsst.ccs.scripting.jython.JythonScriptExecutorUtils;
import org.lsst.ccs.subsystems.fcs.Carousel;
import org.lsst.ccs.subsystems.fcs.CarouselClamp;
import org.lsst.ccs.subsystems.fcs.CarouselMain;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.FilterManager;
import org.lsst.ccs.subsystems.fcs.errors.FailedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCarouselClampLockSensor;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCarouselController;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCarouselStandalonePlutoGateway;

public class CarouselTest
extends CcsTestCaseTemplate {
    private static Subsystem carouselSubsystem = null;
    private static CarouselMain main;
    private static Carousel carousel;
    private static SimuCarouselController carouselController;
    private final SecureRandom randomGenerator = new SecureRandom();
    private static SimuCarouselStandalonePlutoGateway plutoGateway;
    private static FilterManager filterManager;
    private static ComponentLookup lookup;
    private static Filter filterU;
    private static Filter filterG;
    private static Filter filterR;
    private static Filter filterI;
    private static Filter filterZ;
    private static final String FILTER_U_NAME = "filterU";
    private static final String FILTER_G_NAME = "filterG";
    private static final String FILTER_R_NAME = "filterR";
    private static final String FILTER_I_NAME = "filterI";
    private static final String FILTER_Z_NAME = "filterZ";
    private static int socket1StandbyPos;

    public CarouselTest() {
        socket1StandbyPos = carousel.getSocketByName("socket1").getStandbyPosition();
    }

    @BeforeClass
    public static void before() throws Exception {
        System.out.println("********************************************************************************");
        System.out.println("                   TESTS OF CAROUSEL IN STANDALONE MODE");
        System.out.println("********************************************************************************");
        CCS.initializeScriptingEnvironment();
        carouselSubsystem = BootUtils.getSubsystemFromFile((String)"carousel__simulation", (String)"");
        carouselSubsystem.startAgent();
        carouselSubsystem.waitFor(state -> state.isInState((Enum)PhaseState.OPERATIONAL), 60L, TimeUnit.SECONDS);
        lookup = carouselSubsystem.getComponentLookup();
        main = (CarouselMain)lookup.getComponentByName("main");
        carousel = (Carousel)lookup.getComponentByName("carousel");
        carousel.updateClampsStateWithSensors();
        carouselController = (SimuCarouselController)lookup.getComponentByName("carouselController");
        Assert.assertTrue((String)"carousel hardware is ready", (boolean)carousel.myDevicesReady());
        carouselController.initializeAndCheckHardware();
        Assert.assertTrue((String)"carouselController is initialized", (boolean)carouselController.isInitialized());
        carousel.homing();
        Assert.assertTrue((String)"carousel homing is done", (boolean)carousel.isHomingDone());
        plutoGateway = (SimuCarouselStandalonePlutoGateway)lookup.getComponentByName("fakePlutoGateway");
        filterManager = (FilterManager)lookup.getComponentByName("filterManager");
        filterManager.init();
        filterU = (Filter)filterManager.getFiltersMapByName().get(FILTER_U_NAME);
        filterG = (Filter)filterManager.getFiltersMapByName().get(FILTER_G_NAME);
        filterR = (Filter)filterManager.getFiltersMapByName().get(FILTER_R_NAME);
        filterI = (Filter)filterManager.getFiltersMapByName().get(FILTER_I_NAME);
        filterZ = (Filter)filterManager.getFiltersMapByName().get(FILTER_Z_NAME);
    }

    @AfterClass
    public static void after() throws Exception {
        System.out.println("*******************************************************************");
        System.out.println("********* end of TESTS OF CAROUSEL IN STANDALONE MODE *************");
        System.out.println("*******************************************************************");
        carouselSubsystem.shutdown();
        carouselSubsystem.waitFor(state -> state.isInState((Enum)PhaseState.OFF_LINE), 30L, TimeUnit.SECONDS);
        CCS.shutdownScriptingEnvironment();
    }

    @Before
    public void setUp() throws FcsHardwareException {
        System.out.println("#############################################");
        System.out.println("###            CarouselTest               ###");
        System.out.println("###Go back to initial conditions:");
        System.out.println("###   socket1 at STANDBY");
        System.out.println("###   carousel holding a filter at STANDBY");
        System.out.println("###   socket at STANDBY CLAMPEDONFILTER");
        System.out.println("#############################################");
        carouselSubsystem.getAlertService().clearAllAlerts();
        carouselController.setSsiPosition(socket1StandbyPos);
        carousel.updatePosition();
        Assert.assertEquals((String)"carousel position is socket1 STANDBY position", (long)socket1StandbyPos, (long)carousel.getPosition());
        Assert.assertEquals((String)"socket in STANDBY is socket1", (Object)"socket1", (Object)carousel.getSocketAtStandby().getName());
        ((SimuCarouselClampLockSensor)carousel.getSocketAtStandby().getClampXminus().getLockSensor()).simulateClampIsLOCKED();
        ((SimuCarouselClampLockSensor)carousel.getSocketAtStandby().getClampXplus().getLockSensor()).simulateClampIsLOCKED();
        carousel.updateClampsStateWithSensors();
        Assert.assertTrue((String)"carousel is holding a filter at STANDBY", (boolean)carousel.isHoldingFilterAtStandby());
        Assert.assertTrue((String)"Socket at STANDBY is LOCKED again.", (boolean)carousel.getSocketAtStandby().isClampedOnFilter());
    }

    @Test
    public void testClamps() throws FcsHardwareException {
        System.out.println("*** test of clamps state ***");
        for (int i = 1; i < 5; ++i) {
            String clampXminusName = "clampXminus" + i;
            System.out.println("Checking ClampState for " + clampXminusName);
            CarouselClamp clampXminus = (CarouselClamp)lookup.getComponentByName(clampXminusName);
            Assert.assertTrue((String)(clampXminusName + " contains a filter."), (boolean)clampXminus.isFilterEngaged());
            Assert.assertTrue((String)(clampXminusName + " is LOCKED."), (boolean)clampXminus.isLocked());
            String clampXplusName = "clampXplus" + i;
            System.out.println("Checking ClampState for " + clampXplusName);
            CarouselClamp clampXplus = (CarouselClamp)lookup.getComponentByName(clampXplusName);
            Assert.assertTrue((String)(clampXplusName + " contains a filter."), (boolean)clampXplus.isFilterEngaged());
            Assert.assertTrue((String)(clampXplusName + " is LOCKED."), (boolean)clampXplus.isLocked());
        }
        System.out.println("Test clamps state is in error state");
        ((SimuCarouselClampLockSensor)carousel.getSocketAtStandby().getClampXminus().getLockSensor()).simulateClampIsUNLOCKED();
        try {
            carousel.updateClampsStateWithSensors();
            Assert.fail((String)"Clamps state are in error. Should raise an Exception: ClampsOrLatchesDisagreeException");
        }
        catch (FcsHardwareException ex) {
            System.out.println("Clamps state are in error. Exception raised: " + (Object)((Object)ex));
        }
        System.out.println("Test unLockClamps when a filter is not clamped at standby");
        ((SimuCarouselClampLockSensor)carousel.getSocketAtStandby().getClampXminus().getLockSensor()).simulateClampIsUNLOCKED();
        ((SimuCarouselClampLockSensor)carousel.getSocketAtStandby().getClampXplus().getLockSensor()).simulateClampIsUNLOCKED();
        carousel.updateClampsStateWithSensors();
        Assert.assertFalse((String)"Clamps at STANDBY are not ClampedOnFilter.", (boolean)carousel.getSocketAtStandby().isClampedOnFilter());
        try {
            carousel.unlockClamps();
            Assert.fail((String)"Clamps at STANDBY are not ClampedOnFilter. unlockClamps should raise an Exception.");
        }
        catch (FailedCommandException | RejectedCommandException ex) {
            System.out.println("Clamps at STANDBY are not ClampedOnFilter. Raised exception=" + ex);
        }
        System.out.println("Go back to initial conditions");
        ((SimuCarouselClampLockSensor)carousel.getSocketAtStandby().getClampXminus().getLockSensor()).simulateClampIsLOCKED();
        ((SimuCarouselClampLockSensor)carousel.getSocketAtStandby().getClampXplus().getLockSensor()).simulateClampIsLOCKED();
        carousel.updateClampsStateWithSensors();
        Assert.assertTrue((String)"Clamps at STANDBY are LOCKED again.", (boolean)carousel.getSocketAtStandby().isClampedOnFilter());
    }

    @Test
    public void testClampSensors() {
        System.out.println("*** testClampSensors ***");
        try {
            carousel.unlockClamps();
            Assert.fail((String)"Filter is not held by fakeAutochanger. unlockClamps should raise an Exception.");
        }
        catch (FailedCommandException | RejectedCommandException ex) {
            System.out.println("Filter is not held by fakeAutochanger. Raised exception=" + ex);
        }
        plutoGateway.simulateAutochangerIsHoldingFilter();
        main.updateStateWithSensors();
        Assert.assertTrue((String)"carousel is still holding filter at STANDBY", (boolean)carousel.isHoldingFilterAtStandby());
        Assert.assertTrue((String)"filter is also held by autochanger", (boolean)carousel.isAutochangerHoldingFilter());
        carousel.unlockClamps();
        Assert.assertEquals((String)"socket at STANDBY is ", (Object)FcsEnumerations.FilterClampState.UNCLAMPEDONFILTER, (Object)carousel.getSocketAtStandby().getClampsState());
        for (int i = 2; i < 5; ++i) {
            String socketName = "socket" + i;
            Assert.assertEquals((String)"sockets else than socket1 are CLAMPEDONFILTER", (Object)FcsEnumerations.FilterClampState.CLAMPEDONFILTER, (Object)carousel.getSocketByName(socketName).getClampsState());
        }
        System.out.println("Go back to initial conditions");
        ((SimuCarouselClampLockSensor)carousel.getSocketAtStandby().getClampXminus().getLockSensor()).simulateClampIsLOCKED();
        ((SimuCarouselClampLockSensor)carousel.getSocketAtStandby().getClampXplus().getLockSensor()).simulateClampIsLOCKED();
        carousel.updateClampsStateWithSensors();
        Assert.assertTrue((String)"Clamps at STANDBY are LOCKED again.", (boolean)carousel.getSocketAtStandby().isClampedOnFilter());
    }

    @Test
    public void testIsHoldingFilter() throws FcsHardwareException {
        System.out.println("*** test of isHoldingFilterAtStandby ***");
        ((SimuCarouselClampLockSensor)carousel.getSocketAtStandby().getClampXminus().getLockSensor()).simulateClampIsUNLOCKED();
        ((SimuCarouselClampLockSensor)carousel.getSocketAtStandby().getClampXplus().getLockSensor()).simulateClampIsUNLOCKED();
        carousel.updateClampsStateWithSensors();
        Assert.assertFalse((String)"carousel is NOT holding a filter at STANDBY", (boolean)carousel.isHoldingFilterAtStandby());
        System.out.println("Go back to initial conditions");
        ((SimuCarouselClampLockSensor)carousel.getSocketAtStandby().getClampXminus().getLockSensor()).simulateClampIsLOCKED();
        ((SimuCarouselClampLockSensor)carousel.getSocketAtStandby().getClampXplus().getLockSensor()).simulateClampIsLOCKED();
        carousel.updateClampsStateWithSensors();
        Assert.assertTrue((String)"Clamps at STANDBY are LOCKED again.", (boolean)carousel.getSocketAtStandby().isClampedOnFilter());
    }

    @Test
    public void testCheckConditionForRotation() throws FcsHardwareException {
        System.out.println("*** test of checkConditionsForRotation");
        try {
            carousel.checkConditionsForRotation();
        }
        catch (FcsHardwareException | RejectedCommandException ex) {
            Assert.fail((String)("in initial conditions, rotation is allowed. No exception should be raised:" + ex));
        }
        System.out.println("Simulate clamps at STANDBY are UNLOCKED");
        ((SimuCarouselClampLockSensor)carousel.getSocketAtStandby().getClampXminus().getLockSensor()).simulateClampIsUNLOCKED();
        ((SimuCarouselClampLockSensor)carousel.getSocketAtStandby().getClampXplus().getLockSensor()).simulateClampIsUNLOCKED();
        carousel.updateClampsStateWithSensors();
        String msg = "Clamps are UNLOCKED but filter is still there.";
        Assert.assertTrue((String)msg, (boolean)carousel.getSocketAtStandby().isUnclampedOnFilter());
        try {
            carousel.checkConditionsForRotation();
            Assert.fail((String)(msg + " checkConditionsForRotation should raise an Exception."));
        }
        catch (FcsHardwareException | RejectedCommandException ex) {
            System.out.println("Carousel can't rotate because " + msg + ex);
        }
        System.out.println("Go back to initial conditions. simulate clamps at STANDBY are LOCKED");
        ((SimuCarouselClampLockSensor)carousel.getSocketAtStandby().getClampXminus().getLockSensor()).simulateClampIsLOCKED();
        ((SimuCarouselClampLockSensor)carousel.getSocketAtStandby().getClampXplus().getLockSensor()).simulateClampIsLOCKED();
        carousel.updateClampsStateWithSensors();
    }

    public void testHoming() {
        System.out.println("test homing of class CarouselModule");
        Assert.assertEquals((String)"carousel position is socket1 STANDBY position", (long)socket1StandbyPos, (long)carousel.getPosition());
        carousel.homing();
        carousel.updatePosition();
        Assert.assertEquals((String)"carousel position should not change with homing", (long)socket1StandbyPos, (long)carousel.getPosition());
        Assert.assertTrue((String)"homing is done", (boolean)carousel.isHomingDone());
    }

    @Test
    public void testRotateToRelativePosition() throws FcsHardwareException {
        System.out.println("*******************************************************************");
        System.out.println("test rotateToRelativePosition of class CarouselModule");
        System.out.println("*******************************************************************");
        int pos = this.randomGenerator.nextInt(Math.abs(carousel.getStepNB() / 2)) * carousel.getEncoderSign();
        int initialPosition = carousel.getPosition();
        int finalPosition = carousel.getPosition() + pos;
        System.out.println("testRotateToRelativePosition: rotate with relative position argument=" + pos);
        System.out.println("initial position=" + initialPosition);
        carousel.rotateToRelativePosition(pos);
        carousel.updatePosition();
        Assert.assertEquals((String)("test with pos=" + pos + " and initialPosition=" + initialPosition + " carousel position is " + finalPosition), (long)finalPosition, (long)carousel.getPosition());
    }

    @Test
    public void testRotateSocketToStandby() throws FcsHardwareException {
        System.out.println("rotateSocketToStandby");
        carousel.rotateSocketToStandby("socket2");
        Assert.assertEquals((String)"carousel position should be socket2 standbyPosition", (long)carousel.getSocketByName("socket2").getStandbyPosition(), (long)carousel.getPosition());
        Assert.assertEquals((String)"socket2 is now at STANDBY", (Object)"socket2", (Object)carousel.getSocketAtStandby().getName());
        carousel.rotateSocketToStandby("socket4");
        Assert.assertEquals((String)"socket4 is now at STANDBY", (Object)"socket4", (Object)carousel.getSocketAtStandby().getName());
        carousel.rotateSocketToStandby("socket3");
        Assert.assertEquals((String)"socket3 is now at STANDBY", (Object)"socket3", (Object)carousel.getSocketAtStandby().getName());
        carousel.rotateSocketToStandby("socket5");
        Assert.assertEquals((String)"socket5 is now at STANDBY", (Object)"socket5", (Object)carousel.getSocketAtStandby().getName());
        carousel.rotateSocketToStandby("socket1");
        Assert.assertEquals((String)"socket1 is now at STANDBY", (Object)"socket1", (Object)carousel.getSocketAtStandby().getName());
    }

    @Test
    public void testRotateSocketToStandbyWithRandomGenerator() throws FcsHardwareException {
        System.out.println("rotateSocketToStandby with randomGenerator");
        for (int i = 0; i < 10; ++i) {
            int socketNumber = this.randomGenerator.nextInt(5);
            String socketName = "socket" + socketNumber;
            System.out.println("rotateSocketToStandby(" + socketName + ")");
            if (socketNumber == 0) {
                try {
                    carousel.rotateSocketToStandby(socketName);
                    Assert.fail((String)"socket0 is an invalid socket name. Should raise an exception of type IllegalArgumentException");
                }
                catch (IllegalArgumentException ex) {
                    System.out.println("socket0 is an invalid socket name. Exception raised:" + ex);
                }
                continue;
            }
            carousel.rotateSocketToStandby(socketName);
            Assert.assertEquals((String)(socketName + " is now at STANDBY"), (Object)socketName, (Object)carousel.getSocketAtStandby().getName());
        }
    }

    @Test
    public void testRotateEmptySocketAtStandby() {
        System.out.println("rotateEmptySocketAtStandby");
        try {
            carousel.rotateEmptySocketAtStandby();
        }
        catch (FailedCommandException | FcsHardwareException | RejectedCommandException ex) {
            Assert.fail((String)("rotateEmptySocketAtStandby should do nothing but not raised an Exception:" + ex));
        }
    }

    @Test
    public void testComputeNewPosition() {
        System.out.println("###computeNewPosition");
        int pos = -43;
        Assert.assertEquals((String)("new position is " + pos), (long)pos, (long)carousel.computeNewPosition(pos));
        int compteur = 10;
        for (int n = 0; n < compteur; ++n) {
            pos = CarouselTest.carousel.encoderSign * this.randomGenerator.nextInt(carousel.getStepNB());
            Assert.assertEquals((String)("new position is " + pos), (long)pos, (long)carousel.computeNewPosition(pos));
        }
        pos = carousel.getStepNB();
        Assert.assertEquals((String)"new position is 0", (long)0L, (long)carousel.computeNewPosition(pos));
        pos = carousel.getEncoderSign() * (carousel.getStepNB() + 50);
        int newPos = carousel.getEncoderSign() * 50;
        Assert.assertEquals((String)("new position is " + newPos), (long)newPos, (long)carousel.computeNewPosition(pos));
    }

    @Test
    public void testComputeShortestRelativePosition() {
        System.out.println("###computeShortestRelativePosition");
        int d = (carousel.getStepNB() / 2 - 10) * carousel.getEncoderSign();
        Assert.assertEquals((String)"d is the shortestWay", (long)d, (long)carousel.computeShortestRelativePosition(d));
        d = (carousel.getStepNB() / 2 + 10) * carousel.getEncoderSign();
        int shortWay = 2181110;
        Assert.assertEquals((String)"d is the shortestWay", (long)shortWay, (long)carousel.computeShortestRelativePosition(d));
    }

    @Test
    public void testUpdatePosition() {
        System.out.println("test of updatePosition");
        int pos = this.randomGenerator.nextInt(Math.abs(carousel.getStepNB()));
        carouselController.setSsiPosition(pos);
        Assert.assertEquals((String)("carouselController position is " + pos), (long)pos, (long)carouselController.readPosition());
        carousel.updatePosition();
        Assert.assertEquals((String)("carousel position is " + pos), (long)pos, (long)carousel.getPosition());
    }

    @Test
    public void testWriteTargetPosition() throws FcsHardwareException {
        System.out.println("test of SimuCarouselController");
        int pos = this.randomGenerator.nextInt(Math.abs(carousel.getStepNB())) * carousel.getEncoderSign();
        System.out.println("testCarouselController: rotate to position " + pos);
        int initialPosition = carousel.getPosition();
        int finalPosition = carousel.getPosition() + pos;
        carouselController.writeTargetPosition(pos);
        carousel.updatePosition();
        Assert.assertEquals((String)("test with pos=" + pos + " and initialPosition=" + initialPosition + " carousel position is " + finalPosition), (long)finalPosition, (long)carousel.getPosition());
    }

    @Test
    public void testCheckFiltersLocation() {
        System.out.println("checkFiltersLocation");
        main.checkFiltersLocation();
        Assert.assertEquals((String)"filterU is on socket1", (Object)carousel.getSocketByName("socket1").getFilter(), (Object)filterU);
        Assert.assertEquals((String)"filterG is on socket2", (Object)carousel.getSocketByName("socket2").getFilter(), (Object)filterG);
        Assert.assertEquals((String)"filterR is on socket3", (Object)carousel.getSocketByName("socket3").getFilter(), (Object)filterR);
        Assert.assertEquals((String)"filterI is on socket4", (Object)carousel.getSocketByName("socket4").getFilter(), (Object)filterI);
        Assert.assertEquals((String)"filterZ is on socket5", (Object)carousel.getSocketByName("socket5").getFilter(), (Object)filterZ);
    }

    @Test
    public void testSaveFilterLocation() {
        System.out.println("saveFilterLocation");
        try {
            main.saveFilterLocation();
            ConfigurationState cs = (ConfigurationState)carouselSubsystem.getState(ConfigurationState.class);
            Assert.assertFalse((String)("ConfigurationState is no more dirty : " + cs), (boolean)cs.equals((Object)ConfigurationState.DIRTY));
        }
        catch (Exception ex) {
            Assert.fail((String)("saveFilterLocation should not raise Exception: " + ex));
        }
    }

    public void launchScript() throws Exception {
        System.out.println("************************************************");
        System.out.println("*** Launch Python SCRIPT carouselTest.py ***");
        System.out.println("************************************************");
        JythonScriptExecutorUtils.executeScript((String)"org/lsst/ccs/subsystems/fcs/scripts/carouselTest.py", (String[])new String[0]);
    }
}

