/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.subsystems.fcs.drivers.CommandDispenser;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenCallTimeoutException;

public class CommandDispenserTest
extends CcsTestCaseTemplate {
    private static CommandDispenser commandDispenser;
    private static String aCommand;
    private static String aToken;
    private static String aResponse;

    @BeforeClass
    public static void setUpClass() {
        System.out.println("***************************************");
        System.out.println("TESTS OF CommandDispenser");
        commandDispenser = new CommandDispenser();
        aCommand = "rsdo,2a,1004,30";
        aToken = "rsdo2a";
        aResponse = "rsdo,0,2a,23157";
        commandDispenser.register(aCommand);
    }

    @AfterClass
    public static void tearDownClass() {
        System.out.println("********* end of CommandDispenser tests *************");
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testRegister() {
        System.out.println("register");
        String command = "";
        try {
            commandDispenser.register(command);
            Assert.fail((String)"A command should not be null. An IllegalArgumentException should have been raised.");
        }
        catch (IllegalArgumentException ex) {
            System.out.println("null command:" + ex);
        }
        command = "toto,129";
        String expResult = "toto129";
        String result = commandDispenser.register(command);
        Assert.assertEquals((String)("Token for command" + command + " is " + result), (Object)expResult, (Object)result);
        Assert.assertTrue((String)"Token should be now in the map.", (boolean)commandDispenser.isTokenUsed(result));
        command = "rsdo,2F,1003,03";
        expResult = "rsdo2F";
        result = commandDispenser.register(command);
        Assert.assertEquals((String)("Token for command" + command + " is " + result), (Object)expResult, (Object)result);
        Assert.assertTrue((String)"Token should be now in the map.", (boolean)commandDispenser.isTokenUsed(result));
    }

    @Test
    public void testRegisterResponse() {
        System.out.println("registerResponse");
        String token = "rsdo2F";
        String response = "";
        try {
            commandDispenser.registerResponse(token, response);
            Assert.fail((String)"Response is null - an IllegalArgumentException should have been raised.");
        }
        catch (IllegalArgumentException ex) {
            System.out.println("Response is null:" + ex);
        }
        token = "bidon";
        try {
            commandDispenser.registerResponse(token, response);
            Assert.fail((String)"Invalid token - an IllegalArgumentException should have been raised.");
        }
        catch (IllegalArgumentException ex) {
            System.out.println("Invalid token:" + ex);
        }
        String expResult = aToken;
        String result = commandDispenser.registerResponse(aToken, aResponse);
        Assert.assertEquals((String)"registerResponse sends back the token.", (Object)expResult, (Object)result);
    }

    @Test
    public void testGetCommandResponse() throws CanOpenCallTimeoutException {
        System.out.println("getCommandResponse");
        long timeout = 10L;
        String result = commandDispenser.getCommandResponse(aToken, timeout);
        Assert.assertEquals((String)("Reponse to command " + aCommand + " must be " + aResponse), (Object)aResponse, (Object)result);
        String token = "tata2";
        commandDispenser.register("tata,2");
        timeout = 1L;
        try {
            commandDispenser.getCommandResponse(token, timeout);
            Assert.fail((String)("For token " + token + "a CanOpenCallTimeoutException shoul be raised."));
        }
        catch (CanOpenCallTimeoutException ex) {
            System.out.println("No response was received for command:tata,2 " + (Object)((Object)ex));
        }
    }

    @Test
    public void testRemove() {
        System.out.println("remove");
        String token = commandDispenser.register("wsdo,2a,1004,30,4");
        Assert.assertTrue((String)"Token is used:", (boolean)commandDispenser.isTokenUsed(token));
        commandDispenser.remove(token);
        Assert.assertFalse((String)"Token has been removed", (boolean)commandDispenser.isTokenUsed(token));
    }

    @Test
    public void testIsTokenUsed() {
        System.out.println("isTokenUsed");
        Assert.assertTrue((String)("Token used:" + aToken), (boolean)commandDispenser.isTokenUsed(aToken));
        String token = "j4415";
        Assert.assertFalse((String)("Token non used:" + token), (boolean)commandDispenser.isTokenUsed(token));
    }
}

