/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.common;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.subsystems.fcs.common.PDOStorage;
import org.lsst.ccs.subsystems.fcs.utils.CWrapperUtils;

public class PDOStorageTest
extends CcsTestCaseTemplate {
    @BeforeClass
    public static void setUpClass() {
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testUpdatePDOs() {
        System.out.println("updatePDOs");
        String pdoLine = "v24_1=10,v24_2=F53B,v24_3=F53B,v24_4=0000,v24_5=981,v24_6=01,v24_7=FFFF,v24_8=0";
        PDOStorage pdoStorage = new PDOStorage();
        Assert.assertNotNull((String)"instance PDOStorage is created", (Object)pdoStorage);
        pdoStorage.merge(CWrapperUtils.createPDOData((String)pdoLine));
        Assert.assertNotNull((String)"instance PDOStorage is updated", (Object)pdoStorage);
    }

    @Test
    public void testGetVarValue() {
        System.out.println("getVarValue");
        String pdoLine = "v24_1=10,v24_2=F53B,v24_3=7777,v24_4=0000,v24_5=981,v24_6=0F,v24_7=FFFF,v24_8=0";
        PDOStorage instance = new PDOStorage();
        Assert.assertNotNull((String)"instance PDOStorage is created", (Object)instance);
        instance.merge(CWrapperUtils.createPDOData((String)pdoLine));
        Assert.assertNotNull((String)"instance PDOStorage is updated", (Object)instance);
        System.out.println(instance.toString());
        int nodeID = 36;
        int inputNB = 1;
        int result = (int)instance.getVarValue(nodeID, inputNB);
        Assert.assertEquals((String)("nodeID=" + nodeID + ",inputNB=" + inputNB), (long)16L, (long)result);
        inputNB = 2;
        result = (int)instance.getVarValue(nodeID, inputNB);
        Assert.assertEquals((String)("nodeID=" + nodeID + ",inputNB=" + inputNB), (long)62779L, (long)result);
        inputNB = 3;
        result = (int)instance.getVarValue(nodeID, inputNB);
        Assert.assertEquals((String)("nodeID=" + nodeID + ",inputNB=" + inputNB), (long)30583L, (long)result);
        inputNB = 4;
        result = (int)instance.getVarValue(nodeID, inputNB);
        Assert.assertEquals((String)("nodeID=" + nodeID + ",inputNB=" + inputNB), (long)0L, (long)result);
        inputNB = 5;
        result = (int)instance.getVarValue(nodeID, inputNB);
        Assert.assertEquals((String)("nodeID=" + nodeID + ",inputNB=" + inputNB), (long)2433L, (long)result);
        inputNB = 6;
        result = (int)instance.getVarValue(nodeID, inputNB);
        Assert.assertEquals((String)("nodeID=" + nodeID + ",inputNB=" + inputNB), (long)15L, (long)result);
        inputNB = 7;
        result = (int)instance.getVarValue(nodeID, inputNB);
        Assert.assertEquals((String)("nodeID=" + nodeID + ",inputNB=" + inputNB), (long)65535L, (long)result);
        inputNB = 8;
        result = (int)instance.getVarValue(nodeID, inputNB);
        Assert.assertEquals((String)("nodeID=" + nodeID + ",inputNB=" + inputNB), (long)0L, (long)result);
    }

    @Test
    public void testToString() {
        System.out.println("toString");
        PDOStorage instance = new PDOStorage();
        String expResult = "PDO STORAGE:(SIZE=0){}";
        String result = instance.toString();
        Assert.assertEquals((String)"A PDO storage with no PDO updated should have a size=0", (Object)expResult, (Object)result);
    }
}

