/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.framework.Signal;
import org.lsst.ccs.framework.SignalLevel;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.scripting.CCS;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.Utils;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;

public class MainModuleTest
extends CcsTestCaseTemplate {
    private static MainModule main;
    private static Subsystem subs;
    private static ComponentLookup lookup;
    private static BridgeToHardware bridge;

    @BeforeClass
    public static void before() throws Exception {
        System.out.println("***************************************");
        System.out.println("         TESTS OF MainModule");
        System.out.println("***************************************");
        CCS.initializeScriptingEnvironment();
        subs = BootUtils.getSubsystemFromFile((String)"testMainModule");
        subs.startAgent();
        subs.waitFor(state -> state.isInState((Enum)PhaseState.OPERATIONAL), 60L, TimeUnit.SECONDS);
        lookup = subs.getComponentLookup();
        main = (MainModule)lookup.getComponentByName("main");
        bridge = (BridgeToHardware)lookup.getComponentByName("tcpProxy");
    }

    @AfterClass
    public static void after() throws Exception {
        System.out.println("*******************************************************************");
        System.out.println("********* end of TESTS OF MainModule                  *************");
        System.out.println("*******************************************************************");
        subs.shutdown();
        subs.waitFor(state -> state.isInState((Enum)PhaseState.OFF_LINE), 30L, TimeUnit.SECONDS);
        CCS.shutdownScriptingEnvironment();
    }

    @Before
    public void setUp() {
        Utils.printJoliSetUp("MainModuleTest");
        Assert.assertTrue((String)"subsystem is in OPERATIONAL state", (boolean)subs.isInState((Enum)PhaseState.OPERATIONAL));
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testGetHaltRequired() {
        System.out.println("*****getHaltRequired");
        boolean result = main.isHaltRequired();
        Assert.assertFalse((String)"Halt has not been required", (boolean)result);
        subs.abort();
        Assert.assertTrue((String)"HALT has been required", (boolean)main.isHaltRequired());
    }

    @Test
    public void testGetStopRequired() throws Exception {
        System.out.println("*****getStopRequired");
        boolean result = main.isStopRequired();
        Assert.assertFalse((String)"Stop has not been required", (boolean)result);
        subs.stop(10L);
        Assert.assertTrue((String)"Stop has been required", (boolean)main.isStopRequired());
    }

    @Test
    public void testIsCANDevicesReady() {
        System.out.println("*****isCANDevicesReady");
        Assert.assertTrue((String)"in simulation hardware is always ready", (boolean)main.allDevicesBooted());
    }

    @Test
    public void testListHardwareNames() {
        System.out.println("*****listHardwareNames");
        List expResult = bridge.listHardwareNames();
        List result = main.listHardwareNames();
        Assert.assertEquals((String)"hardware list is bridge's hardware list", (Object)expResult, (Object)result);
    }

    @Test
    public void testListLoaderHardwareNames() {
        System.out.println("*****listLoaderHardwareNames");
        List expResult = Collections.emptyList();
        List result = main.listLoaderHardwareNames();
        Assert.assertEquals((String)"loader hardware list is empty", expResult, (Object)result);
    }

    @Test
    public void testGetFilterNames() {
        System.out.println("*****getFilterNames");
        List expResult = Collections.emptyList();
        List result = main.getFilterNames();
        Assert.assertEquals((String)"filter list is empty", expResult, (Object)result);
    }

    @Test
    public void testUpdateFCSState() {
        System.out.println("*****updateFCSState");
        main.updateFCSStateToReady();
        Assert.assertTrue((String)"FilterState should be HARDWARE_READY", (boolean)subs.isInState((Enum)FcsEnumerations.FilterState.HARDWARE_READY));
        Assert.assertTrue((String)"FilterReadinessState should be READY", (boolean)subs.isInState((Enum)FcsEnumerations.FilterReadinessState.READY));
    }

    @Test
    public void testSignal() {
        System.out.println("*****signal");
        Signal signal = new Signal(SignalLevel.HALT);
        main.signal(signal);
        Assert.assertTrue((String)"Halt signal has been received", (boolean)main.isHaltRequired());
        main.signal(new Signal(SignalLevel.STOP));
        Assert.assertTrue((String)"Stop signal has been received", (boolean)main.isStopRequired());
        main.signal(new Signal(SignalLevel.RE_START));
        Assert.assertFalse((String)"Subsystem can restart", (boolean)main.isHaltRequired());
        Assert.assertFalse((String)"Subsystem can restart", (boolean)main.isStopRequired());
    }
}

