package org.lsst.ccs.subsystems.fcs.utils;

import org.lsst.ccs.drivers.canopenjni.PDOData;
import static org.lsst.ccs.subsystems.fcs.FCSCst.FCSLOG;

/**
 *
 * @author Utilities for intarcting with canopen through the CWrapper
 *
 */
public class CWrapperUtils {
    
    private CWrapperUtils() {
        
    }
    
    private static final String[] CAN_OPEN_COMMANDS
            = new String[] {"sync", "scan", "rsdo", "wsdo", "info", "quit", "srtr", "reset"};
    
    private static final String SEP = "_";
    /* For single-filter-test :*/
//    private static final String VAR_SUFFIXE = "ADC";
    
    /* For autochanger tests*/
    private static final String VAR_SUFFIXE = "v";

    
    /**
     * build a Can Open wsdo Command that can understand the C wrapper.
     * exemple : wsdo,2,6411,01,2,3000
     * @param nodeID
     * @param index
     * @param subindex
     * @param size
     * @param data
     * @return
     */
    public static String buildWsdoCommand(int nodeID, int index, int subindex, int size, long data) {
        char sep = ',';
        StringBuilder sb = new StringBuilder("wsdo").append(sep);
        sb.append(Integer.toHexString(nodeID)).append(sep);
        sb.append(Integer.toHexString(index)).append(sep);
        sb.append(Integer.toHexString(subindex)).append(sep);
        sb.append(Integer.toHexString(size)).append(sep);
        sb.append(Integer.toHexString((int)data));
        return sb.toString();
    }
    
    /**
     * build a Can Open rsdo Command that can understand the C wrapper. exemple
     * : rsdo,1,1018,0
     * @param nodeID
     * @param index
     * @param subindex
     * @return
     */
    public static String buildRsdoCommand(int nodeID, int index, int subindex) {
        char sep = ',';
        StringBuilder sb = new StringBuilder("rsdo").append(sep);
        sb.append(Integer.toHexString(nodeID)).append(sep);
        sb.append(Integer.toHexString(index)).append(sep);
        sb.append(Integer.toHexString(subindex));
        return sb.toString();
    }
    
    /**
     * returns true if the command given as argument is an available CANopen command.
     * @param command
     * @return
     */
    public static boolean isValidCommandWord(String command) {
        for(String s: CAN_OPEN_COMMANDS){
            if(s.equals(command))
                return true;
        }
        return false;
    }
    
    /**
     * @param command
     * @throws IllegalArgumentException if command is not a valid command.
     */
    public static void checkCommand(String command) {
        if (command == null) throw new IllegalArgumentException(" null command");
        String[] words = command.split(",");
        if (words.length == 0 || !isValidCommandWord(words[0]))  {
            throw new IllegalArgumentException(command+" invalid command");
        }
    }
    
    /**
     * Creates a PDOData.
     *
     * @param pdoLine something like : "ADC1_1=10,ADC1_2=F53B, ...."
     * @return 
     */
    public static PDOData createPDOData(String pdoLine) {
        PDOData d = new PDOData();
        FCSLOG.finest(": pdoLine=" + pdoLine);
        String[] words = pdoLine.split(",");
        FCSLOG.finest(": words.length=" + words.length);
        //for single-filter-test
//        for (int ix = 1; ix < words.length; ix++) {

        for (int ix = 0; ix < words.length; ix++) {
            //example toStore= ADC1_1=10
            FCSLOG.finest("ix=" + ix + "words[ix]=" + words[ix]);
            String[] toStore = words[ix].split("=");
            //example varName= ADC1_1
            String[] varName = toStore[0].substring(VAR_SUFFIXE.length()).split(SEP);
            FCSLOG.finest("varName=" + varName);
            int nodeID = Integer.parseInt(varName[0],16);
            int inputNB = Integer.parseInt(varName[1]);
            int varValue = Integer.parseInt(toStore[1],16);
            FCSLOG.finest(String.format("%nwords(%s):%s nodeID=%s", ix, words[ix], nodeID));
            d.updatePDO(nodeID+inputNB, varValue);
        }
        return d;
    }
}
