/*
 * To change this template, choose Tools | Templates
 * and on the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupField.Strategy;
import org.lsst.ccs.subsystems.fcs.CarouselClamp;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCarouselClampFilterPresenceSensor;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCarouselClampLockSensor;
import static org.lsst.ccs.subsystems.fcs.FCSCst.FCSLOG;

/**
 * To simulate a motor which moves a truck in the autochanger.
 *
 * @author virieux
 */
public class SimuTruckMotor extends SftTruckMotor {

    @LookupField(strategy = Strategy.BYNAME)
    private SftAutoChanger autochanger;
    @LookupField(strategy = Strategy.BYNAME)
    private CarouselClamp clampXminus;
    @LookupField(strategy = Strategy.BYNAME)
    private CarouselClamp clampXplus;    
    
    @Override
    public String moveToStandback()  {

        if (autochanger.isAtStandby()) {

            this.setMovingToStandback(true);
            long timeToGo = autochanger.getTimeToGoToStandback()/10;
            try {
                FCSLOG.debug(name + ": Waiting for the motor to go to STANDBACK");
                Thread.sleep(timeToGo);
            } catch (InterruptedException ex) {
                FCSLOG.debug(ex);
            }

            this.setMovingToStandback(false);

            // The simulated rails sensors have to say that the trucks are in standback.
            SimuCompactIO simuRailsSensors = (SimuCompactIO) autochanger.getRailsSensorsDIO();
            simuRailsSensors.setHexaValue(0x50);

            //The simulated filter sensors have to say if the filter is in the latches or not.
            SimuCompactIO simuFilterSensors = (SimuCompactIO) autochanger.getFilterSensorsDIO();
            if (autochanger.isTrucksEmpty()) {
                //if the trucks are empty, the filter is at standby on  carousel, so when the trucks are in
                //standback position, the latches filter presence sensor have to return the value "0".
                simuFilterSensors.simulateFilterPresenceInLatches(0);

            } else {
                //if the trucks are loaded and going to standback, at the end of the simulated motion, 
                //the clamp filter presence sensors should "see" that there NO_FILTER anymore.
                ((SimuCarouselClampFilterPresenceSensor) this.clampXminus.getFilterPresenceSensor()).simulateNoFilter();
                ((SimuCarouselClampFilterPresenceSensor) this.clampXplus.getFilterPresenceSensor()).simulateNoFilter();
                FCSLOG.debug("====> END OF moveToStandback");
            }
        }

        return "Trucks are At Standback.";

    }

    /**
     * The method moveToStandby for the simulated trucks motor updates the rails
     * sensors and the filter presence sensor in the latches.
     *
     * @return
     * @throws org.lsst.ccs.subsystems.fcs.errors.CanOpenException
     */
    @Override
    public String moveToStandby()  {

        if (autochanger.isAtStandback()) {

            this.setMovingToStandby(true);
            long timeToGo = autochanger.getTimeToGoToStandby();
            try {
                FCSLOG.debug(name + ": Waiting for the motor to go to STANDBY");
                Thread.sleep(timeToGo);
            } catch (InterruptedException ex) {
                FCSLOG.debug(ex);
            }

            this.setMovingToStandby(false);

            SimuCompactIO simuRailsSensor = (SimuCompactIO) autochanger.getRailsSensorsDIO();
            //TODO SimuCompactIO should provide a more generic method to simulate the rails sensors.
            simuRailsSensor.setHexaValue(0xA0);

            //The simulated filter sensors have to say if the filter is in the latches or not.
            SimuCompactIO simuFilterSensors = (SimuCompactIO) autochanger.getFilterSensorsDIO();

            //The simulated filter sensors have to say if the filter is in the latches or not.
            if (autochanger.isTrucksEmpty()) {
                //if the trucks are empty, the filter is at standby on  carousel, so at the end of the 
                //moveToStandby command, the latches filter presence sensor have to return the value "1".
                simuFilterSensors.simulateFilterPresenceInLatches(1);
            } else {

                //if the trucks are loaded and going to standby, at the end of the simulated motion, 
                //the clamps filter presence sensors should "see" that the filter is LOCKABLE.
                //and the lock sensor should see that the clamps are LOCKED.
                ((SimuCarouselClampFilterPresenceSensor) this.clampXminus.getFilterPresenceSensor()).simulateFilterIsLockable();
                ((SimuCarouselClampFilterPresenceSensor) this.clampXplus.getFilterPresenceSensor()).simulateFilterIsLockable();
                ((SimuCarouselClampLockSensor) this.clampXminus.getLockSensor()).simulateClampIsLOCKED();
                ((SimuCarouselClampLockSensor) this.clampXplus.getLockSensor()).simulateClampIsLOCKED();
            }
        }
        return "Trucks are At Standby.";
    }

    @Override
    public String off()  {
        this.setMovingToStandback(false);
        this.setMovingToStandby(false);
        return "Trucks motor is OFF";
    }

}
