/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.ArrayList;
import java.util.List;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupField.Strategy;
import org.lsst.ccs.drivers.canopenjni.BootMessageListener;
import org.lsst.ccs.drivers.canopenjni.CanOpenInterface;
import org.lsst.ccs.drivers.canopenjni.EmergencyMessageListener;
import org.lsst.ccs.drivers.canopenjni.PDOData;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;

/**
 *
 * @author emarin
 */
public class SimuTcpProxy implements CanOpenInterface {
    
    @LookupField(strategy=Strategy.SIBLINGS)
    private final List<PieceOfHardware> devices = new ArrayList<>();

    @Override
    public void init(int master, String baud, String busName, int nodeID) {

    }

    @Override
    public PDOData sync() throws DriverException {
        return new PDOData();
    }

    @Override
    public int scan() {
        return 0;
    }

    @Override
    public String info(int nodeID) throws DriverException {
        
        // Finding the device serial number
        for(PieceOfHardware poh : devices) {
            if(nodeID == poh.getNodeID()) {
                return "info,"+Integer.toHexString(nodeID)+",,,,,"+poh.getSerialNB();
            }
        }
        return null;
    }

    @Override
    public void wsdo(int nodeId, int index, int subindex, int size, long data) throws DriverException {

    }

    @Override
    public long rsdo(int nodeId, int index, int subindex) throws DriverException {
        return 0L;
    }

    @Override
    public void ssta(int nodeId) {

    }

    @Override
    public void ssto(int nodeId) {

    }

    @Override
    public void reset(int nodeId) {

    }

    @Override
    public void quit() {

    }

    @Override
    public void init() {

    }

    @Override
    public void start() {

    }

    @Override
    public void stop() {

    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public void addReceivedPDO(int cobId) throws DriverException {

    }

    @Override
    public void setEmergencyMessageListener(EmergencyMessageListener eml) throws DriverException {
        // unconfigured
    }

    @Override
    public void setBootMessageListener(BootMessageListener bml) throws DriverException {
        // unconfigured
    }
    
}
