
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.subsystems.fcs.drivers.CanOpenADC;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;

/**
 * To simulate a CanOpenADC.
 * Used in Carousel simulation.
 * @author virieux
 */
public class SimuCanOpenADC extends CanOpenADC {

    /**
     * build a new SimuCanOpenADC
     * @param nodeID
     * @param serialNB
     * @param transmissionType 
     */
    public SimuCanOpenADC(int nodeID, String serialNB, int transmissionType) {
        super(nodeID, serialNB, transmissionType);
    }
    
    /**
     * Write transmission type on the device CPU.
     * @return
     * @throws FcsHardwareException 
     */
    @Override
    protected String writeTransmissionTypeToDevice()  {
        return getName()+" is initialized.";
    }
    
}
