
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.subsystems.fcs.DigitalSensor;

/**
 * In the autochanger-standalone subsystem, there are 2 electric switchs to simulate that 
 * carousel is holding a filter at STANDBY or loader is holding a filter at HANDOFF.
 * 
 * This switchs are connected to sensors which sends value 0 when not holding filter or 1 when holding filter.
 * 
 * For FCS with real hardware this sensors are read like the other sensors from the plutoGateway.
 * For FCS with simulated hardware we have to add these sensors in plutoGateway to be able to simulate 
 * founctionalities of the switches (isHolding filter or not).
 *
 * @author virieux
 */
public class SimuAutochangerStandalonePlutoGateway extends SimuAutochangerPlutoGateway {
    
    private DigitalSensor carouselHoldingFilterSensor0;
    private DigitalSensor carouselHoldingFilterSensor1;
    
    private DigitalSensor loaderHoldingFilterSensor0;
    private DigitalSensor loaderHoldingFilterSensor1;

    /**
     * 
     * @param nodeID
     * @param serialNB 
     */
    public SimuAutochangerStandalonePlutoGateway(int nodeID, String serialNB) {
        super(nodeID, serialNB);
    }
    
    @Override
    public void init() {
        super.init();
        ComponentLookup lookup = s.getComponentLookup();
        this.carouselHoldingFilterSensor0 = (DigitalSensor)lookup.getComponentByName("carouselHoldingFilterSensor0");
        this.carouselHoldingFilterSensor1 = (DigitalSensor)lookup.getComponentByName("carouselHoldingFilterSensor1");
        simulateCarouselIsNotHoldingFilter();
        this.loaderHoldingFilterSensor0 = (DigitalSensor)lookup.getComponentByName("loaderHoldingFilterSensor0");
        this.loaderHoldingFilterSensor1 = (DigitalSensor)lookup.getComponentByName("loaderHoldingFilterSensor1");
        simulateLoaderIsNotHoldingFilter();
    }

    
    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateCarouselIsHoldingFilter() {
        replaceHexaValues(carouselHoldingFilterSensor0, true);
        replaceHexaValues(carouselHoldingFilterSensor1, false);
        /* carousel and loader can't both hold filter*/
        simulateLoaderIsNotHoldingFilter();
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateCarouselIsNotHoldingFilter() {
        replaceHexaValues(carouselHoldingFilterSensor0, false);
        replaceHexaValues(carouselHoldingFilterSensor1, true);
    }
    
    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateLoaderIsHoldingFilter() {
        this.simulateLoaderIsConnected();
        replaceHexaValues(loaderHoldingFilterSensor0, true);
        replaceHexaValues(loaderHoldingFilterSensor1, false);
        /* carousel and loader can't both hold filter*/
        simulateCarouselIsNotHoldingFilter();
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateLoaderIsNotHoldingFilter() {
        replaceHexaValues(loaderHoldingFilterSensor0, false);
        replaceHexaValues(loaderHoldingFilterSensor1, true);
    }

}
