package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.subsystems.fcs.common.EmergencyMessage;

/**
 * Interface for can devices that handle emergency messages.
 * @author emarin
 */
public interface EmergencyMessageListener {
    
    /**
     * Callback when an emergency message is received.
     * @param em 
     */
    public void onEmergencyMessage(EmergencyMessage em);
    
    
    public default void onFaultReset() {
        
    }
    
    public default void onFault() {
        
    }
    
}
