
package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupField.Strategy;
import org.lsst.ccs.subsystems.fcs.common.FilterHolder;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;

/**
 * This class is the Main Module when autochanger is in standalone mode.
 *
 * @author virieux
 */
public class AutochangerMain extends MainModule {

    @LookupField(strategy=Strategy.CHILDREN)
    private Autochanger autochanger;

    private FilterHolder carousel;
    private FilterHolder loader;
    

    /**
     * Build a AutochangerMainModule.
     * @param bridge
     */
    public AutochangerMain(
            BridgeToHardware bridge) {
        super(bridge);
    }
    
    /**
     * Update autochanger state in reading the sensors.
     * @throws FcsHardwareException 
     */
    @Command(type = Command.CommandType.QUERY, level = Command.NORMAL,
            description = "Update autochanger state in reading the sensors.")
    @Override
    public void updateStateWithSensors() {
        super.updateStateWithSensors();
        autochanger.updateStateWithSensors();
        carousel.updateStateWithSensors();
        loader.updateStateWithSensors();
    }

    /**
     * Check that Autochanger hardware is ready to be operated and moved.
     * This means that :
     * - all CAN open devices are booted, identified and initialized,
     * - homing has been done on the controllers.
     * This updates the FCS state and FCS readyness state and publishes on the status bus.
     * 
     */
    @Command(type = Command.CommandType.ACTION, level = Command.ENGINEERING1, 
            description = "Update FCS state and FCS readyness state and publishes on the status bus.")
    @Override
    public void updateFCSStateToReady() {
        if (autochanger.isInitialized() && !s.isInState(AlertState.ALARM)) {
            /* The initialization has been done, so now the hardware is ready */
            s.updateAgentState(FcsEnumerations.FilterState.HARDWARE_READY, 
                FcsEnumerations.FilterReadinessState.READY);
        }
    }
    


}
