/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.utils;

import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.utilities.logging.Logger;

public final class FcsUtils {
    protected static final Logger FCSLOG = FCSCst.FCSLOG;
    public static final int MAX_VALUE_2BYTES = 65535;
    public static final int MAX_NODE_ID = 127;
    public static final int TICKMILLIS = 3000;
    private static final String SOCKET_NAME = "socket";
    private static final String[] CAN_OPEN_COMMANDS = new String[]{"sync", "scan", "rsdo", "wsdo", "info", "quit", "srtr", "reset"};

    public static void checkSocketName(String name) {
        String errorMsg = ": invalid socket name - Socket name must be \"socketX\" where 0 <= X <= 5";
        if (name.isEmpty() || name.contentEquals("AC")) {
            return;
        }
        if (!name.startsWith(SOCKET_NAME)) {
            throw new IllegalArgumentException(name + errorMsg);
        }
        String end = name.substring(6);
        try {
            int ix = Integer.parseInt(end);
            if (ix < 1 || ix > 5) {
                throw new IllegalArgumentException(name + errorMsg);
            }
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException(name + errorMsg, ex);
        }
    }

    public static String twoBytesInHexaToBinary(String twoBytesInHexa) {
        int integer = Integer.parseInt(twoBytesInHexa, 16);
        String bin = Integer.toBinaryString(integer);
        return String.format("%016d", Long.parseLong(bin));
    }

    public static int force2zero(int hexaVal, int bit) {
        if (bit < 0 || bit > 15) {
            throw new IllegalArgumentException(String.format("bad value for bit=%s - must be : >0 and <15", bit));
        }
        return hexaVal & ~(1 << bit);
    }

    public static int force2one(int hexaVal, int bit) {
        if (bit < 0 || bit > 15) {
            throw new IllegalArgumentException(String.format("bad value for bit=%s - must be : >0 and <15", bit));
        }
        return hexaVal | 1 << bit;
    }

    public static int forceBit(int val, int bit, int zeroOne) {
        if (zeroOne == 0) {
            return FcsUtils.force2zero(val, bit);
        }
        return FcsUtils.force2one(val, bit);
    }

    public static int[] toReverseBinary(int decimal) {
        int[] tab = new int[16];
        for (int i = 0; i < 16; ++i) {
            int bit;
            tab[i] = bit = decimal >> i & 1;
        }
        return tab;
    }

    public static String buildWsdoCommand(int nodeID, int index, int subindex, int size, int data) {
        char sep = ',';
        StringBuilder sb = new StringBuilder("wsdo").append(sep);
        sb.append(Integer.toHexString(nodeID)).append(sep);
        sb.append(Integer.toHexString(index)).append(sep);
        sb.append(Integer.toHexString(subindex)).append(sep);
        sb.append(Integer.toHexString(size)).append(sep);
        sb.append(Integer.toHexString(data));
        return sb.toString();
    }

    public static String buildRsdoCommand(int nodeID, int index, int subindex) {
        char sep = ',';
        StringBuilder sb = new StringBuilder("rsdo").append(sep);
        sb.append(Integer.toHexString(nodeID)).append(sep);
        sb.append(Integer.toHexString(index)).append(sep);
        sb.append(Integer.toHexString(subindex));
        return sb.toString();
    }

    public static boolean isValidCommandWord(String command) {
        for (String s : CAN_OPEN_COMMANDS) {
            if (!s.equals(command)) continue;
            return true;
        }
        return false;
    }

    public static void checkCommand(String command) {
        if (command == null) {
            throw new IllegalArgumentException(" null command");
        }
        String[] words = command.split(",");
        if (words.length == 0 || !FcsUtils.isValidCommandWord(words[0])) {
            throw new IllegalArgumentException(command + " invalid command");
        }
    }

    public static byte convertToInteger8(long unsigned8) {
        if ((double)unsigned8 >= Math.pow(2.0, 8.0)) {
            throw new IllegalArgumentException(unsigned8 + " too big. Should be coded on 8 bits, so < Math.pow(2,8)");
        }
        return (byte)unsigned8;
    }

    public static short convertToInteger16(long unsigned16) {
        if ((double)unsigned16 >= Math.pow(2.0, 16.0)) {
            throw new IllegalArgumentException(unsigned16 + " too big. Should be coded on 16 bits, so < Math.pow(2,16)");
        }
        return (short)unsigned16;
    }

    public static int convertToInteger32(long unsigned32) {
        if ((double)unsigned32 >= Math.pow(2.0, 32.0)) {
            throw new IllegalArgumentException(unsigned32 + " too big. Should be coded on 32 bits, so < Math.pow(2,32)");
        }
        return (int)unsigned32;
    }

    public static String displayListParameters(String modeInString) {
        EPOSEnumerations.Parameter[] params;
        StringBuilder sb = new StringBuilder("List of parameters for mode: ");
        sb.append(modeInString);
        sb.append("\n");
        for (EPOSEnumerations.Parameter param : params = EPOSEnumerations.EposMode.valueOf(modeInString).getParameters()) {
            sb.append(param.display());
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String displayListParameters() {
        EPOSEnumerations.Parameter[] params;
        StringBuilder sb = new StringBuilder("List of parameters : ");
        sb.append("\n");
        for (EPOSEnumerations.Parameter param : params = EPOSEnumerations.Parameter.values()) {
            sb.append(param.display());
            sb.append("\n");
        }
        return sb.toString();
    }

    public static int getSignedStepHeight(int initialValue, int finalValue, int increment) {
        if (finalValue - initialValue > 0) {
            return increment;
        }
        return -increment;
    }

    public static void main(String[] args) {
        System.out.println(FcsUtils.displayListParameters("HOMING"));
        System.out.println(FcsUtils.displayListParameters("CURRENT"));
        System.out.println(FcsUtils.displayListParameters("PROFILE_POSITION"));
        System.out.println(FcsUtils.displayListParameters());
    }

    public static boolean finalValueReached(int stepHeight, int newCurrentValue, int finalValue) {
        boolean goingUp = stepHeight > 0 && newCurrentValue > finalValue;
        boolean goingDown = stepHeight < 0 && newCurrentValue < finalValue;
        return goingUp || goingDown;
    }

    public static void sleep(int duration, String itemName) {
        try {
            FCSLOG.finest((Object)(itemName + " BEGIN SLEEP for " + duration + " milliseconds"));
            Thread.sleep(duration);
            FCSLOG.finest((Object)(itemName + " END SLEEP for " + duration + " milliseconds"));
        }
        catch (InterruptedException ex) {
            String msg = itemName + " interrupted while sleeping";
            FCSLOG.error((Object)(itemName + msg), (Throwable)ex);
        }
    }

    public static void checkPositive(int arg) {
        if (arg < 0) {
            throw new IllegalArgumentException(arg + ":illegal value. Must be > 0");
        }
    }
}

