/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import java.io.Serializable;
import java.time.Duration;
import java.util.concurrent.locks.Condition;
import java.util.logging.Level;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.subsystems.fcs.Carousel;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByBasicAutoChanger;
import org.lsst.ccs.subsystems.fcs.common.FilterHolder;
import org.lsst.ccs.subsystems.fcs.common.MobileItem;
import org.lsst.ccs.subsystems.fcs.common.ModuleState;
import org.lsst.ccs.subsystems.fcs.errors.ClampsOrLatchesDisagreeException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.CompactIO;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftFilterLatch;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftTruckMotor;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftUtils;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.Truck;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.TruckMotorListener;

public abstract class BasicAutoChanger
extends MobileItem
implements FilterHolder,
TruckMotorListener {
    @LookupField(strategy=LookupField.Strategy.TREE)
    private MainModule mainModule;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @ConfigurationParameter(description="The name of the DIO where the rails sensors are plugged.")
    private String railsSensorsDIOName;
    @ConfigurationParameter(description="The name of the DIO where the filter sensors are plugged.")
    private String filterSensorsDIOName;
    private boolean trucksEmpty;
    private Filter filterOnTrucks;
    @LookupField(strategy=LookupField.Strategy.BYNAME)
    protected Carousel carousel;
    private FcsEnumerations.AutoChangerTrucksLocation trucksLocation = FcsEnumerations.AutoChangerTrucksLocation.UNKNOWN;
    private final SftFilterLatch latchXminus;
    private final SftFilterLatch latchXplus;
    protected Truck truckXminus;
    protected Truck truckXplus;
    private CompactIO railsSensorsDIO;
    private CompactIO filterSensorsDIO;
    public static final String publishedByAutoChangerOutputName = "publishedByAutoChanger";
    protected volatile ModuleState state = ModuleState.HALTED;
    private volatile FcsEnumerations.FilterPresenceStatus presenceStatus;
    protected volatile FcsEnumerations.LockStatus latchesState = FcsEnumerations.LockStatus.UNKNOWN;
    protected volatile boolean updatingLatches = false;
    protected volatile boolean closingLatches = false;
    protected volatile boolean openingLatches = false;
    private volatile boolean updatingTrucksLocation = false;
    private final Condition stateUpdated = this.lock.newCondition();
    private final Condition trucksLocationUpdated = this.lock.newCondition();
    protected long timeoutForOpeningLatches;
    protected long timeoutForClosingLatches;

    public BasicAutoChanger(SftFilterLatch latchXminus, SftFilterLatch latchXplus, Truck truckXminus, Truck truckXplus, String railsSensorsDIOName, String filterSensorsDIOName) {
        this.latchXminus = latchXminus;
        this.latchXplus = latchXplus;
        this.truckXminus = truckXminus;
        this.truckXplus = truckXplus;
        this.railsSensorsDIOName = railsSensorsDIOName;
        this.filterSensorsDIOName = filterSensorsDIOName;
    }

    public CompactIO getRailsSensorsDIO() {
        return this.railsSensorsDIO;
    }

    public CompactIO getFilterSensorsDIO() {
        return this.filterSensorsDIO;
    }

    public Filter getFilterOnTrucks() {
        return this.filterOnTrucks;
    }

    public ModuleState getState() {
        return this.state;
    }

    public void setState(ModuleState state) {
        this.state = state;
    }

    public SftFilterLatch getLatchXminus() {
        return this.latchXminus;
    }

    public SftFilterLatch getLatchXplus() {
        return this.latchXplus;
    }

    public Truck getTruckXminus() {
        return this.truckXminus;
    }

    public Truck getTruckXplus() {
        return this.truckXplus;
    }

    public boolean isTrucksEmpty() {
        return this.trucksEmpty;
    }

    public void setTrucksEmpty(boolean isEmpty) {
        this.trucksEmpty = isEmpty;
    }

    public void setFilterOnTrucks(Filter filterOnTrucks) {
        this.filterOnTrucks = filterOnTrucks;
    }

    public String getFilterOnTrucksName() {
        if (this.filterOnTrucks == null) {
            return "none";
        }
        return this.filterOnTrucks.getName();
    }

    public String getFilterSensorsDIOName() {
        return this.filterSensorsDIOName;
    }

    public void setFilterSensorsDIOName(String filterSensorsDIOName) {
        this.filterSensorsDIOName = filterSensorsDIOName;
    }

    public String getRailsSensorsDIOName() {
        return this.railsSensorsDIOName;
    }

    public void setRailsSensorsDIOName(String railsSensorsDIOName) {
        this.railsSensorsDIOName = railsSensorsDIOName;
    }

    public abstract boolean isMovingToStandback();

    public abstract boolean isMovingToStandby();

    public void init() {
        FCSLOG.info((Object)"[AutoChangerModule] Initializing the Auto Changer module ");
        ComponentLookup lookup = this.s.getComponentLookup();
        this.filterSensorsDIO = (CompactIO)lookup.getComponentByName(this.filterSensorsDIOName);
        this.railsSensorsDIO = (CompactIO)lookup.getComponentByName(this.railsSensorsDIOName);
        this.timeoutForClosingLatches = Math.max(this.latchXminus.getTimeoutForClosing(), this.latchXplus.getTimeoutForClosing());
        this.timeoutForOpeningLatches = Math.max(this.latchXminus.getTimeoutForOpening(), this.latchXplus.getTimeoutForOpening());
        SftTruckMotor sftTrucksMotor = (SftTruckMotor)lookup.getComponentByName("sftTrucksMotor");
        if (sftTrucksMotor == null) {
            FCSLOG.error((Object)(this.name + "==>>> sftTrucksMotor == null - Please fix groovy description file."));
            throw new IllegalArgumentException(this.name + "==>>> null sftTrucksMotor - fix groovy description file.");
        }
        sftTrucksMotor.setTruckMotorListener(this);
        this.periodicTaskService.scheduleAgentPeriodicTask(new AgentPeriodicTask("ac-tick", this::publishData).withIsFixedRate(true).withLogLevel(Level.WARNING).withPeriod(Duration.ofSeconds(1L)));
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if hardware is connected and ready.")
    public boolean myDevicesReady() {
        return this.mainModule.allDevicesBooted();
    }

    @Override
    public void onTruckEvent() {
        FCSLOG.debug((Object)(this.name + "===> PROCESS_UPDATE from trucksMotor"));
        this.publishDataAndNotifyObservers();
    }

    public StatusDataPublishedByBasicAutoChanger getStatusData() {
        return SftUtils.createStatusDataPublishedByBasicAutoChanger(this);
    }

    public void publishDataAndNotifyObservers() {
        StatusDataPublishedByBasicAutoChanger status = this.getStatusData();
        this.publishData();
    }

    @Override
    public void publishData() {
        StatusDataPublishedByBasicAutoChanger status = this.getStatusData();
        this.s.publishSubsystemDataOnStatusBus(new KeyValueData("autochanger", (Serializable)status));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append("\n");
        sb.append("Trucks position = ");
        sb.append("Filter on trucks:");
        if (this.filterOnTrucks == null) {
            sb.append(" NONE").append("\n");
        } else {
            sb.append(this.filterOnTrucks.getName()).append("\n");
        }
        return sb.toString();
    }

    @Override
    public abstract boolean isMoving();

    public abstract String goToStandby();

    public abstract String goToStandback();

    public abstract String moveFilterToStandby(Filter var1);

    public abstract String moveFilterToStandback(Filter var1);

    @Override
    public abstract void updateStateWithSensors();

    @Command(type=Command.CommandType.QUERY, level=1, description="checks if the preconditions are ok before a motion of the trucks can be started")
    public void checkPreConditionsForTrucksMotion() {
        FCSLOG.info((Object)"Checking pre-conditions for trucks motion");
        this.updateLatchesStateWithSensors();
        FCSLOG.debug((Object)(this.name + " LATCHES STATUS= " + this.latchesState.toString()));
        if (this.latchesState == FcsEnumerations.LockStatus.ERROR) {
            throw new RejectedCommandException(this.name + "Trucks motion forbidden when latches status is ERROR.");
        }
        if (this.latchesState == FcsEnumerations.LockStatus.UNKNOWN) {
            throw new RejectedCommandException(this.name + "Trucks motion forbidden when latches status is UNKNOWN.");
        }
        if (!this.trucksEmpty && this.latchesState == FcsEnumerations.LockStatus.UNLOCKED) {
            throw new RejectedCommandException(this.name + "Trucks motion forbidden when trucks are loaded and latches are UNLOCKED.");
        }
        if (this.isHoldingFilterAtStandby() && this.carousel.isHoldingFilterAtStandby()) {
            throw new RejectedCommandException(this.name + "Trucks motion forbidden when both carousel and autochanger are holding filter.");
        }
        FCSLOG.info((Object)"===== Preconditions for trucks motion are checked.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, level=1, description="Go to STANDBY to grab filter and stay at STANDBY")
    public String grabFilterAtStandby(Filter filter) {
        if (this.filterOnTrucks != null) {
            throw new RejectedCommandException(this.name + ": can't grab a filter when a filter is already loaded in trucks ");
        }
        FCSLOG.info((Object)(this.name + ": grabbing " + filter.getName() + " at standby position."));
        this.goToStandby();
        this.closeLatchesAtStandby();
        BasicAutoChanger basicAutoChanger = this;
        synchronized (basicAutoChanger) {
            this.filterOnTrucks = filter;
            this.setTrucksEmpty(false);
            this.filterOnTrucks.setFilterLocation(FcsEnumerations.FilterLocation.AUTOCHANGER);
        }
        this.publishData();
        String ack = this.getName() + ": " + filter.getName() + " is grabbed on autochanger";
        FCSLOG.info((Object)ack);
        return ack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, level=1, description="Ungrab filter at STANDBY and go back to HANDOFF")
    public String ungrabFilterAtStandby() {
        FCSLOG.info((Object)(this.name + ": ungrabbing filter at standby position."));
        this.openLatchesAtStandby();
        BasicAutoChanger basicAutoChanger = this;
        synchronized (basicAutoChanger) {
            this.filterOnTrucks = null;
            this.setTrucksEmpty(true);
            this.publishDataAndNotifyObservers();
        }
        FCSLOG.info((Object)(this.name + " trucks going empty to STANDBACK position"));
        this.goToStandback();
        this.publishData();
        return this.getName() + ": trucks are empty at STANDBACK position ";
    }

    public FcsEnumerations.LockStatus getLatchesState() {
        this.lock.lock();
        try {
            while (this.updatingLatches) {
                try {
                    this.stateUpdated.await();
                }
                catch (InterruptedException ex) {
                    FCSLOG.error((Object)ex);
                }
            }
            FcsEnumerations.LockStatus lockStatus = this.latchesState;
            return lockStatus;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isHoldingFilter() {
        return this.isHoldingFilterAtStandby();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return true if the trucks are at STANDBY position and hold a filter")
    public boolean isHoldingFilterAtStandby() {
        if (this.isMoving()) {
            return false;
        }
        if (!this.isAtStandby()) {
            return false;
        }
        if (this.isTrucksEmpty()) {
            return false;
        }
        return this.getLatchesState().equals(FcsEnumerations.LockStatus.LOCKED);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return true if the trucks are at STANDBACK position and hold a filter")
    public boolean isHoldingFilterAtStandback() {
        if (this.isMoving()) {
            return false;
        }
        if (!this.isAtStandback()) {
            return false;
        }
        if (this.isTrucksEmpty()) {
            return false;
        }
        return this.getLatchesState().equals(FcsEnumerations.LockStatus.LOCKED);
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        if (action.equals((Object)FcsEnumerations.MobileItemAction.OPENLATCHES)) {
            return this.getLatchesState().equals(FcsEnumerations.LockStatus.UNLOCKED);
        }
        if (action.equals((Object)FcsEnumerations.MobileItemAction.CLOSELATCHES)) {
            return this.getLatchesState().equals(FcsEnumerations.LockStatus.LOCKED);
        }
        throw new IllegalArgumentException("Action on latches must be OPENLATCHES or CLOSELATCHES");
    }

    @Override
    public void postAction(FcsEnumerations.MobileItemAction action) {
        this.updateLatchesStateWithSensors();
        this.publishData();
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) {
        if (action.equals((Object)FcsEnumerations.MobileItemAction.OPENLATCHES)) {
            this.latchXminus.latchActuator.open();
            this.latchXplus.latchActuator.open();
        } else if (action.equals((Object)FcsEnumerations.MobileItemAction.CLOSELATCHES)) {
            this.latchXminus.latchActuator.close();
            this.latchXplus.latchActuator.close();
        } else {
            throw new IllegalArgumentException(this.name + "Action on latches must be OPENLATCHES or CLOSELATCHES");
        }
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) {
        FCSLOG.info((Object)(this.name + " stopAction : nothing to be done."));
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() {
        try {
            this.updateLatchesStateWithSensors();
        }
        catch (ClampsOrLatchesDisagreeException ex) {
            FCSLOG.warning((Object)ex);
            FCSLOG.warning((Object)(this.name + ": a little delay between the update of the 2 latches : have to wait ..."));
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Open the 2 latches when the autochanger trucks are at standby position", alias="openLatches")
    public String openLatchesAtStandby() throws FcsHardwareException {
        this.updateStateWithSensors();
        if (!this.isAtStandby()) {
            throw new RejectedCommandException(this.name + "CANNOT OPEN LATCHES at STANDBY : AUTOCHANGER is NOT AT STANDBY");
        }
        if (!this.carousel.isHoldingFilterAtStandby()) {
            throw new RejectedCommandException(this.name + "CANNOT OPEN LATCHES at STANDBY : CAROUSEL is NOT HOLDING THE FILTER");
        }
        this.executeAction(FcsEnumerations.MobileItemAction.OPENLATCHES, this.timeoutForOpeningLatches);
        this.latchXminus.latchActuator.powerOff();
        this.latchXplus.latchActuator.powerOff();
        this.publishDataAndNotifyObservers();
        return "Autochanger latches are unlocked";
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Close the 2 latches when the autochanger trucks are at standby position", alias="closeLatches")
    public String closeLatchesAtStandby() {
        this.updateStateWithSensors();
        if (!this.isAtStandby()) {
            throw new RejectedCommandException(this.name + "CANNOT CLOSE LATCHES at STANDBY : AUTOCHANGER is NOT AT STANDBY");
        }
        this.executeAction(FcsEnumerations.MobileItemAction.CLOSELATCHES, this.timeoutForClosingLatches);
        this.latchXminus.latchActuator.powerOff();
        this.latchXplus.latchActuator.powerOff();
        this.publishDataAndNotifyObservers();
        return "Autochanger latches are locked";
    }

    public void updateLatchesStateWithSensors() {
        this.lock.lock();
        this.updatingLatches = true;
        try {
            this.filterSensorsDIO.updateValue();
            int filterSensorsHexaValue = this.filterSensorsDIO.getHexaValue();
            this.latchXminus.updateState(filterSensorsHexaValue);
            this.latchXplus.updateState(filterSensorsHexaValue);
            if (!this.latchXminus.getLockStatus().equals(this.latchXplus.getLockStatus())) {
                throw new ClampsOrLatchesDisagreeException(this.name + "Error in latches lock status : the latches don't agree");
            }
            this.latchesState = this.latchXminus.getLockStatus();
            if (!this.latchXminus.getPresenceStatus().equals(this.latchXplus.getPresenceStatus())) {
                throw new ClampsOrLatchesDisagreeException(this.name + "Error in latches filter presence status : the latches don't agree.");
            }
            this.presenceStatus = this.latchXminus.getPresenceStatus();
            this.trucksEmpty = !this.latchesState.equals(FcsEnumerations.LockStatus.LOCKED) || !this.presenceStatus.equals(FcsEnumerations.FilterPresenceStatus.ENGAGED);
            FCSLOG.debug((Object)(this.name + ": latches are updated"));
        }
        finally {
            this.updatingLatches = false;
            this.stateUpdated.signal();
            this.lock.unlock();
            this.publishDataAndNotifyObservers();
        }
    }

    public FcsEnumerations.AutoChangerTrucksLocation getTrucksLocation() {
        this.lock.lock();
        try {
            while (this.updatingTrucksLocation) {
                try {
                    this.trucksLocationUpdated.await();
                }
                catch (InterruptedException ex) {
                    FCSLOG.error((Object)ex);
                }
            }
            FcsEnumerations.AutoChangerTrucksLocation autoChangerTrucksLocation = this.trucksLocation;
            return autoChangerTrucksLocation;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Return true if the trucks are at STANDBY position")
    public boolean isAtStandby() {
        return this.getTrucksLocation() == FcsEnumerations.AutoChangerTrucksLocation.STANDBY;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return true if the trucks are at STANDBACK position")
    public boolean isAtStandback() {
        return this.getTrucksLocation() == FcsEnumerations.AutoChangerTrucksLocation.STANDBACK;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Return true if the trucks are at HANDOFF position")
    public boolean isAtHandoff() {
        return this.getTrucksLocation() == FcsEnumerations.AutoChangerTrucksLocation.HANDOFF;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return true if the trucks are at ONLINE position")
    public boolean isOnline() {
        return this.getTrucksLocation() == FcsEnumerations.AutoChangerTrucksLocation.ONLINE;
    }

    public void updateTrucksLocationWithSensors() {
        block4: {
            this.lock.lock();
            this.updatingTrucksLocation = false;
            try {
                this.railsSensorsDIO.updateValue();
                int dioHexaValue = this.railsSensorsDIO.getHexaValue();
                FCSLOG.debug((Object)(this.railsSensorsDIO.getName() + " HEXA VALUE=" + dioHexaValue));
                this.truckXminus.updateLocation(dioHexaValue);
                this.truckXplus.updateLocation(dioHexaValue);
                if (this.truckXminus.getTruckLocation() == this.truckXplus.getTruckLocation()) {
                    this.trucksLocation = this.truckXminus.getTruckLocation();
                    break block4;
                }
                String msg = this.getName() + "Trucks are not at the same location";
                FCSLOG.error((Object)msg);
                throw new FcsHardwareException(msg);
            }
            finally {
                this.updatingTrucksLocation = false;
                this.trucksLocationUpdated.signal();
                this.lock.unlock();
                this.publishDataAndNotifyObservers();
            }
        }
    }
}

