/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Map;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.subsystems.fcs.AutochangerOnlineClamp;
import org.lsst.ccs.subsystems.fcs.common.EPOSControllerWithBrake;
import org.lsst.ccs.subsystems.fcs.simulation.SimuAutochangerPlutoGateway;
import org.lsst.ccs.subsystems.fcs.simulation.SimuEPOSController;

public class SimuAutochangerOnlineClampController
extends SimuEPOSController
implements EPOSControllerWithBrake {
    @ConfigurationParameter(isFinal=true)
    private String onlineClampName;
    private final SimuAutochangerPlutoGateway plutoGateway;
    private AutochangerOnlineClamp onlineClamp;
    private boolean brakeActivated;

    public SimuAutochangerOnlineClampController(int nodeID, String serialNB, SimuAutochangerPlutoGateway plutoGateway, String onlineClampName, Map<String, Integer> paramsForCurrent, Map<String, Integer> paramsForProfilePosition, Map<String, Integer> paramsForHoming) {
        super(nodeID, serialNB, paramsForCurrent, paramsForProfilePosition, paramsForHoming);
        this.onlineClampName = onlineClampName;
        this.plutoGateway = plutoGateway;
    }

    public void init() {
        ComponentLookup lookup = this.s.getComponentLookup();
        this.onlineClamp = (AutochangerOnlineClamp)lookup.getComponentByName(this.onlineClampName);
    }

    @Override
    public void writeCurrent(int current) {
        this.targetCurrent = current;
        this.actualCurrent = current;
        if (this.targetCurrent == this.onlineClamp.getFinalCurrentToClose()) {
            this.plutoGateway.simulateAutochangerOnlineClampIsClosed(this.onlineClamp);
        } else if (this.targetCurrent == this.onlineClamp.getCurrentToOpen()) {
            this.plutoGateway.simulateAutochangerOnlineClampIsOpened(this.onlineClamp);
        } else if (this.targetCurrent == this.onlineClamp.getCurrentToClamp()) {
            this.plutoGateway.simulateAutochangerOnlineClampIsLocked(this.onlineClamp);
        }
    }

    @Override
    public void activateBrakeAndDisable() {
        this.brakeActivated = true;
    }

    @Override
    public void enableAndReleaseBrake() {
        this.brakeActivated = false;
    }

    @Override
    public void doReleaseBrake() {
        this.brakeActivated = false;
    }

    @Override
    public boolean isBrakeActivated() {
        return this.brakeActivated;
    }

    @Override
    public void activateBrake() {
        this.brakeActivated = true;
    }
}

