/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.common;

import java.io.Serializable;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.common.AlertRaiser;
import org.lsst.ccs.subsystems.fcs.drivers.EmergencyMessageListener;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;

public interface PieceOfHardware
extends EmergencyMessageListener,
AlertRaiser {
    @Override
    public String getName();

    public String getSerialNB();

    public int getNodeID();

    public boolean isBooted();

    public void setBooted(boolean var1);

    public boolean isInitialized();

    public void initializeAndCheckHardware();

    default public void checkBooted() {
        if (!this.isBooted()) {
            throw new FcsHardwareException(this.getName() + ": not booted");
        }
    }

    default public void checkInitialized() {
        if (!this.isInitialized()) {
            throw new FcsHardwareException(this.getName() + ": not initialized");
        }
    }

    default public void raiseAlarmIfMissing() {
        if (!this.isBooted()) {
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_MISSING, this.getName() + " device not booted", this.getName());
        }
    }

    default public boolean checkId(String id) {
        return id.equals(this.getSerialNB());
    }

    default public StatusDataPublishedByHardware createStatusDataPublishedByHardware() {
        return new StatusDataPublishedByHardware(this.getName(), this.isBooted(), this.isInitialized());
    }

    default public void publishData() {
        StatusDataPublishedByHardware status = this.createStatusDataPublishedByHardware();
        FCSCst.FCSLOG.info((Object)(this.getName() + " is publishing:" + status));
        this.getSubsystem().publishSubsystemDataOnStatusBus(new KeyValueData(this.getName(), (Serializable)status));
    }

    default public String printState() {
        StringBuilder sb = new StringBuilder("name=" + this.getName());
        sb.append(",nodeID=");
        sb.append(Integer.toHexString(this.getNodeID()));
        sb.append(",serial number=");
        sb.append(this.getSerialNB());
        if (this.isBooted()) {
            sb.append(" is BOOTED");
        } else {
            sb.append(" is NOT BOOTED");
        }
        if (this.isInitialized()) {
            sb.append(" and INITIALIZED");
        } else {
            sb.append(" and NOT INITIALIZED");
        }
        return sb.toString();
    }
}

