/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.common;

import org.lsst.ccs.AlertService;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;

public interface AlertRaiser {
    public static final char alertSeparater = '/';

    public AlertService getAlertService();

    default public void raiseAlarm(String fcsErrorID, String message, String cause) {
        FCSCst.FCSLOG.error((Object)(fcsErrorID + " " + message + " " + cause));
        this.getAlertService().raiseAlert(new Alert(fcsErrorID, message), AlertState.ALARM, cause);
    }

    default public void raiseAlarm(FcsEnumerations.FcsAlert fcsAlert, String cause) {
        this.raiseAlarm(fcsAlert.name(), fcsAlert.getLongDescription(), cause);
    }

    default public void raiseAlarm(FcsEnumerations.FcsAlert fcsAlert, String cause, Exception ex) {
        this.raiseAlarm(fcsAlert.name(), fcsAlert.getLongDescription(), cause + ex);
    }

    default public void raiseAlarm(FcsEnumerations.FcsAlert fcsAlert, String cause, String deviceName) {
        this.raiseAlarm(deviceName + '/' + fcsAlert.name(), fcsAlert.getLongDescription(), cause);
    }

    default public void clearAlarm(FcsEnumerations.FcsAlert fcsAlert, String deviceName) {
        String[] alarmList = new String[]{deviceName + '/' + fcsAlert.name()};
        this.getAlertService().clearAlerts(alarmList);
    }

    default public void raiseAlarm(FcsEnumerations.FcsAlert fcsAlert, String cause, String deviceName, Exception ex) {
        this.raiseAlarm(deviceName + '/' + fcsAlert.name(), fcsAlert.getLongDescription(), cause + " " + ex);
    }

    @Deprecated
    default public void raiseAlarm(String fcsErrorID, String message, Exception ex) {
        FCSCst.FCSLOG.error((Object)message, (Throwable)ex);
        this.getAlertService().raiseAlert(new Alert(fcsErrorID, message), AlertState.ALARM, message + ex);
    }

    default public void raiseWarning(String fcsErrorID, String message, String cause) {
        FCSCst.FCSLOG.warning((Object)message);
        this.getAlertService().raiseAlert(new Alert(fcsErrorID, message), AlertState.WARNING, cause);
    }

    default public void raiseWarning(FcsEnumerations.FcsAlert fcsAlert, String cause) {
        this.raiseWarning(fcsAlert.name(), fcsAlert.getLongDescription(), cause);
    }

    default public void raiseWarning(FcsEnumerations.FcsAlert fcsAlert, String cause, String deviceName) {
        this.raiseWarning(deviceName + '/' + fcsAlert.name(), fcsAlert.getLongDescription(), cause);
    }

    default public void raiseWarning(FcsEnumerations.FcsAlert fcsAlert, String cause, String deviceName, Exception ex) {
        this.raiseWarning(deviceName + '/' + fcsAlert.name(), fcsAlert.getLongDescription(), cause + ex);
    }

    @Deprecated
    default public void raiseWarning(String fcsErrorID, String message, Exception ex) {
        FCSCst.FCSLOG.warning((Object)message);
        this.getAlertService().raiseAlert(new Alert(fcsErrorID, message), AlertState.WARNING, message + ex);
    }

    public String getName();

    public Subsystem getSubsystem();
}

