/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.DigitalSensor;
import org.lsst.ccs.subsystems.fcs.common.BinarySensor;

public class ComplementarySensors
implements BinarySensor {
    private final DigitalSensor sensor;
    private final DigitalSensor sensorC;

    public ComplementarySensors(DigitalSensor sensor, DigitalSensor sensorC) {
        this.sensor = sensor;
        this.sensorC = sensorC;
    }

    public DigitalSensor getSensor() {
        return this.sensor;
    }

    public DigitalSensor getSensorC() {
        return this.sensorC;
    }

    @Command(description="return true if this couple of sensors are in error.")
    public boolean isInError() {
        return this.sensor.isOn() == this.sensorC.isOn();
    }

    @Override
    @Command(description="return true if sensor's value is 1 and sensorC's value is 0.")
    public boolean isOn() {
        return this.sensor.isOn() && !this.sensorC.isOn();
    }

    public boolean getDigitalValue() {
        return this.sensor.isOn();
    }

    @Override
    public synchronized void updateValue(int[] hexaValues) {
        this.sensor.updateValue(hexaValues);
        this.sensorC.updateValue(hexaValues);
    }
}

