/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.subsystems.fcs.DigitalSensor;
import org.lsst.ccs.subsystems.fcs.ForceSensor;
import org.lsst.ccs.subsystems.fcs.LoaderCarrierModule;
import org.lsst.ccs.subsystems.fcs.LoaderClampModule;
import org.lsst.ccs.subsystems.fcs.RedondantSensors;
import org.lsst.ccs.subsystems.fcs.simulation.SimuLoaderCarrierController;
import org.lsst.ccs.subsystems.fcs.simulation.SimuLoaderClampController;
import org.lsst.ccs.subsystems.fcs.simulation.SimuPlutoGateway;

public class SimuLoaderPlutoGateway
extends SimuPlutoGateway {
    private LoaderCarrierModule carrier;
    private LoaderClampModule clamp;
    private SimuLoaderCarrierController carrierController;
    private SimuLoaderClampController hooksController;
    private DigitalSensor closeSensor1;
    private DigitalSensor openSensor1;
    private DigitalSensor closeSensor2;
    private DigitalSensor openSensor2;
    private DigitalSensor closeSensor3;
    private DigitalSensor openSensor3;
    private DigitalSensor closeSensor4;
    private DigitalSensor openSensor4;
    private DigitalSensor clampedStatusSensor;
    private ForceSensor forceSensor0;
    private ForceSensor forceSensor1;
    private RedondantSensors filterPresenceSensors;
    private RedondantSensors loaderOnCameraSensors;
    private RedondantSensors storagePositionSensors;
    private RedondantSensors handoffPositionSensors;

    public SimuLoaderPlutoGateway(String nodeID, String serialNB) {
        super(nodeID, serialNB);
    }

    @Override
    public void initModule() {
        super.initModule();
        ComponentLookup lookup = this.getComponentLookup();
        this.closeSensor1 = (DigitalSensor)lookup.getComponentByName("loaderCloseSensor1");
        this.closeSensor2 = (DigitalSensor)lookup.getComponentByName("loaderCloseSensor2");
        this.closeSensor3 = (DigitalSensor)lookup.getComponentByName("loaderCloseSensor3");
        this.closeSensor4 = (DigitalSensor)lookup.getComponentByName("loaderCloseSensor4");
        this.openSensor1 = (DigitalSensor)lookup.getComponentByName("loaderOpenSensor1");
        this.openSensor2 = (DigitalSensor)lookup.getComponentByName("loaderOpenSensor2");
        this.openSensor3 = (DigitalSensor)lookup.getComponentByName("loaderOpenSensor3");
        this.openSensor4 = (DigitalSensor)lookup.getComponentByName("loaderOpenSensor4");
        this.clampedStatusSensor = (DigitalSensor)lookup.getComponentByName("clampedStatusSensor");
        this.forceSensor0 = (ForceSensor)((Object)lookup.getComponentByName("forceSensor0"));
        this.forceSensor1 = (ForceSensor)((Object)lookup.getComponentByName("forceSensor1"));
        this.loaderOnCameraSensors = (RedondantSensors)lookup.getComponentByName("loaderOnCameraSensors");
        this.filterPresenceSensors = (RedondantSensors)lookup.getComponentByName("loaderFilterPresenceSensors");
        this.storagePositionSensors = (RedondantSensors)lookup.getComponentByName("loaderStorageSensors");
        this.handoffPositionSensors = (RedondantSensors)lookup.getComponentByName("loaderHandoffSensors");
        this.carrierController = (SimuLoaderCarrierController)lookup.getComponentByName("carrierController");
        this.carrier = (LoaderCarrierModule)lookup.getComponentByName("carrier");
        this.hooksController = (SimuLoaderClampController)lookup.getComponentByName("hooksController");
        this.clamp = (LoaderClampModule)lookup.getComponentByName("clamp");
        this.simulateLoaderClampIsClosed();
        this.simulateLoaderIsConnectedOnCamera();
        this.simulateClampedStatusSensorIsOn();
        this.simulateFilterIsOnLoader();
        this.simulateLoaderCarrierIsAtStorage();
    }

    protected void simuRedondantSensorsOn(RedondantSensors sensors) {
        this.replaceHexaValues(sensors.getSensor(), true);
        this.replaceHexaValues(sensors.getSensorR(), true);
    }

    protected void simuRedondantSensorsOff(RedondantSensors sensors) {
        this.replaceHexaValues(sensors.getSensor(), false);
        this.replaceHexaValues(sensors.getSensorR(), false);
    }

    protected void simuRedondantSensorsInError(RedondantSensors sensors) {
        this.replaceHexaValues(sensors.getSensor(), true);
        this.replaceHexaValues(sensors.getSensorR(), false);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateLoaderClampIsClosed() {
        this.simulateHooksAreClosed();
        this.simulateClampedStatusSensorIsOff();
        this.hooksController.setPosition(this.clamp.getRelativePositionToClose());
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateLoaderClampIsClamped() {
        this.simulateHooksAreClosed();
        this.simulateClampedStatusSensorIsOn();
        this.hooksController.setPosition(this.clamp.getTargetPositionToClamp());
    }

    private void simulateHooksAreClosed() {
        this.simulateHookIsClosed(this.closeSensor1, this.openSensor1);
        this.simulateHookIsClosed(this.closeSensor2, this.openSensor2);
        this.simulateHookIsClosed(this.closeSensor3, this.openSensor3);
        this.simulateHookIsClosed(this.closeSensor4, this.openSensor4);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateLoaderClampIsOpened() {
        this.simulateHookIsOpened(this.closeSensor1, this.openSensor1);
        this.simulateHookIsOpened(this.closeSensor2, this.openSensor2);
        this.simulateHookIsOpened(this.closeSensor3, this.openSensor3);
        this.simulateHookIsOpened(this.closeSensor4, this.openSensor4);
        this.simulateClampedStatusSensorIsOff();
        this.hooksController.setPosition(this.clamp.getTargetPositionToOpen());
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateLoaderClampIsInTravel() {
        this.simulateHookIsInTravel(this.closeSensor1, this.openSensor1);
        this.simulateHookIsInTravel(this.closeSensor2, this.openSensor2);
        this.simulateHookIsInTravel(this.closeSensor3, this.openSensor3);
        this.simulateHookIsInTravel(this.closeSensor4, this.openSensor4);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateClampIsInError() {
        this.simulateHookIsOpened(this.closeSensor1, this.openSensor1);
        this.simulateHookIsOpened(this.closeSensor2, this.openSensor2);
        this.simulateHookIsOpened(this.closeSensor3, this.openSensor3);
        this.simulateHookIsClosed(this.closeSensor4, this.openSensor4);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateHookIsClosed(DigitalSensor closeSensor, DigitalSensor openSensor) {
        this.replaceHexaValues(closeSensor, true);
        this.replaceHexaValues(openSensor, false);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateHookIsOpened(DigitalSensor closeSensor, DigitalSensor openSensor) {
        this.replaceHexaValues(closeSensor, false);
        this.replaceHexaValues(openSensor, true);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateHookIsInTravel(DigitalSensor closeSensor, DigitalSensor openSensor) {
        this.replaceHexaValues(closeSensor, false);
        this.replaceHexaValues(openSensor, false);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateLoaderIsConnectedOnCamera() {
        this.simuRedondantSensorsOn(this.loaderOnCameraSensors);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateLoaderIsNotConnectedOnCamera() {
        this.simuRedondantSensorsOff(this.loaderOnCameraSensors);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateFilterIsOnLoader() {
        this.simuRedondantSensorsOn(this.filterPresenceSensors);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateFilterIsNotOnLoader() {
        this.simuRedondantSensorsOff(this.filterPresenceSensors);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateLoaderCarrierIsAtStorage() {
        this.simuRedondantSensorsOn(this.storagePositionSensors);
        this.simuRedondantSensorsOff(this.handoffPositionSensors);
        this.carrierController.setPosition(this.carrier.getStoragePosition());
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateLoaderCarrierIsAtHandoff() {
        this.simuRedondantSensorsOff(this.storagePositionSensors);
        this.simuRedondantSensorsOn(this.handoffPositionSensors);
        this.carrierController.setPosition(this.carrier.getHandoffPosition());
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateLoaderCarrierIsInTravel() {
        this.simuRedondantSensorsOff(this.storagePositionSensors);
        this.simuRedondantSensorsOff(this.handoffPositionSensors);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateHandoffSensorsAreInError() {
        this.simuRedondantSensorsInError(this.handoffPositionSensors);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateStorageSensorsAreInError() {
        this.simuRedondantSensorsInError(this.storagePositionSensors);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateClampedStatusSensorIsOn() {
        this.replaceHexaValues(this.clampedStatusSensor, true);
        this.simulateForceSensorsOn();
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateClampedStatusSensorIsOff() {
        this.replaceHexaValues(this.clampedStatusSensor, false);
        this.simulateForceSensorsOff();
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateForceSensorsOn() {
        this.simulateForceSensorClamped(this.forceSensor0, true);
        this.simulateForceSensorClamped(this.forceSensor1, true);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateForceSensorsOff() {
        this.simulateForceSensorClamped(this.forceSensor0, false);
        this.simulateForceSensorClamped(this.forceSensor1, false);
    }

    public void simulateForceSensorClamped(ForceSensor forceSensor, boolean on) {
        int forceOn = 900;
        int forceOff = 0;
        if (on) {
            this.updateForceSensor(forceSensor, forceOn);
        } else {
            this.updateForceSensor(forceSensor, forceOff);
        }
    }

    private void updateForceSensor(ForceSensor forceSensor, int force) {
        int voltage = SimuLoaderPlutoGateway.getVoltageFromForce(forceSensor, force);
        this.hexaValues[forceSensor.getByteNumero()] = Integer.toHexString(voltage);
    }

    private static int getVoltageFromForce(ForceSensor forceSensor, int force) {
        double voltage = ((double)force + forceSensor.getTransfert_Constante()) / (100.0 * forceSensor.getTransfert_coeff());
        return (int)voltage;
    }
}

