/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Map;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.LoaderCarrierModule;
import org.lsst.ccs.subsystems.fcs.LoaderModule;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.simulation.SimuEPOSControllerModule;
import org.lsst.ccs.subsystems.fcs.simulation.SimuLoaderPlutoGateway;

public class SimuLoaderCarrierController
extends SimuEPOSControllerModule {
    private LoaderCarrierModule carrier;
    private LoaderModule loader;
    private SimuLoaderPlutoGateway plutoGateway;
    private final String plutoGatewayName;

    public SimuLoaderCarrierController(String nodeID, String serialNB, String plutoGatewayName, Map<String, Integer> paramsForCurrent, Map<String, Integer> paramsForProfilePosition, Map<String, Integer> paramsForHoming) {
        super(nodeID, serialNB, paramsForCurrent, paramsForProfilePosition, paramsForHoming);
        this.plutoGatewayName = plutoGatewayName;
    }

    @Override
    public void initModule() {
        super.initModule();
        ComponentLookup lookup = this.getComponentLookup();
        this.carrier = (LoaderCarrierModule)lookup.getComponentByName("carrier");
        this.loader = (LoaderModule)lookup.getComponentByName("loader");
        this.plutoGateway = (SimuLoaderPlutoGateway)lookup.getComponentByName(this.plutoGatewayName);
    }

    @Override
    public void writeTargetPosition(int positionToReached) {
        this.targetPosition = positionToReached;
        int positionInitiale = this.position;
        FCSCst.FCSLOG.debug((Object)"loader carrier is moving.");
        FCSCst.FCSLOG.debug((Object)(this.getName() + "=>position intitiale=" + this.position));
        int stepsNB = 20;
        int step = (this.targetPosition - this.position) / stepsNB;
        for (int i = 1; i < stepsNB; ++i) {
            try {
                this.position = positionInitiale + i * step;
                this.carrier.updatePosition();
                if (this.position == this.carrier.getHandoffPosition()) {
                    FCSCst.FCSLOG.debug((Object)("plutoGateway=" + this.plutoGateway.toString()));
                    this.plutoGateway.simulateLoaderCarrierIsAtHandoff();
                } else if (this.position == this.carrier.getStoragePosition()) {
                    this.plutoGateway.simulateLoaderCarrierIsAtStorage();
                } else {
                    this.plutoGateway.simulateLoaderCarrierIsInTravel();
                }
                this.loader.updateStateWithSensors();
                this.carrier.publishData();
                FCSCst.FCSLOG.debug((Object)(this.getName() + "i=" + i + ",position=" + this.position));
                try {
                    Thread.sleep(500L);
                    if (!this.carrier.getHaltRequired().get()) continue;
                    FCSCst.FCSLOG.debug((Object)(this.getName() + " STOP simulated carrrier motion."));
                    return;
                }
                catch (InterruptedException ex) {
                    throw new RejectedCommandException(this.getName() + " sleep was interrupted.");
                }
            }
            catch (FcsHardwareException ex) {
                FCSCst.FCSLOG.error((Object)ex);
                throw new RejectedCommandException(ex.getMessage());
            }
        }
        this.position = this.targetPosition;
        if (this.position == this.carrier.getHandoffPosition()) {
            FCSCst.FCSLOG.debug((Object)("plutoGateway=" + this.plutoGateway.toString()));
            this.plutoGateway.simulateLoaderCarrierIsAtHandoff();
        } else if (this.position == this.carrier.getStoragePosition()) {
            this.plutoGateway.simulateLoaderCarrierIsAtStorage();
        } else {
            this.plutoGateway.simulateLoaderCarrierIsInTravel();
        }
    }
}

