/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.common.PDOStorage;
import org.lsst.ccs.subsystems.fcs.common.Thermometer;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenSensor14bits;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;

public class CanOpenThermometer
extends CanOpenSensor14bits
implements Thermometer {
    private double temperature;

    public CanOpenThermometer(String adcName, int numOfAnalogInput) {
        super(adcName, numOfAnalogInput);
    }

    public static double getDoubleValue(String valueInHexa) {
        double temp = 0.0;
        FCSCst.FCSLOG.debug((Object)("Value in HEXA=" + valueInHexa));
        int valueInt = Integer.parseInt(valueInHexa, 16);
        double voltage = (double)valueInt * 0.3125;
        FCSCst.FCSLOG.debug((Object)("Input Value read on the ADC:" + valueInt));
        FCSCst.FCSLOG.debug((Object)("Voltage = " + voltage + " volts"));
        temp = voltage / 10.0 - 273.15;
        return temp;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Read temperature on the termometer and returns the new value read.")
    public double readTemperature() {
        try {
            double voltage = this.adc.readVoltage(this.numOfAnalogInput);
            this.temperature = voltage / 10.0 - 273.15;
        }
        catch (ShortResponseToSDORequestException ex) {
            FCSCst.FCSLOG.warning((Object)(this.name + ": could'nt read temperature:" + (Object)((Object)ex)));
        }
        return this.temperature;
    }

    public double readTemperatureWithPDO(PDOStorage pdo) {
        this.adc.checkInitialized();
        if (!this.adc.transmissionType.equals("1")) {
            throw new RejectedCommandException("Transmission type for Can Open device must be 1");
        }
        String hexa = pdo.getVarValue(this.adc.nodeID, Integer.toString(this.numOfAnalogInput));
        return CanOpenThermometer.getDoubleValue(hexa);
    }
}

