/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.util.Observable;
import java.util.concurrent.locks.Condition;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.LoaderModule;
import org.lsst.ccs.subsystems.fcs.RedondantSensors;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderCarrier;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.ControlledBySensors;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.EmergencyMessage;
import org.lsst.ccs.subsystems.fcs.common.MobileItemModule;
import org.lsst.ccs.subsystems.fcs.common.MovedByEPOSController;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenCallTimeoutException;
import org.lsst.ccs.subsystems.fcs.errors.FailedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;

public class LoaderCarrierModule
extends MobileItemModule
implements MovedByEPOSController,
ControlledBySensors {
    private final RedondantSensors handoffSensors;
    private final RedondantSensors storageSensors;
    private int position = 0;
    private int ssiPosition = 0;
    private int absoluteTargetPosition = 0;
    @ConfigurationParameter(description="delta position in micron : used to know if carrier position is in a range of 2*deltaPosition around a given position")
    private int deltaPosition = 50;
    @ConfigurationParameter(description="Loader Handoff position in micron")
    private int handoffPosition = 1037500;
    @ConfigurationParameter(description="Loader Storage position in micron")
    private int storagePosition = 0;
    @ConfigurationParameter(description="For the Loader GUI : Maximum current to be sent to the Loader Carrier controller (in mA).")
    private int maxCurrent = 1000;
    @ConfigurationParameter(description="For the Loader GUI : Loader Carrier Maximum speed (in rpm/mn).")
    private int maxSpeed = 227;
    @ConfigurationParameter(description="timeout in milliseconds to go from storage to handoff on loader")
    private long timeoutForGoingToHandOff = 120000L;
    @ConfigurationParameter(description="timeout in milliseconds to go from handoff to storage on loader")
    private long timeoutForGoingToStorage = 120000L;
    private int speed;
    private int current;
    private EPOSController carrierController;
    private LoaderModule loader;
    private BridgeToHardware bridgeToLoader;
    private final Condition stateUpdated = this.lock.newCondition();
    protected volatile boolean updatingState = false;
    private boolean controllerInFault = false;
    private boolean limitSwitchDownInError = false;
    private boolean limitSwitchUpInError = false;
    private volatile boolean initialized = false;

    public LoaderCarrierModule(RedondantSensors handoffSensors, RedondantSensors storageSensors) {
        this.handoffSensors = handoffSensors;
        this.storageSensors = storageSensors;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns carrier position.")
    public int getPosition() {
        return this.position;
    }

    protected int getCurrent() {
        return this.current;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if carrierController is in Fault.")
    public boolean isControllerInFault() {
        return this.controllerInFault;
    }

    @Override
    public String getControllerName() {
        return this.carrierController.getName();
    }

    @Override
    public void setControllerInFault(boolean controllerInFault) {
        this.controllerInFault = controllerInFault;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if carrier is initialized and ready to receive commands.")
    public boolean isInitialized() {
        return this.initialized;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return the max speed in rpm/mn (format decimal).")
    public int getMaxSpeed() {
        return this.maxSpeed;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return the max current in mA (format decimal).")
    public int getMaxCurrent() {
        return this.maxCurrent;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return the handoff position in microns (format decimal).")
    public int getHandoffPosition() {
        return this.handoffPosition;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return the storage position in microns (format decimal).")
    public int getStoragePosition() {
        return this.storagePosition;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return the timeout for going to Handoff in millis (format decimal).")
    public long getTimeoutForGoingToHandOff() {
        return this.timeoutForGoingToHandOff;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return the timeout for going to Storage in millis (format decimal).")
    public long getTimeoutForGoingToStorage() {
        return this.timeoutForGoingToStorage;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return false if the 2 redondant position sensors at Storage are equal.")
    public boolean isStorageSensorsInError() {
        return this.storageSensors.isInError();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return false if the 2 redondant position sensors at HandOff are equal.")
    public boolean isHandoffSensorsInError() {
        return this.handoffSensors.isInError();
    }

    @Override
    public boolean isInError() {
        return this.handoffSensors.isInError() || this.storageSensors.isInError();
    }

    @Override
    public void initModule() {
        ComponentLookup lookup = this.getComponentLookup();
        this.loader = (LoaderModule)lookup.getComponentByName("loader");
        this.carrierController = (EPOSController)lookup.getComponentByName("carrierController");
        this.bridgeToLoader = (BridgeToHardware)lookup.getComponentByName("loaderTcpProxy");
        this.listens(new Observable[]{(Observable)((Object)this.carrierController)});
    }

    @Override
    public TreeWalkerDiag checkHardware() throws HardwareException {
        super.checkHardware();
        try {
            this.carrierController.initializeAndCheckHardware();
        }
        catch (ShortResponseToSDORequestException ex) {
            FCSLOG.warning((Object)(this.getName() + ":"), (Throwable)ex);
        }
        catch (FcsHardwareException ex) {
            throw new HardwareException(false, (Throwable)ex);
        }
        return TreeWalkerDiag.HANDLING_CHILDREN;
    }

    @Override
    public boolean isCANDevicesReady() {
        return this.bridgeToLoader.isCANDevicesReady();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the carrier is at storage position. This command doesn't read again the sensors.")
    public boolean isAtStoragePosition() {
        this.lock.lock();
        try {
            while (this.updatingState) {
                try {
                    this.stateUpdated.await();
                }
                catch (InterruptedException ex) {
                    FCSLOG.error((Object)(this.getName() + ": has been interrupted while waiting for end of update."), (Throwable)ex);
                }
            }
            boolean bl = this.storageSensors.isOn();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the carrier is at HANDOFF position. This command doesn't read again the sensors.")
    public boolean isAtHandoffPosition() {
        this.lock.lock();
        try {
            while (this.updatingState) {
                try {
                    this.stateUpdated.await();
                }
                catch (InterruptedException ex) {
                    FCSLOG.error((Object)(this.getName() + ": has been interrupted while waiting for end of update."), (Throwable)ex);
                }
            }
            boolean bl = this.handoffSensors.isOn();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, alias="goToHandoff", description="Move the carrier to Handoff position.")
    public void goToHandOff() {
        if (this.isAtHandoffPosition()) {
            FCSLOG.info((Object)(this.getName() + " is already at Handoff position. Nothing to do."));
        } else {
            this.loader.checkConditionsForCarrierMotion();
            this.executeAction(FcsEnumerations.MobileItemAction.MOVE_LOADERCARRIER_TO_HANDOFF, this.timeoutForGoingToHandOff);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move the carrier to STORAGE position.")
    public void goToStorage() {
        if (this.isAtStoragePosition()) {
            FCSLOG.info((Object)(this.getName() + " is already at Storage position. Nothing to do."));
        } else {
            this.loader.checkConditionsForCarrierMotion();
            this.executeAction(FcsEnumerations.MobileItemAction.MOVE_LOADERCARRIER_TO_STORAGE, this.timeoutForGoingToStorage);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move the carrier to absolute position given as argument (in decimal format).")
    public void goToAbsolutePosition(int absolutePosition) {
        this.updatePosition();
        if (this.position == absolutePosition) {
            FCSLOG.info((Object)(this.getName() + " is already at position " + absolutePosition));
        } else {
            this.loader.checkConditionsForCarrierMotion();
            this.absoluteTargetPosition = absolutePosition;
            this.executeAction(FcsEnumerations.MobileItemAction.MOVE_LOADERCARRIER_TO_ABSOLUTEPOSITION, this.timeoutForGoingToStorage);
        }
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        switch (action) {
            case MOVE_LOADERCARRIER_TO_HANDOFF: {
                return this.position == this.handoffPosition;
            }
            case MOVE_LOADERCARRIER_TO_STORAGE: {
                return this.position == this.storagePosition;
            }
            case MOVE_LOADERCARRIER_TO_ABSOLUTEPOSITION: {
                return this.position == this.absoluteTargetPosition;
            }
        }
        assert (false);
        return false;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update carrier position in reading controller.")
    public void updatePosition() {
        this.position = this.carrierController.readPosition();
        this.publishData();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="To update and display position for end user.Updates carrier position in reading controller and returns it.")
    public int readPosition() {
        this.updatePosition();
        return this.position;
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() {
        try {
            this.carrierController.checkFault();
            this.position = this.carrierController.readPosition();
            this.loader.updateStateWithSensors();
            this.current = this.carrierController.readCurrent();
            this.speed = this.carrierController.readProfileVelocity();
        }
        catch (SDORequestException | ShortResponseToSDORequestException ex) {
            this.raiseWarning(FcsEnumerations.FcsAlert.SDO_ERROR, "error in updateStateWithSensorsToCheckIfActionIsCompleted:" + ex, this.getName());
        }
        catch (CanOpenCallTimeoutException ex) {
            this.raiseWarning(FcsEnumerations.FcsAlert.CAN_BUS_TIMEOUT, " error in updateStateWithSensorsToCheckIfActionIsCompleted:" + (Object)((Object)ex), this.getName());
        }
    }

    protected void updateStateWithSensors(String[] readHexaValues) {
        this.lock.lock();
        try {
            this.updatingState = true;
            this.handoffSensors.updateValues(readHexaValues);
            this.storageSensors.updateValues(readHexaValues);
        }
        finally {
            this.updatingState = false;
            this.stateUpdated.signalAll();
            this.lock.unlock();
            this.publishData();
        }
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) {
        this.carrierController.checkFault();
        if (action.equals((Object)FcsEnumerations.MobileItemAction.MOVE_LOADERCARRIER_TO_HANDOFF)) {
            this.carrierController.enableAndWriteAbsolutePosition(this.handoffPosition);
        } else if (action.equals((Object)FcsEnumerations.MobileItemAction.MOVE_LOADERCARRIER_TO_STORAGE)) {
            this.carrierController.enableAndWriteAbsolutePosition(this.storagePosition);
        } else if (action.equals((Object)FcsEnumerations.MobileItemAction.MOVE_LOADERCARRIER_TO_ABSOLUTEPOSITION)) {
            this.carrierController.enableAndWriteAbsolutePosition(this.absoluteTargetPosition);
        }
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) {
        FCSLOG.debug((Object)(this.getName() + " is ABORTING action " + action.toString() + " within delay " + delay));
        this.carrierController.off();
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) {
        FCSLOG.debug((Object)(this.getName() + " is STOPPING action " + action.toString() + " within delay " + delay));
        this.carrierController.off();
    }

    @Override
    public void postAction(FcsEnumerations.MobileItemAction action) {
        this.carrierController.off();
        FCSLOG.info((Object)(this.getName() + ":" + action.toString() + " completed - doing postAction."));
        switch (action) {
            case MOVE_LOADERCARRIER_TO_STORAGE: {
                if (this.isAtStoragePosition()) break;
                throw new FailedCommandException(this.getName() + ": storage sensors don't confirm carrier position.");
            }
            case MOVE_LOADERCARRIER_TO_HANDOFF: {
                if (this.isAtHandoffPosition()) break;
                throw new FailedCommandException(this.getName() + ": handoff sensors don't confirm carrier position.");
            }
            case MOVE_LOADERCARRIER_TO_ABSOLUTEPOSITION: {
                this.absoluteTargetPosition = 0;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Check if hardware is ready to be started.")
    public void initializeHardware() {
        this.carrierController.checkInitialized();
        this.loader.updateStateWithSensors();
        try {
            this.updatePosition();
        }
        catch (SDORequestException ex) {
            String msg = this.getName() + ": couldn't update position";
            FCSLOG.error((Object)msg);
            throw new FcsHardwareException(this.getName(), (Throwable)ex);
        }
        if (this.isAtHandoffPosition() && this.isCarrierAlmostAtPosition(this.handoffPosition)) {
            throw new FcsHardwareException(this.getName() + ": handoff sensors don't confirm position read on carrierController.");
        }
        if (this.isAtStoragePosition() && this.isCarrierAlmostAtPosition(this.storagePosition)) {
            throw new FcsHardwareException(this.getName() + ": storage sensors don't confirm position read on carrierController.");
        }
        this.initialized = true;
        this.loader.updateFCSStateToReady();
    }

    private boolean isCarrierAlmostAtPosition(int position) {
        return this.position < position - this.deltaPosition || this.position > position + this.deltaPosition;
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Return a printed list of hardware with initialization information.")
    public String printHardwareState() {
        StringBuilder sb = new StringBuilder(this.getName());
        if (this.isInitialized()) {
            sb.append(" is INITIALIZED.");
        } else {
            sb.append(" is NOT INITIALIZED.");
        }
        return sb.toString();
    }

    public void processUpdate(Observable source, Module.ValueUpdate v) {
        this.updateControllerInFault(((EPOSController)((Object)source)).getName(), v);
    }

    @Override
    public void processEmergencyMessage(EmergencyMessage msg) {
        MovedByEPOSController.super.processEmergencyMessage(msg);
        if ("ff06".equalsIgnoreCase(msg.getDeviceErrorCode())) {
            this.limitSwitchDownInError = true;
        } else if ("ff07".equals(msg.getDeviceErrorCode())) {
            this.limitSwitchUpInError = true;
        }
        this.publishData();
    }

    @Override
    public void processFaultReset() {
        MovedByEPOSController.super.processFaultReset();
        this.limitSwitchDownInError = false;
        this.limitSwitchUpInError = false;
    }

    public StatusDataPublishedByLoaderCarrier createStatusDataPublishedByLoaderCarrier() {
        StatusDataPublishedByLoaderCarrier status = new StatusDataPublishedByLoaderCarrier();
        status.setName(this.getName());
        status.setPosition(this.position);
        status.setSsiPosition(this.ssiPosition);
        status.setSpeed(this.speed);
        status.setCurrent(this.current);
        status.setHandoffSensorValue0(this.handoffSensors.isOn());
        status.setStorageSensorValue0(this.storageSensors.isOn());
        status.setHandoffInError(this.handoffSensors.isInError());
        status.setStorageInError(this.storageSensors.isInError());
        status.setControllerInError(this.controllerInFault);
        status.setLimitSwitchDownInError(this.limitSwitchDownInError);
        status.setLimitSwitchUpInError(this.limitSwitchUpInError);
        status.setHomingDone(this.initialized);
        return status;
    }

    @Override
    public void publishData() {
        StatusDataPublishedByLoaderCarrier status = this.createStatusDataPublishedByLoaderCarrier();
        KeyValueData kvd = new KeyValueData("loaderCarrier", (Serializable)status);
        this.getSubsystem().publishSubsystemDataOnStatusBus(kvd);
    }
}

