/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.util.concurrent.locks.Condition;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.AutoChangerModule;
import org.lsst.ccs.subsystems.fcs.AutochangerLatchModule;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerTwoLatches;
import org.lsst.ccs.subsystems.fcs.common.MobileItemModule;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;

public class AutochangerTwoLatches
extends MobileItemModule {
    private AutoChangerModule autochanger;
    private final AutochangerLatchModule latchXminus;
    private final AutochangerLatchModule latchXplus;
    private volatile FcsEnumerations.LockStatus lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
    private volatile FcsEnumerations.FilterPresenceStatus filterPresenceStatus = FcsEnumerations.FilterPresenceStatus.UNKNOWN;
    private final long timeoutForClosing;
    private final long timeoutForOpening;
    private final Condition stateUpdated = this.lock.newCondition();
    protected volatile boolean updatingState = false;

    public AutochangerTwoLatches(AutochangerLatchModule latchXminus, AutochangerLatchModule latchXplus) {
        this.latchXminus = latchXminus;
        this.latchXplus = latchXplus;
        this.timeoutForClosing = Math.max(latchXminus.getTimeoutForClosing(), latchXplus.getTimeoutForClosing());
        this.timeoutForOpening = Math.max(latchXminus.getTimeoutForOpening(), latchXplus.getTimeoutForOpening());
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if the 2 latches are initialized.")
    public boolean isInitialized() {
        return this.latchXminus.isInitialized() && this.latchXplus.isInitialized();
    }

    @Command(type=Command.CommandType.QUERY, description="return filterPresenceStatus")
    public FcsEnumerations.FilterPresenceStatus getFilterPresenceStatus() {
        return this.filterPresenceStatus;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return the max time for closing in millisecond.")
    public long getTimeoutForClosing() {
        return this.timeoutForClosing;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return the max time for opening in millisecond.")
    public long getTimeoutForOpening() {
        return this.timeoutForOpening;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if both latches are LOCKED.")
    public boolean isLocked() {
        return this.latchXminus.getLockStatus() == FcsEnumerations.LockStatus.LOCKED && this.latchXplus.getLockStatus() == FcsEnumerations.LockStatus.LOCKED;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if both latches are UNLOCKED.")
    public boolean isUnlocked() {
        return this.latchXminus.getLockStatus() == FcsEnumerations.LockStatus.UNLOCKED && this.latchXplus.getLockStatus() == FcsEnumerations.LockStatus.UNLOCKED;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if one of the latches is in ERROR state.")
    public boolean isInError() {
        return this.latchXminus.getLockStatus() == FcsEnumerations.LockStatus.ERROR || this.latchXplus.getLockStatus() == FcsEnumerations.LockStatus.ERROR;
    }

    private boolean isInTravel() {
        return this.latchXminus.getLockStatus() == FcsEnumerations.LockStatus.INTRAVEL && this.latchXplus.getLockStatus() == FcsEnumerations.LockStatus.INTRAVEL;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if there is no filter is latches.")
    public boolean isEmpty() {
        return this.latchXminus.isEmpty() && this.latchXplus.isEmpty();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return true if autochanger is holding a filter.")
    public boolean isHoldingFilter() {
        return this.isFilterEngaged() && this.isLocked();
    }

    private boolean isFilterEngaged() {
        return !this.latchXminus.isEmpty() && !this.latchXplus.isEmpty();
    }

    @Override
    public void initModule() {
        super.initModule();
        this.autochanger = (AutoChangerModule)this.getComponentLookup().getComponentByName("autochanger");
    }

    @Override
    public boolean isCANDevicesReady() {
        return this.autochanger.isCANDevicesReady() && this.isInitialized();
    }

    public void updateStateAndCheckSensors() {
        this.autochanger.updateStateWithSensors();
        this.latchXminus.checkSensors(FcsEnumerations.FcsAlert.AC_SENSOR_ERROR);
        this.latchXplus.checkSensors(FcsEnumerations.FcsAlert.AC_SENSOR_ERROR);
        if (this.latchXminus.getLockStatus() != this.latchXplus.getLockStatus()) {
            String msg = this.getName() + " sensors are in ERROR: latchXminus state=" + this.latchXminus.getLockStatus() + " latchXplus state=" + this.latchXplus.getLockStatus();
            this.raiseAlarm(FcsEnumerations.FcsAlert.AC_SENSOR_ERROR, msg);
            throw new FcsHardwareException(this.getName() + " LockStatus is different on both side. Can't close neither open latches.");
        }
        if (this.latchXminus.isEmpty() != this.latchXplus.isEmpty()) {
            String msg = this.getName() + " Error in filterPresenceSensors of autochanger : the 2 sensors send different values. latchXminus.isEmpty=" + this.latchXminus.isEmpty() + " latchXplus.isEmpty=" + this.latchXplus.isEmpty();
            this.raiseAlarm(FcsEnumerations.FcsAlert.AC_SENSOR_ERROR, msg);
            throw new FcsHardwareException(msg + "Can't close neither open latches.");
        }
    }

    public void updateStateWithSensors(String[] readHexaValues) {
        this.lock.lock();
        try {
            this.updatingState = true;
            this.latchXminus.updateStateWithSensors(readHexaValues);
            this.latchXplus.updateStateWithSensors(readHexaValues);
            this.computeLockStatus();
            this.computeFilterPresenceStatus();
        }
        finally {
            this.updatingState = false;
            this.stateUpdated.signalAll();
            this.lock.unlock();
            this.publishData();
        }
    }

    private void computeLockStatus() {
        this.lockStatus = this.isInError() ? FcsEnumerations.LockStatus.ERROR : (this.isLocked() ? FcsEnumerations.LockStatus.LOCKED : (this.isUnlocked() ? FcsEnumerations.LockStatus.UNLOCKED : (this.isInTravel() ? FcsEnumerations.LockStatus.INTRAVEL : FcsEnumerations.LockStatus.UNKNOWN)));
    }

    private void computeFilterPresenceStatus() {
        this.filterPresenceStatus = this.latchXminus.isEmpty() != this.latchXplus.isEmpty() ? FcsEnumerations.FilterPresenceStatus.ERROR : (this.isEmpty() ? FcsEnumerations.FilterPresenceStatus.NOFILTER : (this.isFilterEngaged() ? FcsEnumerations.FilterPresenceStatus.ENGAGED : FcsEnumerations.FilterPresenceStatus.UNKNOWN));
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() {
        this.autochanger.updateStateWithSensors();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Close latches.")
    public void close() {
        FCSLOG.info((Object)(this.getName() + " about to close."));
        this.autochanger.updateStateWithSensors();
        if (this.lockStatus == FcsEnumerations.LockStatus.LOCKED) {
            throw new RejectedCommandException(this.getName() + " are already LOCKED.");
        }
        this.autochanger.checkConditionsForClosingLatches();
        this.executeAction(FcsEnumerations.MobileItemAction.CLOSELATCHES, this.timeoutForClosing);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Open both latches.")
    public void open() {
        if (this.latchXminus.isUnlocked() && this.latchXplus.isUnlocked()) {
            throw new RejectedCommandException(this.getName() + " are already UNLOCKED.");
        }
        this.autochanger.checkConditionsForOpeningLatches();
        this.executeAction(FcsEnumerations.MobileItemAction.OPENLATCHES, this.timeoutForOpening);
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) {
        switch (action) {
            case OPENLATCHES: {
                this.latchXminus.getLatchController().enable();
                this.latchXplus.getLatchController().enable();
                this.latchXminus.getLatchController().writeCurrent(-this.latchXminus.getCurrentToClose());
                this.latchXplus.getLatchController().writeCurrent(-this.latchXplus.getCurrentToClose());
                break;
            }
            case CLOSELATCHES: {
                this.latchXminus.getLatchController().enable();
                this.latchXplus.getLatchController().enable();
                this.latchXminus.getLatchController().writeCurrent(this.latchXminus.getCurrentToClose());
                this.latchXplus.getLatchController().writeCurrent(this.latchXplus.getCurrentToClose());
                break;
            }
            default: {
                assert (false) : action;
                break;
            }
        }
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) {
        FCSLOG.debug((Object)(this.getName() + " is ABORTING action " + action.toString() + " within delay " + delay));
        this.latchXminus.getLatchController().off();
        this.latchXplus.getLatchController().off();
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void postAction(FcsEnumerations.MobileItemAction action) {
        FCSLOG.finest((Object)(this.getName() + " nothing to do in postAction"));
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        switch (action) {
            case OPENLATCHES: {
                return this.latchXminus.isUnlocked() && this.latchXplus.isUnlocked();
            }
            case CLOSELATCHES: {
                return this.latchXminus.isLocked() && this.latchXplus.isLocked();
            }
        }
        assert (false) : action;
        return false;
    }

    public StatusDataPublishedByAutochangerTwoLatches createStatusDataPublishedByTwoLatches() {
        StatusDataPublishedByAutochangerTwoLatches status = new StatusDataPublishedByAutochangerTwoLatches();
        status.setName(this.getName());
        status.setLockStatus(this.lockStatus);
        status.setFilterPresenceStatus(this.filterPresenceStatus);
        String filterName = this.autochanger.getFilterOnTrucksName() == null ? "NO FILTER" : this.autochanger.getFilterOnTrucksName();
        status.setFilterName(filterName);
        return status;
    }

    @Override
    public void publishData() {
        this.getSubsystem().publishSubsystemDataOnStatusBus(new KeyValueData("autochangerLatches", (Serializable)this.createStatusDataPublishedByTwoLatches()));
    }
}

