/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.subsystems.fcs.AutoChangerModule;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.FilterHolder;

public class AutochangerMainModule
extends MainModule {
    private final AutoChangerModule autochanger;
    private FilterHolder carousel;
    private FilterHolder loader;

    public AutochangerMainModule(BridgeToHardware bridge, AutoChangerModule autochanger) {
        super(bridge);
        this.autochanger = autochanger;
    }

    @Override
    public void initModule() {
        super.initModule();
        ComponentLookup lookup = this.getSubsystem().getComponentLookup();
        this.carousel = (FilterHolder)lookup.getComponentByName("carousel");
        this.loader = (FilterHolder)lookup.getComponentByName("loader");
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Update autochanger state in reading the sensors.")
    public void updateStateWithSensors() {
        super.updateStateWithSensors();
        this.autochanger.updateStateWithSensors();
        this.carousel.updateStateWithSensors();
        this.loader.updateStateWithSensors();
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="Update FCS state and FCS readyness state and publishes on the status bus.")
    public void updateFCSStateToReady() {
        if (this.autochanger.isInitialized() && !this.getSubsystem().isInState((Enum)AlertState.ALARM)) {
            this.getSubsystem().updateAgentState(new Enum[]{FcsEnumerations.FilterState.HARDWARE_READY, FcsEnumerations.FilterReadinessState.READY});
        }
    }
}

