/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.util.Observable;
import java.util.concurrent.locks.Condition;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.subsystems.fcs.AutoChangerModule;
import org.lsst.ccs.subsystems.fcs.ComplementarySensors;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerLatch;
import org.lsst.ccs.subsystems.fcs.common.ControlledBySensors;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.MobileItemModule;
import org.lsst.ccs.subsystems.fcs.common.MovedByEPOSController;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;

public class AutochangerLatchModule
extends MobileItemModule
implements MovedByEPOSController,
ControlledBySensors {
    private AutoChangerModule autochanger;
    private final EPOSController latchController;
    private final ComplementarySensors filterEngagedSensors;
    private final ComplementarySensors lockSensors;
    private final ComplementarySensors unlockSensors;
    @ConfigurationParameter(description="in mA current to be sent to the controller to open the latch.")
    private int currentToOpen = 300;
    @ConfigurationParameter(description="current to close Autochanger latch in mA")
    private int currentToClose = -this.currentToOpen;
    @ConfigurationParameter(description="timeout for opening a latch in milliseconds.")
    private long timeoutForOpening = 3000L;
    @ConfigurationParameter(description="timeout for closing a latch in milliseconds.")
    private long timeoutForClosing = 3000L;
    private int readCurrent;
    private FcsEnumerations.LockStatus lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
    private volatile boolean initialized;
    private final Condition stateUpdated = this.lock.newCondition();
    protected volatile boolean updatingState = false;
    private boolean controllerInFault;

    public AutochangerLatchModule(EPOSController latchController, ComplementarySensors lockSensors, ComplementarySensors unlockSensors, ComplementarySensors filterEngagedSensors) {
        this.latchController = latchController;
        this.lockSensors = lockSensors;
        this.unlockSensors = unlockSensors;
        this.filterEngagedSensors = filterEngagedSensors;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns this latch controller name.")
    public String getControllerName() {
        return this.latchController.getName();
    }

    public EPOSController getLatchController() {
        return this.latchController;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if latchController is in Fault.")
    public boolean isControllerInFault() {
        return this.controllerInFault;
    }

    @Override
    public void setControllerInFault(boolean controllerInFault) {
        this.controllerInFault = controllerInFault;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if latch is initialized.")
    public boolean isInitialized() {
        return this.initialized;
    }

    public int getCurrentToClose() {
        return this.currentToClose;
    }

    public long getTimeoutForOpening() {
        return this.timeoutForOpening;
    }

    public long getTimeoutForClosing() {
        return this.timeoutForClosing;
    }

    public FcsEnumerations.LockStatus getLockStatus() {
        this.lock.lock();
        try {
            while (this.updatingState) {
                try {
                    this.stateUpdated.await();
                }
                catch (InterruptedException ex) {
                    FCSLOG.warning((Object)(this.getName() + ": interrupted in getLockStatus."), (Throwable)ex);
                }
            }
            FcsEnumerations.LockStatus lockStatus = this.lockStatus;
            return lockStatus;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LockStatus=LOCKED. Doesn't read again sensors.", alias="isClosed")
    public boolean isLocked() {
        return this.lockSensors.isOn();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LockStatus=UNLOCKED. Doesn't read again sensors.", alias="isOpen")
    public boolean isUnlocked() {
        return this.unlockSensors.isOn();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LockStatus=ERROR, this means that unlockSensor and lockSensor return non consistant values. Doesn't read again sensors.")
    public boolean isInError() {
        return this.lockStatus == FcsEnumerations.LockStatus.ERROR;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if autochanger is empty. Doesn't read again sensors.")
    public boolean isEmpty() {
        return !this.filterEngagedSensors.isOn();
    }

    @Override
    public void initModule() {
        super.initModule();
        ComponentLookup lookup = this.getSubsystem().getComponentLookup();
        this.autochanger = (AutoChangerModule)lookup.getComponentByName("autochanger");
        if (this.latchController == null) {
            FCSLOG.error((Object)(this.getName() + "==>>> latchController == null - Please fix groovy description file."));
            throw new IllegalArgumentException(this.getName() + "==>>> null latchController - fix groovy description file.");
        }
        if (this.latchController instanceof Observable) {
            this.listens(new Observable[]{(Observable)((Object)this.latchController)});
        }
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Initialize latch controller.")
    public TreeWalkerDiag checkHardware() throws HardwareException {
        try {
            this.latchController.initializeAndCheckHardware();
            this.latchController.changeMode(EPOSEnumerations.EposMode.CURRENT);
        }
        catch (ShortResponseToSDORequestException ex) {
            FCSLOG.warning((Object)this.getName(), (Throwable)ex);
        }
        catch (FcsHardwareException ex) {
            throw new HardwareException(false, (Throwable)ex);
        }
        this.initialized = true;
        return TreeWalkerDiag.HANDLING_CHILDREN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateStateWithSensors(String[] hexaValues) {
        this.lock.lock();
        try {
            boolean inError;
            this.updatingState = true;
            this.filterEngagedSensors.updateValues(hexaValues);
            this.lockSensors.updateValues(hexaValues);
            this.unlockSensors.updateValues(hexaValues);
            boolean locked = this.lockSensors.isOn();
            boolean unlocked = this.unlockSensors.isOn();
            boolean someSensorsInError = this.filterEngagedSensors.isInError() || this.lockSensors.isInError() || this.unlockSensors.isInError();
            boolean bl = inError = locked && unlocked || someSensorsInError;
            this.lockStatus = inError ? FcsEnumerations.LockStatus.ERROR : (locked ? FcsEnumerations.LockStatus.LOCKED : (unlocked ? FcsEnumerations.LockStatus.UNLOCKED : FcsEnumerations.LockStatus.INTRAVEL));
        }
        finally {
            this.updatingState = false;
            this.stateUpdated.signalAll();
            this.lock.unlock();
            this.publishData();
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update latch current in reading controller.")
    public void updateCurrent() {
        try {
            this.readCurrent = this.latchController.readCurrent();
        }
        catch (ShortResponseToSDORequestException ex) {
            FCSLOG.warning((Object)(this.getName() + "=> ERROR IN READING CONTROLLER:"), (Throwable)ex);
        }
        this.publishData();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if autochanger CANopen hardware is connected and ready.")
    public boolean isCANDevicesReady() {
        return this.autochanger.isCANDevicesReady();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Close latch.")
    public void close() {
        this.updateStateAndCheckSensors();
        if (this.isLocked()) {
            throw new RejectedCommandException(this.getName() + " is already LOCKED.");
        }
        this.autochanger.checkConditionsForClosingLatches();
        this.executeAction(FcsEnumerations.MobileItemAction.CLOSE, this.timeoutForClosing);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Open latch.")
    public void open() {
        this.updateStateAndCheckSensors();
        if (this.isUnlocked()) {
            throw new RejectedCommandException(this.getName() + " is already UNLOCKED.");
        }
        this.autochanger.checkConditionsForOpeningLatches();
        this.executeAction(FcsEnumerations.MobileItemAction.OPEN, this.timeoutForOpening);
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        switch (action) {
            case OPEN: {
                return this.lockStatus == FcsEnumerations.LockStatus.UNLOCKED;
            }
            case CLOSE: {
                return this.lockStatus == FcsEnumerations.LockStatus.LOCKED;
            }
        }
        assert (false) : action;
        return false;
    }

    public void updateStateAndCheckSensors() {
        this.autochanger.updateStateWithSensors();
        this.checkSensors(FcsEnumerations.FcsAlert.AC_SENSOR_ERROR);
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() {
        this.autochanger.updateStateWithSensors();
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) {
        switch (action) {
            case OPEN: {
                this.latchController.enableAndWriteCurrent(this.currentToOpen);
                break;
            }
            case CLOSE: {
                this.latchController.enableAndWriteCurrent(this.currentToClose);
                break;
            }
            default: {
                assert (false) : action;
                break;
            }
        }
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) {
        FCSLOG.debug((Object)(this.getName() + " is ABORTING action " + action.toString() + " within delay " + delay));
        this.latchController.off();
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) {
        this.abortAction(action, delay);
    }

    @Override
    public void postAction(FcsEnumerations.MobileItemAction action) {
        this.latchController.writeCurrent(0);
        this.publishData();
        FCSLOG.info((Object)(this.getName() + ":" + action.toString() + " completed - doing postAction."));
    }

    public void processUpdate(Observable source, Module.ValueUpdate v) {
        this.updateControllerInFault(((EPOSController)((Object)source)).getName(), v);
    }

    public StatusDataPublishedByAutochangerLatch createStatusDataPublishedByLatch() {
        StatusDataPublishedByAutochangerLatch status = new StatusDataPublishedByAutochangerLatch();
        status.setName(this.getName());
        status.setLockSensorValue(this.lockSensors.isOn());
        status.setUnlockSensorValue(this.unlockSensors.isOn());
        status.setFilterPresenceSensorValue(this.filterEngagedSensors.isOn());
        status.setLockStatus(this.lockStatus);
        status.setControllerInFault(this.controllerInFault);
        status.setLockSensorsInError(this.lockSensors.isInError());
        status.setUnlockSensorsInError(this.unlockSensors.isInError());
        status.setFilterEngagedSensorsInError(this.filterEngagedSensors.isInError());
        status.setInError(this.lockStatus == FcsEnumerations.LockStatus.ERROR);
        return status;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Publish Data on the Status Bus.")
    public void publishData() {
        StatusDataPublishedByAutochangerLatch status = this.createStatusDataPublishedByLatch();
        this.getSubsystem().publishSubsystemDataOnStatusBus(new KeyValueData(this.getName(), (Serializable)status));
    }
}

