#import CCS Scripting Implementation                                                                                          
from org.lsst.ccs.scripting import CCS
#import the definition for a Java Exception                                                                                   
from java.lang import Exception
from org.lsst.ccs.command import CommandInvocationException

#
CCS.setThrowExceptions(True)

#####################################################################
# launch loader-standalone subsystem and initialize
#####################################################################
loaderStandalone = CCS.attachSubsystem("loader-standalone")
print "Connected to loader-standalone ", loaderStandalone

#getting timeouts
loaderConfigFuture = loaderStandalone.asynchCommandLine("getConfigurationInfo")
print "getting loader configuration info"
loaderConfig = loaderConfigFuture.get()
timeoutHandoff = loaderConfig.getCurrentValueForParameter("carrier//timeoutForGoingToHandOff")
timeoutStorage = loaderConfig.getCurrentValueForParameter("carrier//timeoutForGoingToStorage")
timeoutToOpen = loaderConfig.getCurrentValueForParameter("clamp//timeoutForOpeningHooks")

###loader
loader = CCS.attachSubsystem("loader-standalone/loader")

###carrier
carrier = CCS.attachSubsystem("loader-standalone/carrier")

##Clamp
clamp = CCS.attachSubsystem("loader-standalone/clamp")
hooksController = CCS.attachSubsystem("loader-standalone/hooksController")

###plutoGateway
plutoGateway = CCS.attachSubsystem("loader-standalone/loaderPlutoGateway")

###fake autochanger
autochanger = CCS.attachSubsystem("loader-standalone/autochanger")



##Proxy
tcpProxy = CCS.attachSubsystem("loader-standalone/loaderTcpProxy")

storagePosition=int((carrier.synchCommandLine(5, "getStoragePosition")).getResult())
print "STORAGE position=", storagePosition

handoffPosition=int((carrier.synchCommandLine(5, "getHandoffPosition")).getResult())
print "HANDOFF position=", handoffPosition

CCS.setThrowExceptions(True)

result = tcpProxy.synchCommandLine(5, "isCANDevicesReady")
if result.getResult():
    print "isCANDevicesReady=", result.getResult()
else:
    raise Exception("CANopen Hardware not ready")


############################################################################
# Check controllers and plutoGateway are READY
############################################################################
#hardware is READY 
#print "Check that controllers and plutoGateway are initialized...."
if plutoGateway.synchCommandLine(5, "isInitialized").getResult():
    print "plutoGateway.isInitialized()=", result.getResult()
else:
    raise Exception("plutoGateway not Ready")

if hooksController.synchCommandLine(5, "isInitialized").getResult():
    print "hooksController.isInitialized()=", result.getResult()
else:
    raise Exception("hooksController not Ready")
############################################################################
# Homing of clamp
############################################################################
#INITIALIZATION of the hardware of the loader clamp.

print "Initializing clamp hardware (hooksController homing)...."
print "Timeout=", timeoutToOpen
clamp.synchCommandLine(int(timeoutToOpen), "checkHardwareStateAndDoHomingIfPossible")

############################################################################
# Homing of carrier
############################################################################
#INITIALIZATION of the hardware of the loader carrier.
print "Initializing carrier hardware...."
carrier.synchCommandLine(5, "initializeHardware")

############################################################################
# Check initial conditions
############################################################################
#carrier is at Storage
if carrier.synchCommandLine(5, "isAtStoragePosition").getResult():
    print "loader carrier is at STORAGE position"
else:
    raise Exception("loader carrier is NOT at STORAGE position")

#carrier is loaded with a filter
if loader.synchCommandLine(5, "isHoldingFilter").getResult():
    print "loader is holding a filter"
else:
    raise Exception("loader is NOT holding a filter")



############################################################################
# Try to open hooks. Should not work because carrier is at Storage position
############################################################################
CCS.setThrowExceptions(False)                                                                                              
print "Trying opening Hooks...."
result = clamp.synchCommandLine(int(timeoutToOpen), "open")
if not isinstance(result.getResult(), CommandInvocationException):
     raise Exception("Clamps must not open when carrier is loaded with a filter but is not at handoff position")

############################################################################
# Load a filter into camera : 
# - Move loaded carrier from STORAGE to HANDOFF
# - simulate autochanger is holding a filter
# - Open hooks
# - Move empty carrier back to STORAGE
############################################################################
CCS.setThrowExceptions(True)
#####going to HANDOFF
print "Loader going to HANDOFF...."
carrier.synchCommandLine(int(timeoutHandoff), "goToHandoff")

#check that carrier is at HANDOFF
carrierPosition = int((carrier.synchCommandLine(5, "getPosition")).getResult())
print "carrier position =", carrierPosition
print "HANDOFF position =", handoffPosition
if carrierPosition == handoffPosition :
    print "Gone to HANDOFF"
else :
    raise Exception("Carrier is NOT at HANDOFF position")

###Simulate that autochanger is holding a filter
###ONLY for simulation
plutoGateway.synchCommandLine(5, "simulateAutochangerIsHoldingFilter")
autochanger.synchCommandLine(5, "updateStateWithSensors")
if autochanger.synchCommandLine(5, "isHoldingFilter").getResult():
    print "autochanger is holding the filter"
else:
    raise Exception("autochanger is NOT holding the filter")

###opening hooks
print "Opening hooks at HANDOFF...."
clamp.synchCommandLine(int(timeoutToOpen), "open")

###go to STORAGE
print "Loader going to STORAGE...."
carrier.synchCommandLine(int(timeoutStorage), "goToStorage")
carrierPosition = int((carrier.synchCommandLine(5, "getPosition")).getResult())
print "carrier position =", carrierPosition
print "STORAGE position =", storagePosition
if carrierPosition == storagePosition :
    print "Gone to STORAGE."
else :
    raise Exception("Carrier is NOT at STORAGE position")

############################################################################
# Unload a filter from camera : 
# - Move empty carrier from STORAGE to HANDOFF
# - simulate autochanger is holding a filter
# - close hooks
# - simulate autochanger is not holding the filter
# - clamp hooks
# - Move loaded carrier back to STORAGE
############################################################################
#####going to HANDOFF
print "Loader going to HANDOFF...."
carrier.synchCommandLine(int(timeoutHandoff), "goToHandoff")

###opening hooks
print "Closing hooks at HANDOFF...."
clamp.synchCommandLine(int(timeoutToOpen), "close")

###Simulate that autochanger is not holding a filter
###ONLY for simulation
plutoGateway.synchCommandLine(5, "simulateAutochangerIsNotHoldingFilter")
autochanger.synchCommandLine(5, "updateStateWithSensors")

if autochanger.synchCommandLine(5, "isHoldingFilter").getResult():
    raise Exception("autochanger is STILL holding the filter")
else:
    print "autochanger is not holding the filter"

###clamping hooks
print "Clamping hooks at HANDOFF...."
clamp.synchCommandLine(int(timeoutToOpen), "clamp")

###go to STORAGE
print "Loader going to STORAGE...."
carrier.synchCommandLine(int(timeoutStorage), "goToStorage")
carrierPosition = int((carrier.synchCommandLine(5, "getPosition")).getResult())
print "carrier position =", carrierPosition
print "STORAGE position =", storagePosition
if carrierPosition == storagePosition :
    print "Gone to STORAGE"
else :
    raise Exception("Carrier is NOT at STORAGE position")

############################################################################
#test stop and halt commands
############################################################################
loaderStandalone.synchCommandLine(5, "stop")

if autochanger.synchCommandLine(5, "isHoldingFilter").getResult():
    raise Exception("autochanger is STILL holding the filter")
else:
    print "autochanger is not holding the filter"

