#################################################################################
#Script to test the whole fcs simulated hardware (carousel, autochanger, loader).
#This test is a part of integration tests.
#################################################################################
#import CCS Scripting Implementation                                                                                          
from org.lsst.ccs.scripting import CCS
#import the definition for a Java Exception                                                                                   
from java.lang import Exception
from org.lsst.ccs.command import CommandInvocationException

#
CCS.setThrowExceptions(True)

fcs = CCS.attachSubsystem("fcs")
print "Connected to fcs for Whole simulated hardware.", fcs

###Filters###
filterMng = CCS.attachSubsystem("fcs/filterManager")
result = filterMng.synchCommandLine(5, "toString")
print "### Filter Manager:", result.getResult()
print "### end Filter Manager"
###end Filters###

#getting timeouts
fcsConfigFuture = fcs.asynchCommandLine("getConfigurationInfo")
print "getting fcs subsystem configuration"
fcsConfig = fcsConfigFuture.get()

print "FCS config =", fcsConfig.toString()

CCS.setThrowExceptions(False)

#Handle the thrown exceptions                                                                                                 
print "read sensors and update state "
result = fcs.synchCommandLine(3000, "updateStateWithSensors")

if isinstance(result.getResult(), CommandInvocationException):
     raise Exception(result.getResult())

print "FCS Subsystem state has been updated"
CCS.setThrowExceptions(True)

print "FCS setFilter U"
fcs.synchCommandLine(100000, "setFilter U")
